/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.apache.ApacheServerComponent;
import org.rhq.plugins.apache.util.HttpdConfParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModJKComponent
implements ResourceComponent<ApacheServerComponent> {
    private static final Log log = LogFactory.getLog(ModJKComponent.class);
    private static final String OUTPUT_RESULT_PROP = "output";

    public void start(ResourceContext<ApacheServerComponent> parentResourceContext) throws InvalidPluginConfigurationException, Exception {
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        return AvailabilityType.UP;
    }

    public static OperationResult installModJk(ApacheServerComponent serverComponent, Configuration params) throws Exception {
        StringBuilder builder = new StringBuilder();
        boolean errorSeen = false;
        boolean needWorkersProps = false;
        boolean needUriWorkers = false;
        File httpdConf = serverComponent.getHttpdConfFile();
        String confPath = httpdConf.getAbsolutePath();
        if (!httpdConf.canWrite()) {
            throw new Exception("Httpd.conf is not writable at " + confPath);
        }
        HttpdConfParser cparser = new HttpdConfParser();
        cparser.parse(confPath);
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(httpdConf, true));
            if (cparser.isModJkInstalled()) {
                builder.append("Mod_jk is already installed\n");
                if (cparser.getWorkerPropertiesFile() != null) {
                    builder.append("Found a worker.properties file at ").append(cparser.getWorkerPropertiesFile());
                    builder.append("\n");
                } else {
                    needWorkersProps = true;
                }
                if (cparser.getUriWorkerLocation() != null) {
                    builder.append("Found a urimap file at ").append(cparser.getUriWorkerLocation());
                } else {
                    needUriWorkers = true;
                }
            } else {
                builder.append("No mod_jk installed yet at ").append(confPath).append("\n");
                writer.append("LoadModule jk_module modules/mod_jk.so");
                writer.newLine();
                builder.append(".. written a LoadModule line \n");
                needWorkersProps = true;
                needUriWorkers = true;
            }
            if (needWorkersProps) {
                writer.append("JkWorkersFile ").append("conf/workers.properties");
                writer.newLine();
                builder.append(".. installed worker.properties");
            }
            if (needUriWorkers) {
                writer.append("JkMountFile ").append("conf/uriworkermap");
                writer.newLine();
                builder.append(".. installed uriworkermap");
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            builder.append("Error when installing mod_jk: \n");
            builder.append(e.fillInStackTrace());
            throw new Exception(builder.toString());
        }
        OperationResult result = new OperationResult();
        Configuration complexResults = result.getComplexResults();
        complexResults.put((Property)new PropertySimple(OUTPUT_RESULT_PROP, (Object)builder.toString()));
        return result;
    }
}

