/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.augeas.AugeasException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.augeas.AugeasProxy;
import org.rhq.augeas.config.AugeasConfiguration;
import org.rhq.augeas.node.AugeasNode;
import org.rhq.augeas.tree.AugeasTree;
import org.rhq.augeas.tree.AugeasTreeBuilder;
import org.rhq.augeas.util.Glob;
import org.rhq.augeas.util.GlobFilter;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.util.FileUtils;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.apache.ApacheServerComponent;
import org.rhq.plugins.apache.augeas.AugeasConfigurationApache;
import org.rhq.plugins.apache.augeas.AugeasTreeBuilderApache;
import org.rhq.plugins.apache.util.ApacheBinaryInfo;
import org.rhq.plugins.apache.util.AugeasNodeValueUtil;
import org.rhq.plugins.apache.util.HttpdAddressUtility;
import org.rhq.plugins.apache.util.OsProcessUtility;
import org.rhq.plugins.platform.PlatformComponent;
import org.rhq.plugins.www.snmp.SNMPClient;
import org.rhq.plugins.www.snmp.SNMPException;
import org.rhq.plugins.www.snmp.SNMPSession;
import org.rhq.plugins.www.snmp.SNMPValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheServerDiscoveryComponent
implements ResourceDiscoveryComponent<PlatformComponent>,
ManualAddFacet<PlatformComponent> {
    private static final String PRODUCT_DESCRIPTION = "Apache Web Server";
    private static final Log log = LogFactory.getLog(ApacheServerDiscoveryComponent.class);

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<PlatformComponent> discoveryContext) throws Exception {
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        List processes = discoveryContext.getAutoDiscoveredProcesses();
        for (ProcessScanResult process : processes) {
            ApacheBinaryInfo binaryInfo;
            String executableName = ApacheServerDiscoveryComponent.getExecutableName(process);
            File executablePath = OsProcessUtility.getProcExe(process.getProcessInfo().getPid(), executableName);
            if (executablePath == null) {
                log.error((Object)("Executable path could not be determined for Apache [" + process.getProcessInfo() + "]."));
                continue;
            }
            if (!executablePath.isAbsolute()) {
                log.error((Object)("Executable path (" + executablePath + ") is not absolute for Apache [" + process.getProcessInfo() + "]." + "Please restart Apache specifying an absolute path for the executable."));
                continue;
            }
            log.debug((Object)("Apache executable path: " + executablePath));
            try {
                binaryInfo = ApacheBinaryInfo.getInfo(executablePath.getPath(), discoveryContext.getSystemInformation());
            }
            catch (Exception e) {
                log.error((Object)("'" + executablePath + "' is not a valid Apache executable (" + e + ")."));
                continue;
            }
            if (!this.isSupportedVersion(binaryInfo.getVersion())) continue;
            String serverRoot = this.getServerRoot(binaryInfo, process.getProcessInfo());
            if (serverRoot == null) {
                log.error((Object)("Unable to determine server root for Apache process: " + process.getProcessInfo()));
                continue;
            }
            File serverConfigFile = this.getServerConfigFile(binaryInfo, process.getProcessInfo(), serverRoot);
            if (serverConfigFile == null) {
                log.error((Object)("Unable to determine server config file for Apache process: " + process.getProcessInfo()));
                continue;
            }
            Configuration pluginConfig = discoveryContext.getDefaultPluginConfiguration();
            PropertySimple executablePathProp = new PropertySimple("executablePath", (Object)executablePath);
            pluginConfig.put((Property)executablePathProp);
            PropertySimple serverRootProp = new PropertySimple("serverRoot", (Object)serverRoot);
            pluginConfig.put((Property)serverRootProp);
            PropertySimple configFile = new PropertySimple("configFile", (Object)serverConfigFile);
            pluginConfig.put((Property)configFile);
            PropertySimple inclusionGlobs = new PropertySimple("configurationFilesInclusionPatterns", (Object)serverConfigFile);
            pluginConfig.put((Property)inclusionGlobs);
            AugeasTree serverConfig = ApacheServerDiscoveryComponent.loadAugeas(pluginConfig);
            String serverUrl = null;
            String vhostsGlobInclude = null;
            if (serverConfig != null) {
                List serverRoots = serverConfig.matchRelative(serverConfig.getRootNode(), "ServerRoot/param");
                if (!serverRoots.isEmpty()) {
                    serverRoot = AugeasNodeValueUtil.unescape(((AugeasNode)serverRoots.get(0)).getValue());
                    serverRootProp.setValue((Object)serverRoot);
                }
                serverUrl = ApacheServerDiscoveryComponent.getUrl(serverConfig, binaryInfo.getVersion());
                vhostsGlobInclude = ApacheServerDiscoveryComponent.scanForGlobInclude(serverConfig);
            } else {
                serverUrl = ApacheServerDiscoveryComponent.getUrl(pluginConfig);
                vhostsGlobInclude = "--none--";
            }
            if (serverUrl != null) {
                PropertySimple urlProp = new PropertySimple("url", (Object)serverUrl);
                pluginConfig.put((Property)urlProp);
            }
            if (vhostsGlobInclude != null) {
                pluginConfig.put((Property)new PropertySimple("vhostFilesMask", (Object)vhostsGlobInclude));
            } else if (serverConfigFile.exists()) {
                pluginConfig.put((Property)new PropertySimple("vhostFilesMask", (Object)(serverConfigFile.getParent() + File.separator + "*")));
            }
            discoveredResources.add(this.createResourceDetails(discoveryContext, pluginConfig, process.getProcessInfo(), binaryInfo));
        }
        return discoveredResources;
    }

    public DiscoveredResourceDetails discoverResource(Configuration pluginConfig, ResourceDiscoveryContext<PlatformComponent> discoveryContext) throws InvalidPluginConfigurationException {
        ApacheBinaryInfo binaryInfo;
        ApacheServerDiscoveryComponent.validateServerRootAndServerConfigFile(pluginConfig);
        String executablePath = pluginConfig.getSimpleValue("executablePath", ApacheServerComponent.DEFAULT_EXECUTABLE_PATH);
        String absoluteExecutablePath = ApacheServerComponent.resolvePathRelativeToServerRoot(pluginConfig, executablePath).getPath();
        try {
            binaryInfo = ApacheBinaryInfo.getInfo(absoluteExecutablePath, discoveryContext.getSystemInformation());
        }
        catch (Exception e) {
            throw new InvalidPluginConfigurationException("'" + absoluteExecutablePath + "' is not a valid Apache executable (" + e + "). Please make sure the '" + "executablePath" + "' connection property is set correctly.");
        }
        if (!this.isSupportedVersion(binaryInfo.getVersion())) {
            throw new InvalidPluginConfigurationException("Version of Apache executable (" + binaryInfo.getVersion() + ") is not a supported version; supported versions are 1.3.x and 2.x.");
        }
        ProcessInfo processInfo = null;
        try {
            DiscoveredResourceDetails resourceDetails = this.createResourceDetails(discoveryContext, pluginConfig, processInfo, binaryInfo);
            return resourceDetails;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create resource details during manual add.");
        }
    }

    private boolean isSupportedVersion(String version) {
        return version != null && (version.startsWith("1.3") || version.startsWith("2."));
    }

    private DiscoveredResourceDetails createResourceDetails(ResourceDiscoveryContext<PlatformComponent> discoveryContext, Configuration pluginConfig, ProcessInfo processInfo, ApacheBinaryInfo binaryInfo) throws Exception {
        String name;
        String httpdConf = pluginConfig.getSimple("configFile").getStringValue();
        String version = binaryInfo.getVersion();
        String serverUrl = pluginConfig.getSimpleValue("url", null);
        if (serverUrl == null) {
            name = httpdConf;
        } else {
            URI uri = new URI(serverUrl);
            name = uri.getHost() + ":" + uri.getPort();
        }
        DiscoveredResourceDetails resourceDetails = new DiscoveredResourceDetails(discoveryContext.getResourceType(), httpdConf, name, version, PRODUCT_DESCRIPTION, pluginConfig, processInfo);
        log.debug((Object)("Apache Server resource details created: " + resourceDetails));
        return resourceDetails;
    }

    private static String getUrl(AugeasTree serverConfig, String version) throws Exception {
        HttpdAddressUtility.Address addr = HttpdAddressUtility.get(version).getMainServerSampleAddress(serverConfig);
        return addr == null ? null : "http://" + addr.host + ":" + addr.port + "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUrl(Configuration pluginConfiguration) throws Exception {
        SNMPClient snmpClient = new SNMPClient();
        try {
            SNMPValue portValue;
            SNMPValue nameValue;
            SNMPSession snmpSession = ApacheServerComponent.getSNMPSession(snmpClient, pluginConfiguration);
            if (!snmpSession.ping()) {
                String string = null;
                return string;
            }
            try {
                nameValue = snmpSession.getNextValue("wwwServiceName");
            }
            catch (SNMPException e) {
                throw new Exception("Error getting SNMP value: wwwServiceName: " + e.getMessage(), e);
            }
            try {
                portValue = snmpSession.getNextValue("wwwServiceProtocol");
            }
            catch (SNMPException e) {
                throw new Exception("Error getting SNMP column: wwwServiceProtocol: " + e.getMessage(), e);
            }
            String host = nameValue.toString();
            String fullPort = portValue.toString();
            int port = Integer.parseInt(fullPort.substring(fullPort.lastIndexOf(".") + 1));
            String string = "http://" + host + ":" + port + "/";
            return string;
        }
        finally {
            snmpClient.close();
        }
    }

    @Nullable
    private String getServerRoot(@NotNull ApacheBinaryInfo binaryInfo, @NotNull ProcessInfo processInfo) {
        String[] cmdLine = processInfo.getCommandLine();
        String root = this.getCommandLineOption(cmdLine, "-d");
        if (root == null) {
            root = binaryInfo.getRoot();
        }
        if (root == null) {
            return null;
        }
        File rootFile = new File(root);
        if (!rootFile.isAbsolute()) {
            String currentWorkingDir;
            try {
                currentWorkingDir = processInfo.getCurrentWorkingDirectory();
            }
            catch (Exception e) {
                log.error((Object)("Unable to determine current working directory of Apache process [" + processInfo + "], which is needed to determine the server root of the Apache instance."), (Throwable)e);
                return null;
            }
            if (currentWorkingDir == null) {
                log.error((Object)("Unable to determine current working directory of Apache process [" + processInfo + "], which is needed to determine the server root of the Apache instance."));
                return null;
            }
            rootFile = new File(currentWorkingDir, root);
            root = rootFile.getPath();
        }
        root = FileUtils.getCanonicalPath((String)root);
        return root;
    }

    @Nullable
    private File getServerConfigFile(ApacheBinaryInfo binaryInfo, ProcessInfo processInfo, String serverRoot) {
        String[] cmdLine = processInfo.getCommandLine();
        String serverConfigFile = this.getCommandLineOption(cmdLine, "-f");
        if (serverConfigFile == null) {
            serverConfigFile = binaryInfo.getCtl();
        }
        if (serverConfigFile == null) {
            return null;
        }
        File file = new File(serverConfigFile);
        if (!file.isAbsolute()) {
            file = new File(serverRoot, serverConfigFile);
            serverConfigFile = file.getPath();
        }
        serverConfigFile = FileUtils.getCanonicalPath((String)serverConfigFile);
        return new File(serverConfigFile);
    }

    private String getCommandLineOption(String[] cmdLine, String option) {
        String root = null;
        for (int i = 1; i < cmdLine.length; ++i) {
            String arg = cmdLine[i];
            if (!arg.startsWith(option)) continue;
            root = arg.substring(2, arg.length());
            if (root.length() != 0) break;
            root = cmdLine[i + 1];
            break;
        }
        return root;
    }

    private static String getExecutableName(ProcessScanResult processScanResult) {
        String query = processScanResult.getProcessScan().getQuery().toLowerCase();
        String executableName = query.contains("apache.exe") ? "apache.exe" : (query.contains("httpd.exe") ? "httpd.exe" : (query.contains("apache2") ? "apache2" : (query.contains("httpd") ? "httpd" : null)));
        return executableName;
    }

    private static void validateServerRootAndServerConfigFile(Configuration pluginConfig) {
        File httpdConfFile;
        File serverRootFile;
        String serverRoot = pluginConfig.getSimple("serverRoot").getStringValue();
        try {
            serverRootFile = new File(serverRoot).getCanonicalFile();
        }
        catch (IOException e) {
            serverRootFile = null;
        }
        if (serverRootFile == null || !serverRootFile.isDirectory()) {
            throw new InvalidPluginConfigurationException("'" + serverRoot + "' does not exist or is not a directory. Please make sure the '" + "serverRoot" + "' connection property is set correctly.");
        }
        String httpdConf = pluginConfig.getSimple("configFile").getStringValue();
        try {
            httpdConfFile = new File(httpdConf).getCanonicalFile();
        }
        catch (IOException e) {
            httpdConfFile = null;
        }
        if (httpdConfFile == null || !httpdConfFile.isFile()) {
            throw new InvalidPluginConfigurationException("'" + httpdConf + "' does not exist or is not a regular file. Please make sure the '" + "configFile" + "' connection property is set correctly.");
        }
    }

    private static AugeasTree loadAugeas(Configuration pluginConfiguration) {
        try {
            AugeasConfigurationApache config = new AugeasConfigurationApache(pluginConfiguration);
            String moduleName = config.getAugeasModuleName();
            AugeasTreeBuilderApache builder = new AugeasTreeBuilderApache();
            AugeasProxy augeasProxy = new AugeasProxy((AugeasConfiguration)config, (AugeasTreeBuilder)builder);
            augeasProxy.load();
            return augeasProxy.getAugeasTree(moduleName, true);
        }
        catch (AugeasException e) {
            log.warn((Object)"Augeas not installed.");
            return null;
        }
    }

    public static String scanForGlobInclude(AugeasTree tree) {
        try {
            List includes = tree.match("//Include/param");
            block2: for (AugeasNode n : includes) {
                String include = n.getValue();
                if (!Glob.isWildcard((String)include)) continue;
                for (char specialChar : GlobFilter.WILDCARD_CHARS) {
                    if (specialChar == '*') {
                        if (include.indexOf(specialChar) != include.lastIndexOf(specialChar)) continue block2;
                        return include;
                    }
                    if (include.indexOf(specialChar) >= 0) continue block2;
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)"Failed to detect glob includes in httpd.conf.", (Throwable)e);
        }
        return null;
    }
}

