/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.rhq.augeas.node.AugeasNode;
import org.rhq.augeas.tree.AugeasTree;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.apache.ApacheVirtualHostServiceComponent;
import org.rhq.plugins.apache.util.AugeasNodeSearch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheIfModuleDiscoveryComponent
implements ResourceDiscoveryComponent<ApacheVirtualHostServiceComponent> {
    private static final String[] parentRes = new String[]{"<IfModule"};
    private static final String IFMODULE_NODE_NAME = "<IfModule";
    private AugeasTree tree;
    private AugeasNode parentNode;

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ApacheVirtualHostServiceComponent> context) throws InvalidPluginConfigurationException, Exception {
        ApacheVirtualHostServiceComponent virtualHost = (ApacheVirtualHostServiceComponent)context.getParentResourceComponent();
        this.tree = virtualHost.getServerConfigurationTree();
        this.parentNode = virtualHost.getNode(this.tree);
        List<AugeasNode> ifModuleNodes = AugeasNodeSearch.searchNode(parentRes, IFMODULE_NODE_NAME, this.parentNode);
        LinkedHashSet<DiscoveredResourceDetails> discoveredResources = new LinkedHashSet<DiscoveredResourceDetails>();
        ResourceType resourceType = context.getResourceType();
        for (AugeasNode node : ifModuleNodes) {
            String resourceKey = AugeasNodeSearch.getParamsString(node, this.parentNode);
            int separatorPosition = resourceKey.indexOf(";");
            String resourceName = null;
            resourceName = separatorPosition != -1 ? resourceKey.substring(0, separatorPosition) : resourceKey.toString();
            discoveredResources.add(new DiscoveredResourceDetails(resourceType, resourceKey, resourceName, null, null, null, null));
        }
        return discoveredResources;
    }
}

