/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.rhq.augeas.node.AugeasNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AugeasNodeSearch {
    public static String[] NESTED_DIRECTIVES = new String[]{"<IfModule", "<Directive", "<VirtualHost", "<Files"};

    public static List<AugeasNode> searchNode(String[] parentNodeNames, String nodeName, AugeasNode startNode) {
        ArrayList<AugeasNode> nodes = new ArrayList<AugeasNode>();
        AugeasNodeSearch.search(nodes, parentNodeNames, startNode, nodeName);
        return nodes;
    }

    private static void search(List<AugeasNode> nodes, String[] parentNodeNames, AugeasNode node, String name) {
        nodes.addAll(node.getChildByLabel(name));
        for (String parentNodeName : parentNodeNames) {
            List nds = node.getChildByLabel(parentNodeName);
            for (AugeasNode tempNode : nds) {
                AugeasNodeSearch.search(nodes, parentNodeNames, tempNode, name);
            }
        }
    }

    public static List<AugeasNode> getNodeByParentParams(AugeasNode parentNode, String nodeName, List<String> nodeParams) {
        List<AugeasNode> searchedNodes = AugeasNodeSearch.searchNode(NESTED_DIRECTIVES, nodeName, parentNode);
        ArrayList<AugeasNode> results = new ArrayList<AugeasNode>();
        Iterator<AugeasNode> i$ = searchedNodes.iterator();
        while (i$.hasNext()) {
            AugeasNode node;
            AugeasNode tempNode = node = i$.next();
            boolean match = true;
            int i = 0;
            while (match & i < nodeParams.size() & tempNode != parentNode) {
                List childNodes = tempNode.getChildByLabel("param");
                if (childNodes.size() > 0) {
                    if (!nodeParams.get(i).equals(((AugeasNode)childNodes.get(0)).getValue())) {
                        match = false;
                    }
                } else {
                    match = false;
                }
                ++i;
                tempNode = tempNode.getParentNode();
            }
            if (!match) continue;
            results.add(node);
        }
        return results;
    }

    public static List<String> getParams(AugeasNode node, AugeasNode parentNode) {
        ArrayList<String> res = new ArrayList<String>();
        AugeasNode pNode = node;
        while (!pNode.equals(parentNode)) {
            List paramNodes = pNode.getChildByLabel("param");
            for (AugeasNode param : paramNodes) {
                res.add(param.getValue());
            }
            pNode = pNode.getParentNode();
        }
        return res;
    }

    public static String getParamsString(AugeasNode node, AugeasNode parentNode) {
        StringBuffer str = new StringBuffer();
        AugeasNode pNode = node;
        while (!pNode.equals(parentNode)) {
            List paramNodes = pNode.getChildByLabel("param");
            for (AugeasNode param : paramNodes) {
                str.append(param.getValue() + ";");
            }
            pNode = pNode.getParentNode();
        }
        return str.toString();
    }
}

