/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.augeas.node.AugeasNode;
import org.rhq.augeas.tree.AugeasTree;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.apache.ApacheVirtualHostServiceComponent;
import org.rhq.plugins.apache.mapping.ApacheAugeasMapping;
import org.rhq.plugins.apache.util.AugeasNodeSearch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheDirectoryComponent
implements ResourceComponent<ApacheVirtualHostServiceComponent>,
ConfigurationFacet,
DeleteResourceFacet {
    private final Log log = LogFactory.getLog(this.getClass());
    public static final String DIRECTIVE_INDEX_PROP = "directiveIndex";
    public static final String REGEXP_PROP = "regexp";
    public static final String PARAMS_PROPERTY_NAME = "ifmoduleParams";
    public static final String DIRECTORY_DIRECTIVE = "<Directory";
    private List<String> position;
    private ResourceContext<ApacheVirtualHostServiceComponent> resourceContext;

    public void start(ResourceContext<ApacheVirtualHostServiceComponent> context) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = context;
        String key = context.getResourceKey();
        this.position = new ArrayList<String>();
        String param = key.substring(0, key.indexOf("|"));
        for (String pm : param.split(";")) {
            this.position.add(pm);
        }
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        return AvailabilityType.UP;
    }

    public Configuration loadResourceConfiguration() throws Exception {
        ApacheVirtualHostServiceComponent parentVirtualHost = (ApacheVirtualHostServiceComponent)this.resourceContext.getParentResourceComponent();
        AugeasTree tree = parentVirtualHost.getServerConfigurationTree();
        ConfigurationDefinition resourceConfigDef = this.resourceContext.getResourceType().getResourceConfigurationDefinition();
        AugeasNode virtualHostNode = parentVirtualHost.getNode(tree);
        ApacheAugeasMapping mapping = new ApacheAugeasMapping(tree);
        return mapping.updateConfiguration(this.getNode(virtualHostNode), resourceConfigDef);
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        ApacheVirtualHostServiceComponent parentVirtualHost = (ApacheVirtualHostServiceComponent)this.resourceContext.getParentResourceComponent();
        AugeasTree tree = null;
        try {
            tree = parentVirtualHost.getServerConfigurationTree();
            ConfigurationDefinition resourceConfigDef = this.resourceContext.getResourceType().getResourceConfigurationDefinition();
            ApacheAugeasMapping mapping = new ApacheAugeasMapping(tree);
            AugeasNode directoryNode = this.getNode(tree.getRootNode());
            mapping.updateAugeas(directoryNode, report.getConfiguration(), resourceConfigDef);
            tree.save();
            report.setStatus(ConfigurationUpdateStatus.SUCCESS);
            this.log.info((Object)"Apache configuration was updated");
            ((ApacheVirtualHostServiceComponent)this.resourceContext.getParentResourceComponent()).finishConfigurationUpdate(report);
        }
        catch (Exception e) {
            if (tree != null) {
                this.log.error((Object)("Augeas failed to save configuration " + tree.summarizeAugeasError()));
            } else {
                this.log.error((Object)"Augeas failed to save configuration", (Throwable)e);
            }
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
        }
    }

    public void deleteResource() throws Exception {
        AugeasTree tree;
        ApacheVirtualHostServiceComponent parentVirtualHost = (ApacheVirtualHostServiceComponent)this.resourceContext.getParentResourceComponent();
        AugeasNode virtualHostNode = parentVirtualHost.getNode(tree = parentVirtualHost.getServerConfigurationTree());
        AugeasNode myNode = this.getNode(virtualHostNode);
        if (myNode != null) {
            tree.removeNode(myNode, true);
            tree.save();
            ApacheVirtualHostServiceComponent parentVhost = (ApacheVirtualHostServiceComponent)this.resourceContext.getParentResourceComponent();
            parentVhost.deleteEmptyFile(tree, myNode);
            parentVhost.conditionalRestart();
        } else {
            this.log.info((Object)("Could find the configuration corresponding to the directory " + this.resourceContext.getResourceKey() + ". Ignoring."));
        }
    }

    public AugeasNode getNode(AugeasNode virtualHost) {
        List<AugeasNode> directories = AugeasNodeSearch.getNodeByParentParams(virtualHost, DIRECTORY_DIRECTIVE, this.position);
        int index = this.resourceContext.getPluginConfiguration().getSimple(DIRECTIVE_INDEX_PROP).getIntegerValue();
        for (AugeasNode dir : directories) {
            if (dir.getSeq() != index) continue;
            return dir;
        }
        return null;
    }

    public AugeasNode getNode() {
        ApacheVirtualHostServiceComponent virtHost = (ApacheVirtualHostServiceComponent)this.resourceContext.getParentResourceComponent();
        AugeasTree tree = virtHost.getServerConfigurationTree();
        AugeasNode virtHostNode = ((ApacheVirtualHostServiceComponent)this.resourceContext.getParentResourceComponent()).getNode(tree);
        return this.getNode(virtHostNode);
    }

    public AugeasTree getServerConfigurationTree() {
        return ((ApacheVirtualHostServiceComponent)this.resourceContext.getParentResourceComponent()).getServerConfigurationTree();
    }

    public void finishConfigurationUpdate(ConfigurationUpdateReport report) {
        ((ApacheVirtualHostServiceComponent)this.resourceContext.getParentResourceComponent()).finishConfigurationUpdate(report);
    }
}

