/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.pluginapi.event.log.MultiLineLogEntryProcessor;

public class ApacheErrorLogEntryProcessor
extends MultiLineLogEntryProcessor {
    private static final String REGEX = "\\[(.*)\\] \\[(debug|info|notice|warn|error|crit|alert|emerg)\\] (.*)";
    private static final Pattern PATTERN = Pattern.compile("\\[(.*)\\] \\[(debug|info|notice|warn|error|crit|alert|emerg)\\] (.*)");
    private static final String DATE_PATTERN = "EEE MMM dd kk:mm:ss yyyy";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE MMM dd kk:mm:ss yyyy");
    private static final Map<SeverityLevel, EventSeverity> LEVEL_TO_SEVERITY_MAP = new LinkedHashMap<SeverityLevel, EventSeverity>();

    public ApacheErrorLogEntryProcessor(String eventType, File logFile) {
        super(eventType, logFile);
    }

    protected Pattern getPattern() {
        return PATTERN;
    }

    protected DateFormat getDefaultDateFormat() {
        return DATE_FORMAT;
    }

    protected MultiLineLogEntryProcessor.LogEntry processPrimaryLine(Matcher matcher) throws MultiLineLogEntryProcessor.ParseException {
        SeverityLevel severityLevel;
        String dateString = matcher.group(1);
        Date timestamp = this.parseDateString(dateString);
        String severityLevelString = matcher.group(2);
        try {
            severityLevel = SeverityLevel.valueOf(severityLevelString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new MultiLineLogEntryProcessor.ParseException("Unknown severity level: " + severityLevelString);
        }
        EventSeverity severity = LEVEL_TO_SEVERITY_MAP.get((Object)severityLevel);
        String detail = matcher.group(3);
        return new MultiLineLogEntryProcessor.LogEntry(timestamp, severity, detail);
    }

    static {
        LEVEL_TO_SEVERITY_MAP.put(SeverityLevel.DEBUG, EventSeverity.DEBUG);
        LEVEL_TO_SEVERITY_MAP.put(SeverityLevel.INFO, EventSeverity.INFO);
        LEVEL_TO_SEVERITY_MAP.put(SeverityLevel.NOTICE, EventSeverity.INFO);
        LEVEL_TO_SEVERITY_MAP.put(SeverityLevel.WARN, EventSeverity.WARN);
        LEVEL_TO_SEVERITY_MAP.put(SeverityLevel.ERROR, EventSeverity.ERROR);
        LEVEL_TO_SEVERITY_MAP.put(SeverityLevel.CRIT, EventSeverity.FATAL);
        LEVEL_TO_SEVERITY_MAP.put(SeverityLevel.ALERT, EventSeverity.FATAL);
        LEVEL_TO_SEVERITY_MAP.put(SeverityLevel.EMERG, EventSeverity.FATAL);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SeverityLevel {
        DEBUG,
        INFO,
        NOTICE,
        WARN,
        ERROR,
        CRIT,
        ALERT,
        EMERG;

    }
}

