/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bundle.ant.type;

import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.rhq.bundle.ant.type.AbstractFileType;
import org.rhq.bundle.ant.type.FileSet;
import org.rhq.bundle.ant.type.Handover;
import org.rhq.bundle.ant.type.HandoverHolder;
import org.rhq.bundle.ant.type.ReplaceType;

public class ArchiveType
extends AbstractFileType {
    private File destinationDir;
    private Pattern replacePattern;
    private String exploded;
    private HandoverHolder handoverHolder = new HandoverHolder();

    public File getDestinationDir() {
        return this.destinationDir;
    }

    public void setDestinationDir(String destinationDir) {
        this.destinationDir = new File(destinationDir);
        this.ensureHandoverOrDestinationIsConfigured();
    }

    public void addConfigured(ReplaceType replace) {
        List<FileSet> fileSets = replace.getFileSets();
        this.replacePattern = ArchiveType.getPattern(fileSets);
    }

    public Pattern getReplacePattern() {
        return this.replacePattern;
    }

    public String getExploded() {
        return null == this.exploded ? Boolean.TRUE.toString() : this.exploded;
    }

    public void setExploded(String exploded) {
        if (!Boolean.TRUE.toString().equalsIgnoreCase(exploded) && !Boolean.FALSE.toString().equalsIgnoreCase(exploded)) {
            throw new BuildException("'exploded' attribute must be 'true' or 'false': " + exploded);
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(exploded) && null != this.destinationDir) {
            throw new BuildException("'exploded' attribute must be 'false' when setting 'destinationDir', which has been set to: " + this.destinationDir);
        }
        this.exploded = exploded;
        this.ensureHandoverOrExplodedIsConfigured();
    }

    @Override
    public void addConfigured(Handover handover) {
        this.handoverHolder.addConfigured(handover);
        this.ensureHandoverOrDestinationIsConfigured();
        this.ensureHandoverOrExplodedIsConfigured();
    }

    @Override
    public Handover getHandover() {
        return this.handoverHolder.getHandover();
    }

    private void ensureHandoverOrDestinationIsConfigured() {
        if (this.handoverHolder.getHandover() != null && this.destinationDir != null) {
            throw new BuildException("Configure either handover or destination");
        }
    }

    private void ensureHandoverOrExplodedIsConfigured() {
        if (this.handoverHolder.getHandover() != null && this.exploded != null) {
            throw new BuildException("Configure either handover or exploded");
        }
    }
}

