/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.modcluster;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.plugins.modcluster.ClassNameMBeanComponent;
import org.rhq.plugins.modcluster.ModClusterServerComponent;
import org.rhq.plugins.modcluster.config.ModClusterBeanFile;

public class FileConfiguredMBeanResourceComponent
extends ClassNameMBeanComponent {
    private static final Log log = LogFactory.getLog(FileConfiguredMBeanResourceComponent.class);
    private static final String BEAN_CLASS_NAME_PROPERTY = "className";
    private static final String DEPENDENCY_BEAN_CLASS_NAME_PROPERTY = "dependencyClassName";
    private static final String MOD_CLUSTER_CONFIG_FILE = "modclusterConfigFile";

    public Configuration loadResourceConfiguration() {
        Configuration configuration = new Configuration();
        ConfigurationDefinition configurationDefinition = this.resourceContext.getResourceType().getResourceConfigurationDefinition();
        try {
            ModClusterBeanFile modClusterBeanFile = this.getModClusterBeanFileInstance();
            for (PropertyDefinition property : configurationDefinition.getPropertyDefinitions().values()) {
                if (!(property instanceof PropertyDefinitionSimple)) continue;
                String value = modClusterBeanFile.getPropertyValue(property.getName());
                if (value != null) {
                    configuration.put((Property)new PropertySimple(property.getName(), (Object)value));
                    continue;
                }
                PropertyDefinitionSimple propertyDefinitionSimple = (PropertyDefinitionSimple)property;
                configuration.put((Property)new PropertySimple(property.getName(), (Object)propertyDefinitionSimple.getDefaultValue()));
            }
        }
        catch (Exception e) {
            log.debug((Object)"Unable to load mod_cluster configuration file.", (Throwable)e);
        }
        return configuration;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        this.updateResourceConfiguration(report, false);
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report, boolean ignoreReadOnly) {
        ConfigurationDefinition configurationDefinition = this.getResourceContext().getResourceType().getResourceConfigurationDefinition();
        report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        try {
            ModClusterBeanFile modClusterBeanFile = this.getModClusterBeanFileInstance();
            for (String key : report.getConfiguration().getSimpleProperties().keySet()) {
                PropertySimple property = report.getConfiguration().getSimple(key);
                if (property == null) continue;
                try {
                    PropertyDefinitionSimple def = configurationDefinition.getPropertyDefinitionSimple(property.getName());
                    if (ignoreReadOnly && def.isReadOnly()) continue;
                    modClusterBeanFile.setPropertyValue(property.getName(), property.getStringValue());
                }
                catch (Exception e) {
                    property.setErrorMessage(ThrowableUtil.getStackAsString((Throwable)e));
                    report.setErrorMessage("Failed setting resource configuration. " + e.getMessage());
                    log.info((Object)("Failure setting MBean Resource configuration value for " + key), (Throwable)e);
                }
            }
            modClusterBeanFile.saveConfigurationFile();
        }
        catch (Exception e) {
            report.setErrorMessage("Failed to save the resource configuration to file. " + e.getMessage());
            log.debug((Object)"Unable to save mod_cluster configuration file.", (Throwable)e);
        }
    }

    private ModClusterBeanFile getModClusterBeanFileInstance() throws Exception {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String beanClassName = pluginConfig.getSimple(BEAN_CLASS_NAME_PROPERTY).getStringValue();
        String fileName = this.getModClusterConfigFile();
        if (pluginConfig.getSimple(DEPENDENCY_BEAN_CLASS_NAME_PROPERTY) != null) {
            String dependencyBeanClassName = pluginConfig.getSimple(DEPENDENCY_BEAN_CLASS_NAME_PROPERTY).getStringValue();
            return new ModClusterBeanFile(beanClassName, dependencyBeanClassName, fileName);
        }
        return new ModClusterBeanFile(beanClassName, fileName);
    }

    private String getModClusterConfigFile() {
        ModClusterServerComponent modClusterComponent = (ModClusterServerComponent)this.resourceContext.getParentResourceComponent();
        PropertySimple property = modClusterComponent.getResourceContext().getPluginConfiguration().getSimple(MOD_CLUSTER_CONFIG_FILE);
        if (property != null) {
            return property.getStringValue();
        }
        return null;
    }
}

