/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.metrics.clients.ptrans.backend;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.rhq.metrics.clients.ptrans.SingleMetric;
import org.rhq.metrics.clients.ptrans.backend.HttpErrorLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class RestForwardingHandler
extends ChannelInboundHandlerAdapter {
    private static final String RHQ_METRICS_ENDPOINT = "/rhq-metrics/metrics";
    private static final String DEFAULT_REST_PORT = "8080";
    private String restHost = "localhost";
    private int restPort = 8080;
    private String restPrefix = "/rhq-metrics/metrics";
    private static final int CLOSE_AFTER_REQUESTS = 200;
    private Channel senderChannel;
    private int sendCounter = 0;
    private static final Logger logger = LoggerFactory.getLogger(RestForwardingHandler.class);
    private int closeAfterRequests = 200;

    public RestForwardingHandler() {
        logger.debug("RsyslogHandler init");
        this.loadRestEndpointInfoFromProperties();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        final List in = (List)msg;
        logger.debug("Received some metrics :[" + in + "]");
        if (this.senderChannel != null) {
            this.sendToChannel(this.senderChannel, in);
            return;
        }
        ChannelFuture cf = this.connectRestServer(ctx.channel().eventLoop().parent());
        cf.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    logger.warn("something went wrong: ", future.cause());
                } else {
                    RestForwardingHandler.this.senderChannel = future.channel();
                    RestForwardingHandler.this.sendToChannel(RestForwardingHandler.this.senderChannel, in);
                }
            }
        });
    }

    private void sendToChannel(final Channel ch, List<SingleMetric> in) {
        if (logger.isDebugEnabled()) {
            logger.debug("Sending to channel " + ch);
        }
        String payload = this.eventsToJson(in);
        ByteBuf content = Unpooled.copiedBuffer((CharSequence)payload, (Charset)CharsetUtil.UTF_8);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, this.restPrefix, content);
        HttpHeaders.setContentLength((HttpMessage)request, (long)content.readableBytes());
        HttpHeaders.setKeepAlive((HttpMessage)request, (boolean)true);
        HttpHeaders.setHeader((HttpMessage)request, (String)"Content-Type", (Object)"application/json;charset=utf-8");
        ch.writeAndFlush((Object)request).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    ch.close();
                    RestForwardingHandler.this.senderChannel = null;
                    logger.error("Sending to the rhq-metrics server failed: " + future.cause());
                } else {
                    RestForwardingHandler.this.sendCounter++;
                    if (RestForwardingHandler.this.sendCounter >= RestForwardingHandler.this.closeAfterRequests) {
                        logger.info("Doing a periodic close after " + RestForwardingHandler.this.closeAfterRequests + " requests");
                        ch.close();
                        RestForwardingHandler.this.senderChannel = null;
                        RestForwardingHandler.this.sendCounter = 0;
                    }
                }
            }
        });
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    ChannelFuture connectRestServer(EventLoopGroup group) throws Exception {
        Bootstrap clientBootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)clientBootstrap.group(group)).channel(NioSocketChannel.class)).remoteAddress(this.restHost, this.restPort).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{new HttpRequestEncoder()});
                pipeline.addLast(new ChannelHandler[]{new HttpResponseDecoder()});
                pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(1024)});
                pipeline.addLast(new ChannelHandler[]{new HttpErrorLogger()});
            }
        });
        ChannelFuture clientFuture = clientBootstrap.connect();
        return clientFuture;
    }

    private String eventsToJson(List<SingleMetric> events) {
        StringBuilder builder = new StringBuilder("[");
        Iterator<SingleMetric> iter = events.iterator();
        while (iter.hasNext()) {
            SingleMetric event = iter.next();
            builder.append(event.toJson());
            if (!iter.hasNext()) continue;
            builder.append(',');
        }
        builder.append(']');
        return builder.toString();
    }

    private void loadRestEndpointInfoFromProperties() {
        try (InputStream inputStream = ClassLoader.getSystemResourceAsStream("ptrans.properties");){
            if (inputStream == null) {
                logger.warn("Can not load properties from 'ptrans.properties', using defaults");
                return;
            }
            Properties properties = new Properties();
            properties.load(inputStream);
            this.restHost = properties.getProperty("rest.host", "localhost");
            this.restPort = Integer.parseInt(properties.getProperty("rest.port", DEFAULT_REST_PORT));
            this.restPrefix = properties.getProperty("rest.prefix", RHQ_METRICS_ENDPOINT);
            this.closeAfterRequests = Integer.parseInt(properties.getProperty("rest.close-after", String.valueOf(200)));
        }
        catch (IOException e) {
            logger.warn("Can not load properties from 'ptrans.properties', using defaults");
        }
    }
}

