/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.embeddedagent.extension;

import java.util.HashMap;
import java.util.List;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceNotFoundException;
import org.rhq.embeddedagent.extension.AgentService;
import org.rhq.embeddedagent.extension.AgentSubsystemDefinition;

class PluginsAttributeHandler
extends AbstractWriteAttributeHandler<Void> {
    public static final PluginsAttributeHandler INSTANCE = new PluginsAttributeHandler();
    private final Logger log = Logger.getLogger(PluginsAttributeHandler.class);

    private PluginsAttributeHandler() {
        super(new AttributeDefinition[]{AgentSubsystemDefinition.PLUGINS_ATTRIBDEF});
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        this.log.debug((Object)("Embedded agent plugins attribute changed: " + attributeName + "=" + resolvedValue));
        this.setPluginsWithEnabledFlag(context, resolvedValue);
        return true;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) {
        this.log.debug((Object)("Reverting embedded agent plugins attribute: " + attributeName + "=" + valueToRestore));
        this.setPluginsWithEnabledFlag(context, valueToRestore);
    }

    private void setPluginsWithEnabledFlag(OperationContext context, ModelNode newValue) {
        try {
            AgentService service = (AgentService)context.getServiceRegistry(true).getRequiredService(AgentService.SERVICE_NAME).getValue();
            HashMap<String, Boolean> pluginsWithEnableFlag = new HashMap<String, Boolean>();
            if (newValue != null && newValue.isDefined()) {
                List pluginsList = newValue.asPropertyList();
                for (Property pluginsItem : pluginsList) {
                    String pluginName = pluginsItem.getName();
                    boolean pluginEnabled = pluginsItem.getValue().asBoolean();
                    pluginsWithEnableFlag.put(pluginName, pluginEnabled);
                }
            }
            service.setPlugins(pluginsWithEnableFlag);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
    }
}

