/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.embeddedagent.extension;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.rhq.embeddedagent.extension.AgentService;
import org.rhq.embeddedagent.extension.AgentSubsystemDefinition;

class AgentSubsystemAdd
extends AbstractAddStepHandler {
    static final AgentSubsystemAdd INSTANCE = new AgentSubsystemAdd();
    private final Logger log = Logger.getLogger(AgentSubsystemAdd.class);

    private AgentSubsystemAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        AgentSubsystemDefinition.AGENT_ENABLED_ATTRIBDEF.validateAndSet(operation, model);
        AgentSubsystemDefinition.PLUGINS_ATTRIBDEF.validateAndSet(operation, model);
        AgentSubsystemDefinition.AGENT_NAME_ATTRIBDEF.validateAndSet(operation, model);
        AgentSubsystemDefinition.DISABLE_NATIVE_ATTRIBDEF.validateAndSet(operation, model);
        AgentSubsystemDefinition.SERVER_TRANSPORT_ATTRIBDEF.validateAndSet(operation, model);
        AgentSubsystemDefinition.SERVER_BIND_PORT_ATTRIBDEF.validateAndSet(operation, model);
        AgentSubsystemDefinition.SERVER_BIND_ADDRESS_ATTRIBDEF.validateAndSet(operation, model);
        AgentSubsystemDefinition.SERVER_TRANSPORT_PARAMS_ATTRIBDEF.validateAndSet(operation, model);
        AgentSubsystemDefinition.SERVER_ALIAS_ATTRIBDEF.validateAndSet(operation, model);
        AgentSubsystemDefinition.SOCKET_BINDING_ATTRIBDEF.validateAndSet(operation, model);
        AgentSubsystemDefinition.CUSTOM_CONFIG_ATTRIBDEF.validateAndSet(operation, model);
        this.log.debug((Object)("Populating the embedded agent subsystem model: " + operation + "=" + model));
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        boolean enabled = AgentSubsystemDefinition.AGENT_ENABLED_ATTRIBDEF.resolveModelAttribute(context, model).asBoolean(false);
        if (!enabled) {
            this.log.info((Object)"Embedded agent is not enabled and will not be deployed");
            return;
        }
        this.log.info((Object)"Embedded agent is enabled and will be deployed");
        HashMap<String, Boolean> pluginsWithEnableFlag = new HashMap<String, Boolean>();
        ModelNode pluginsNode = AgentSubsystemDefinition.PLUGINS_ATTRIBDEF.resolveModelAttribute(context, model);
        if (pluginsNode != null && pluginsNode.isDefined()) {
            List pluginsList = pluginsNode.asPropertyList();
            for (Property pluginsItem : pluginsList) {
                String pluginName = pluginsItem.getName();
                boolean pluginEnabled = pluginsItem.getValue().asBoolean();
                pluginsWithEnableFlag.put(pluginName, pluginEnabled);
            }
        }
        HashMap<String, String> overrides = new HashMap<String, String>();
        this.addOverrideProperty(context, model, overrides, (AttributeDefinition)AgentSubsystemDefinition.AGENT_NAME_ATTRIBDEF);
        this.addOverrideProperty(context, model, overrides, (AttributeDefinition)AgentSubsystemDefinition.DISABLE_NATIVE_ATTRIBDEF);
        this.addOverrideProperty(context, model, overrides, (AttributeDefinition)AgentSubsystemDefinition.SERVER_TRANSPORT_ATTRIBDEF);
        this.addOverrideProperty(context, model, overrides, (AttributeDefinition)AgentSubsystemDefinition.SERVER_BIND_PORT_ATTRIBDEF);
        this.addOverrideProperty(context, model, overrides, (AttributeDefinition)AgentSubsystemDefinition.SERVER_BIND_ADDRESS_ATTRIBDEF);
        this.addOverrideProperty(context, model, overrides, (AttributeDefinition)AgentSubsystemDefinition.SERVER_TRANSPORT_PARAMS_ATTRIBDEF);
        this.addOverrideProperty(context, model, overrides, (AttributeDefinition)AgentSubsystemDefinition.SERVER_ALIAS_ATTRIBDEF);
        this.addOverrideProperty(context, model, overrides, (AttributeDefinition)AgentSubsystemDefinition.AGENT_TRANSPORT_ATTRIBDEF);
        this.addOverrideProperty(context, model, overrides, (AttributeDefinition)AgentSubsystemDefinition.AGENT_TRANSPORT_PARAMS_ATTRIBDEF);
        ModelNode customConfigNode = AgentSubsystemDefinition.CUSTOM_CONFIG_ATTRIBDEF.resolveModelAttribute(context, model);
        if (customConfigNode != null && customConfigNode.isDefined()) {
            HashMap<String, String> customConfig = new HashMap<String, String>();
            List prefList = customConfigNode.asPropertyList();
            for (Property pref : prefList) {
                String name = pref.getName();
                String val = pref.getValue().asString();
                customConfig.put(name, val);
            }
            overrides.putAll(customConfig);
        }
        AgentService service = new AgentService();
        service.setPlugins(pluginsWithEnableFlag);
        service.setConfigurationOverrides(overrides);
        String binding = AgentSubsystemDefinition.SOCKET_BINDING_ATTRIBDEF.resolveModelAttribute(context, model).asString();
        ServiceName name = AgentService.SERVICE_NAME;
        ServiceController controller = context.getServiceTarget().addService(name, (Service)service).addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.envServiceValue).addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{binding}), SocketBinding.class, service.agentListenerBinding).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install();
        newControllers.add(controller);
    }

    private void addOverrideProperty(OperationContext context, ModelNode model, Map<String, String> overrides, AttributeDefinition attribDef) throws OperationFailedException {
        ModelNode node = attribDef.resolveModelAttribute(context, model);
        if (node.isDefined()) {
            overrides.put(attribDef.getName(), node.asString());
        }
    }
}

