/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.drift.mongodb.entities;

import com.google.code.morphia.annotations.Embedded;
import com.google.code.morphia.annotations.Property;
import com.google.code.morphia.annotations.Transient;
import java.io.Serializable;
import org.bson.types.ObjectId;
import org.rhq.core.domain.drift.Drift;
import org.rhq.core.domain.drift.DriftCategory;
import org.rhq.enterprise.server.plugins.drift.mongodb.entities.MongoDBChangeSet;
import org.rhq.enterprise.server.plugins.drift.mongodb.entities.MongoDBFile;

@Embedded
public class MongoDBChangeSetEntry
implements Drift<MongoDBChangeSet, MongoDBFile>,
Serializable {
    private static final long serialVersionUID = 1L;
    @Property(value="idx")
    private int index;
    private Long ctime = System.currentTimeMillis();
    private DriftCategory category;
    private String path;
    private String directory;
    @Transient
    private MongoDBChangeSet changeSet;
    @Transient
    private ObjectId changeSetId;
    private String oldFileHash;
    private String newFileHash;

    public MongoDBChangeSetEntry() {
    }

    public MongoDBChangeSetEntry(String path, DriftCategory category) {
        this.path = path;
        int i = path.lastIndexOf("/");
        this.directory = i != -1 ? path.substring(0, i) : "./";
        this.category = category;
    }

    public String getId() {
        if (this.changeSetId == null) {
            return null;
        }
        return this.changeSetId.toString() + ":" + this.index;
    }

    public void setId(String id) {
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Long getCtime() {
        return this.ctime;
    }

    public void setCtime(Long ctime) {
        this.ctime = ctime;
    }

    public MongoDBChangeSet getChangeSet() {
        return this.changeSet;
    }

    public void setChangeSet(MongoDBChangeSet changeSet) {
        this.changeSet = changeSet;
        this.changeSetId = changeSet.getObjectId();
    }

    public DriftCategory getCategory() {
        return this.category;
    }

    public void setCategory(DriftCategory category) {
        this.category = category;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
        int i = path.lastIndexOf("/");
        this.directory = i != -1 ? path.substring(0, i) : "./";
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getOldFileHash() {
        return this.oldFileHash;
    }

    public void setOldFileHash(String oldFileHash) {
        this.oldFileHash = oldFileHash;
    }

    public String getNewFileHash() {
        return this.newFileHash;
    }

    public void setNewFileHash(String newFileHash) {
        this.newFileHash = newFileHash;
    }

    public MongoDBFile getOldDriftFile() {
        return new MongoDBFile(this.oldFileHash);
    }

    public void setOldDriftFile(MongoDBFile oldDriftFile) {
        this.oldFileHash = oldDriftFile.getHashId();
    }

    public MongoDBFile getNewDriftFile() {
        return new MongoDBFile(this.newFileHash);
    }

    public void setNewDriftFile(MongoDBFile newDriftFile) {
        this.newFileHash = newDriftFile.getHashId();
    }
}

