/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertScriptlang;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.notification.ResultState;
import org.rhq.core.domain.alert.notification.SenderResult;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSender;
import org.rhq.enterprise.server.plugins.alertScriptlang.ScriptLangComponent;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptLangSender
extends AlertSender<ScriptLangComponent> {
    private final Log log = LogFactory.getLog(ScriptLangSender.class);

    public SenderResult send(Alert alert) {
        String scriptName = this.alertParameters.getSimpleValue("name", null);
        if (scriptName == null) {
            return new SenderResult(ResultState.FAILURE, "No script given");
        }
        String language = this.alertParameters.getSimpleValue("language", "jruby");
        ScriptEngine engine = ((ScriptLangComponent)this.pluginComponent).getEngineByLanguage(language);
        if (engine == null) {
            return new SenderResult(ResultState.FAILURE, "Script engine with name [" + language + "] does not exist");
        }
        File file = new File(((ScriptLangComponent)this.pluginComponent).baseDir + scriptName);
        if (!file.exists() || !file.canRead()) {
            return new SenderResult(ResultState.FAILURE, "Script [" + scriptName + "] does not exist or is not readable at [" + file.getAbsolutePath() + "]");
        }
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            HashMap<String, String> preferencesMap = new HashMap<String, String>();
            for (String key : this.preferences.getSimpleProperties().keySet()) {
                preferencesMap.put(key, this.preferences.getSimple(key).getStringValue());
            }
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            for (String key : this.alertParameters.getSimpleProperties().keySet()) {
                parameterMap.put(key, this.alertParameters.getSimple(key).getStringValue());
            }
            ScriptContext sc = engine.getContext();
            sc.setAttribute("alertPreferences", preferencesMap, 100);
            sc.setAttribute("alertParameters", parameterMap, 100);
            engine.eval(br);
            AlertManagerLocal alertManager = LookupUtil.getAlertManager();
            Object[] args = new Object[]{alert, alertManager.prettyPrintAlertURL(alert), alertManager.prettyPrintAlertConditions(alert, false)};
            Object result = ((Invocable)((Object)engine)).invokeFunction("sendAlert", args);
            if (result == null) {
                return new SenderResult(ResultState.FAILURE, "Script ]" + scriptName + "] returned null, so success is unknown");
            }
            if (result instanceof SenderResult) {
                return (SenderResult)result;
            }
            return new SenderResult(ResultState.SUCCESS, "Sending via script resulted in " + result.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new SenderResult(ResultState.FAILURE, "Sending via [" + scriptName + "] failed: " + e.getMessage());
        }
    }
}

