/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.openshift;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.modules.plugins.jbossas7.StandaloneASComponent;

public class OpenshiftDiscovery
implements ResourceDiscoveryComponent<StandaloneASComponent<?>> {
    private final Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext discoveryContext) throws Exception {
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        ResourceComponent parent = discoveryContext.getParentResourceComponent();
        StandaloneASComponent parentComponent = (StandaloneASComponent)parent;
        File homeDir = parentComponent.getServerPluginConfiguration().getHomeDir();
        if (homeDir == null || !homeDir.exists()) {
            return Collections.EMPTY_SET;
        }
        String home = homeDir.getAbsolutePath();
        this.log.debug((Object)("Home is " + home));
        if (home.contains("/var/lib/openshift")) {
            DiscoveredResourceDetails detail = new DiscoveredResourceDetails(discoveryContext.getResourceType(), "openshift", "Openshift", "1.0", "OpenShift", discoveryContext.getDefaultPluginConfiguration(), null);
            discoveredResources.add(detail);
            this.log.info((Object)("Discovered new ... OpenShift at  " + home));
        }
        return discoveredResources;
    }
}

