/*
 * Decompiled with CFR 0.152.
 */
package org.rfc8452.authenticator;

import org.rfc8452.authenticator.Authenticator;
import org.rfc8452.authenticator.FieldElement64;

public class Polyval
implements Authenticator {
    private static final int BLOCK_SIZE = 16;
    private static final String ZERO = "0";
    private FieldElement64 h;
    private FieldElement64 s;

    public Polyval(long h0, long h1) {
        this.h = new FieldElement64(h0, h1);
        this.s = FieldElement64.defaultElement();
    }

    public Polyval(long h0, long h1, long s0, long s1) {
        this.h = new FieldElement64(h0, h1);
        this.s = new FieldElement64(s0, s1);
    }

    public Polyval(byte[] h) {
        this.h = new FieldElement64(h);
        this.s = FieldElement64.defaultElement();
    }

    public Polyval(byte[] h, byte[] s) {
        this.h = new FieldElement64(h);
        this.s = new FieldElement64(s);
    }

    public Polyval(String hexString) {
        this.h = new FieldElement64(hexString);
        this.s = FieldElement64.defaultElement();
    }

    public Polyval(String hHexString, String sHexString) {
        this.h = new FieldElement64(hHexString);
        this.s = new FieldElement64(sHexString);
    }

    public Polyval updateBlock(byte[] v) {
        FieldElement64 update = new FieldElement64(v);
        return this.updateBlock(update);
    }

    public Polyval updateBlock(String hexString) {
        FieldElement64 update = new FieldElement64(hexString);
        return this.updateBlock(update);
    }

    public Polyval updateBlock(FieldElement64 update) {
        this.s = this.s.add(update).mul(this.h);
        return this;
    }

    @Override
    public Polyval reset() {
        this.s = FieldElement64.defaultElement();
        return this;
    }

    @Override
    public Polyval update(byte[] b) {
        FieldElement64 blockUpdate;
        int remainder = b.length % 16;
        for (int i = 0; i < b.length - remainder; i += 16) {
            blockUpdate = new FieldElement64(b, i);
            this.updateBlock(blockUpdate);
        }
        if (remainder != 0) {
            byte[] block = new byte[16];
            System.arraycopy(b, b.length - remainder, block, 0, remainder);
            blockUpdate = new FieldElement64(block);
            this.updateBlock(blockUpdate);
        }
        return this;
    }

    public Polyval update(String hexString) {
        int remainder = hexString.length() % 32;
        for (int i = 0; i < hexString.length() - remainder; i += 32) {
            FieldElement64 blockUpdate = new FieldElement64(hexString.substring(i, i + 32));
            this.updateBlock(blockUpdate);
        }
        if (remainder != 0) {
            StringBuilder padding = new StringBuilder();
            for (int i = 0; i < 32 - remainder; ++i) {
                padding.append(ZERO);
            }
            FieldElement64 blockUpdate = new FieldElement64(hexString.substring(hexString.length() - remainder) + padding);
            this.updateBlock(blockUpdate);
        }
        return this;
    }

    public FieldElement64 getH() {
        return this.h;
    }

    public FieldElement64 getS() {
        return this.s;
    }

    @Override
    public byte[] digest() {
        return this.s.toBytes();
    }

    public String toString() {
        return this.s.toString();
    }
}

