/*
 * Decompiled with CFR 0.152.
 */
package org.rfc8452.authenticator;

import java.util.Scanner;
import org.rfc8452.authenticator.BitOperations;

public class FieldElement64 {
    private long e0;
    private long e1;

    public FieldElement64(String hexString) {
        byte[] bytes = new byte[16];
        for (int i = 0; i < 16; ++i) {
            String chunk = hexString.substring(i * 2, i * 2 + 2);
            bytes[i] = (byte)new Scanner(chunk).nextInt(16);
        }
        this.fromBytes(bytes, 0);
    }

    public FieldElement64(long e0, long e1) {
        this.e0 = e0;
        this.e1 = e1;
    }

    public FieldElement64(byte[] bytes) {
        this.fromBytes(bytes, 0);
    }

    public FieldElement64(byte[] bytes, int offset) {
        this.fromBytes(bytes, offset);
    }

    public void fromBytes(byte[] bytes, int offset) {
        this.e0 = (long)bytes[offset + 7] << 56 | ((long)bytes[offset + 6] & 0xFFL) << 48 | ((long)bytes[offset + 5] & 0xFFL) << 40 | ((long)bytes[offset + 4] & 0xFFL) << 32 | ((long)bytes[offset + 3] & 0xFFL) << 24 | ((long)bytes[offset + 2] & 0xFFL) << 16 | ((long)bytes[offset + 1] & 0xFFL) << 8 | (long)bytes[offset] & 0xFFL;
        this.e1 = (long)bytes[offset + 15] << 56 | ((long)bytes[offset + 14] & 0xFFL) << 48 | ((long)bytes[offset + 13] & 0xFFL) << 40 | ((long)bytes[offset + 12] & 0xFFL) << 32 | ((long)bytes[offset + 11] & 0xFFL) << 24 | ((long)bytes[offset + 10] & 0xFFL) << 16 | ((long)bytes[offset + 9] & 0xFFL) << 8 | (long)bytes[offset + 8] & 0xFFL;
    }

    public static FieldElement64 defaultElement() {
        return new FieldElement64(0L, 0L);
    }

    public FieldElement64 add(FieldElement64 b) {
        FieldElement64 a = this;
        return FieldElement64.add(a, b);
    }

    public FieldElement64 mul(FieldElement64 b) {
        FieldElement64 a = this;
        return FieldElement64.mul(a, b);
    }

    public static FieldElement64 add(FieldElement64 a, FieldElement64 b) {
        return new FieldElement64(a.e0 ^ b.e0, a.e1 ^ b.e1);
    }

    public static FieldElement64 mul(FieldElement64 a, FieldElement64 b) {
        long a0 = a.e0;
        long a1 = a.e1;
        long a0Reversed = BitOperations.rev64(a0);
        long a1Reversed = BitOperations.rev64(a1);
        long b0 = b.e0;
        long b1 = b.e1;
        long b0Reversed = BitOperations.rev64(b0);
        long b1Reversed = BitOperations.rev64(b1);
        long m1 = BitOperations.bmul64(b1, a1);
        long m2 = BitOperations.bmul64(b0, a0) ^ BitOperations.bmul64(b0 ^ b1, a0 ^ a1) ^ BitOperations.bmul64(b1, a1);
        long k0 = BitOperations.multiplyReverseShift1(b0Reversed, a0Reversed);
        long k1 = BitOperations.multiplyReverseShift1(b1Reversed, a1Reversed);
        long k2 = BitOperations.multiplyReverseShift1(b0Reversed ^ b1Reversed, a0Reversed ^ a1Reversed) ^ (k0 ^ k1);
        long r0 = BitOperations.bmul64(b0, a0);
        long r1 = m2 ^ k0 ^ r0 << 63 ^ r0 << 62 ^ r0 << 57;
        long r2 = m1 ^ k2 ^ r1 << 63 ^ r1 << 62 ^ r1 << 57 ^ r0 ^ r0 >>> 1 ^ r0 >>> 2 ^ r0 >>> 7;
        long r3 = k1 ^ r1 ^ r1 >>> 1 ^ r1 >>> 2 ^ r1 >>> 7;
        return new FieldElement64(r2, r3);
    }

    public byte[] toBytes() {
        byte[] result = new byte[]{(byte)this.e0, (byte)(this.e0 >> 8), (byte)(this.e0 >> 16), (byte)(this.e0 >> 24), (byte)(this.e0 >> 32), (byte)(this.e0 >> 40), (byte)(this.e0 >> 48), (byte)(this.e0 >> 56), (byte)this.e1, (byte)(this.e1 >> 8), (byte)(this.e1 >> 16), (byte)(this.e1 >> 24), (byte)(this.e1 >> 32), (byte)(this.e1 >> 40), (byte)(this.e1 >> 48), (byte)(this.e1 >> 56)};
        return result;
    }

    public String toString() {
        return String.format("%016x%016x", Long.reverseBytes(this.e0), Long.reverseBytes(this.e1));
    }
}

