/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven.utils;

import java.util.Arrays;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;

public class ScopeDependencySelector
implements DependencySelector {
    private final String[] topLevelScopes;
    private final String[] transitiveScopes;
    private final int depth;
    private final Dependency parent;
    private final ScopeDependencySelector parentSelector;

    public ScopeDependencySelector(String[] topLevelScopes, String[] transitiveScopes) {
        this(topLevelScopes, transitiveScopes, null, null, 0);
    }

    private ScopeDependencySelector(String[] topLevelScopes, String[] transitiveScopes, Dependency parent, ScopeDependencySelector parentSelector, int depth) {
        this.topLevelScopes = topLevelScopes;
        this.transitiveScopes = transitiveScopes;
        this.parent = parent;
        this.parentSelector = parentSelector;
        this.depth = depth;
    }

    private boolean hasRequiredScope(Dependency dep) {
        String scope = dep.getScope();
        if (scope == null || scope.isEmpty()) {
            scope = "compile";
        }
        for (String s : this.depth > 1 ? this.transitiveScopes : this.topLevelScopes) {
            if (!s.equals(scope)) continue;
            return true;
        }
        return false;
    }

    public boolean selectDependency(Dependency dependency) {
        if (!this.isExcluded(dependency)) {
            boolean optional = dependency.isOptional();
            return !optional && this.hasRequiredScope(dependency);
        }
        return false;
    }

    private boolean isExcluded(Dependency dependency) {
        boolean result = this.isExcludedFromParent(dependency);
        if (!result && this.parentSelector != null) {
            result = this.parentSelector.isExcluded(dependency);
        }
        return result;
    }

    private boolean isExcludedFromParent(Dependency dependency) {
        boolean result = false;
        if (this.parent != null && this.parent.getExclusions().size() > 0) {
            for (Exclusion exclusion : this.parent.getExclusions()) {
                if (exclusion == null || exclusion.getArtifactId() == null || !exclusion.getArtifactId().equals(dependency.getArtifact().getArtifactId()) || exclusion.getGroupId() == null || !exclusion.getGroupId().equals(dependency.getArtifact().getGroupId())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
        if (this.depth > 1) {
            return this;
        }
        return new ScopeDependencySelector(this.topLevelScopes, this.transitiveScopes, context.getDependency(), this, this.depth + 1);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ScopeDependencySelector that = (ScopeDependencySelector)obj;
        return this.depth == that.depth && (this.depth > 1 ? Arrays.equals(this.transitiveScopes, that.transitiveScopes) : Arrays.equals(this.topLevelScopes, that.topLevelScopes));
    }

    public int hashCode() {
        return this.depth > 1 ? Arrays.hashCode(this.transitiveScopes) : Arrays.hashCode(this.topLevelScopes);
    }
}

