/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.eclipse.aether.AbstractForwardingRepositorySystemSession;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.LocalArtifactRegistration;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.LocalMetadataRegistration;
import org.eclipse.aether.repository.LocalMetadataRequest;
import org.eclipse.aether.repository.LocalMetadataResult;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.selector.OptionalDependencySelector;
import org.eclipse.aether.util.graph.traverser.AndDependencyTraverser;
import org.eclipse.aether.util.graph.traverser.FatArtifactTraverser;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;
import org.eclipse.aether.version.Version;
import org.revapi.maven.utils.ScopeDependencySelector;
import org.revapi.maven.utils.ScopeDependencyTraverser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ArtifactResolver.class);
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession session;
    private final List<RemoteRepository> repositories;

    public static DependencySelector getRevapiDependencySelector(boolean resolveProvidedDependencies, boolean resolveTransitiveProvidedDependencies) {
        String[] stringArray;
        String[] stringArray2;
        if (resolveProvidedDependencies) {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "compile";
            stringArray2 = stringArray3;
            stringArray3[1] = "provided";
        } else {
            String[] stringArray4 = new String[1];
            stringArray2 = stringArray4;
            stringArray4[0] = "compile";
        }
        String[] topLevelScopes = stringArray2;
        if (resolveTransitiveProvidedDependencies) {
            String[] stringArray5 = new String[2];
            stringArray5[0] = "compile";
            stringArray = stringArray5;
            stringArray5[1] = "provided";
        } else {
            String[] stringArray6 = new String[1];
            stringArray = stringArray6;
            stringArray6[0] = "compile";
        }
        String[] transitiveScopes = stringArray;
        return new AndDependencySelector(new DependencySelector[]{new ScopeDependencySelector(topLevelScopes, transitiveScopes), new OptionalDependencySelector(), new ExclusionDependencySelector()});
    }

    public static DependencyTraverser getRevapiDependencyTraverser(boolean resolveProvidedDependencies, boolean resolveTransitiveProvidedDependencies) {
        String[] stringArray;
        String[] stringArray2;
        if (resolveProvidedDependencies) {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "compile";
            stringArray2 = stringArray3;
            stringArray3[1] = "provided";
        } else {
            String[] stringArray4 = new String[1];
            stringArray2 = stringArray4;
            stringArray4[0] = "compile";
        }
        String[] topLevelScopes = stringArray2;
        if (resolveTransitiveProvidedDependencies) {
            String[] stringArray5 = new String[2];
            stringArray5[0] = "compile";
            stringArray = stringArray5;
            stringArray5[1] = "provided";
        } else {
            String[] stringArray6 = new String[1];
            stringArray = stringArray6;
            stringArray6[0] = "compile";
        }
        String[] transitiveScopes = stringArray;
        return new AndDependencyTraverser(new DependencyTraverser[]{new ScopeDependencyTraverser(topLevelScopes, transitiveScopes), new FatArtifactTraverser()});
    }

    public ArtifactResolver(RepositorySystem repositorySystem, RepositorySystemSession session, List<RemoteRepository> repositories) {
        this.repositorySystem = repositorySystem;
        this.session = session;
        this.repositories = repositories;
    }

    public Artifact resolveArtifact(String gav) throws ArtifactResolutionException {
        return this.resolveArtifact((Artifact)new DefaultArtifact(gav), this.session);
    }

    public Artifact resolveNewestMatching(final String gav, @Nullable String upToVersion, final Pattern versionMatcher, boolean remoteOnly, boolean upToInclusive) throws VersionRangeResolutionException, ArtifactResolutionException {
        DefaultArtifact artifact = new DefaultArtifact(gav);
        artifact = artifact.setVersion(upToVersion == null ? "[,)" : "[," + upToVersion + (upToInclusive ? "]" : ")"));
        VersionRangeRequest rangeRequest = new VersionRangeRequest((Artifact)artifact, this.repositories, null);
        RepositorySystemSession session = remoteOnly ? this.makeRemoteOnly(this.session) : this.session;
        VersionRangeResult result = this.repositorySystem.resolveVersionRange(session, rangeRequest);
        final ArrayList versions = new ArrayList(result.getVersions());
        Collections.reverse(versions);
        for (Version v : versions) {
            if (!versionMatcher.matcher(v.toString()).matches()) continue;
            return this.resolveArtifact(artifact.setVersion(v.toString()), session);
        }
        throw new VersionRangeResolutionException(result){

            public String getMessage() {
                return "Failed to find a version of artifact '" + gav + "' that would correspond to an expression '" + versionMatcher + "'. The versions found were: " + versions;
            }
        };
    }

    public CollectionResult collectTransitiveDeps(String ... gavs) throws RepositoryException {
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        HashSet<Exception> failures = new HashSet<Exception>();
        for (String gav : gavs) {
            LOG.debug("Artifact resolution for {}", (Object)gav);
            this.collectTransitiveDeps(gav, artifacts, failures);
        }
        return new CollectionResult(failures, artifacts);
    }

    protected void collectTransitiveDeps(String gav, final Set<Artifact> resolvedArtifacts, Set<Exception> failures) throws RepositoryException {
        DependencyResult result;
        final Artifact rootArtifact = this.resolveArtifact(gav);
        CollectRequest collectRequest = new CollectRequest(new Dependency(rootArtifact, null), this.repositories);
        DependencyRequest request = new DependencyRequest(collectRequest, null);
        try {
            result = this.repositorySystem.resolveDependencies(this.session, request);
        }
        catch (DependencyResolutionException dre) {
            result = dre.getResult();
        }
        if (result.getRoot() == null) {
            failures.addAll(result.getCollectExceptions());
            return;
        }
        result.getRoot().accept((DependencyVisitor)new TreeDependencyVisitor(new DependencyVisitor(){
            int depth = 0;

            public boolean visitEnter(DependencyNode node) {
                if (LOG.isDebugEnabled()) {
                    StringBuilder msg = new StringBuilder();
                    for (int i = 0; i < this.depth; ++i) {
                        msg.append("    ");
                    }
                    msg.append(node);
                    LOG.debug(msg.toString());
                }
                ++this.depth;
                return true;
            }

            public boolean visitLeave(DependencyNode node) {
                --this.depth;
                Dependency dep = node.getDependency();
                if (dep == null || dep.getArtifact().equals(rootArtifact)) {
                    return true;
                }
                resolvedArtifacts.add(dep.getArtifact());
                return true;
            }
        }));
        failures.addAll(result.getCollectExceptions());
    }

    private Artifact resolveArtifact(Artifact artifact, RepositorySystemSession session) throws ArtifactResolutionException {
        ArtifactRequest request = new ArtifactRequest().setArtifact(artifact).setRepositories(this.repositories);
        ArtifactResult result = this.repositorySystem.resolveArtifact(session, request);
        if (!result.isResolved() || result.isMissing()) {
            throw new ArtifactResolutionException(Collections.singletonList(result), "The artifact was not resolved or is missing: '" + artifact.toString() + "'.");
        }
        return result.getArtifact();
    }

    private RepositorySystemSession makeRemoteOnly(final RepositorySystemSession session) {
        return new AbstractForwardingRepositorySystemSession(){

            protected RepositorySystemSession getSession() {
                return session;
            }

            public WorkspaceReader getWorkspaceReader() {
                return null;
            }

            public LocalRepositoryManager getLocalRepositoryManager() {
                final LocalRepositoryManager wrapped = session.getLocalRepositoryManager();
                return new LocalRepositoryManager(){

                    public LocalRepository getRepository() {
                        return wrapped.getRepository();
                    }

                    public String getPathForLocalArtifact(Artifact artifact) {
                        return wrapped.getPathForLocalArtifact(artifact);
                    }

                    public String getPathForRemoteArtifact(Artifact artifact, RemoteRepository repository, String context) {
                        return wrapped.getPathForRemoteArtifact(artifact, repository, context);
                    }

                    public String getPathForLocalMetadata(Metadata metadata) {
                        return wrapped.getPathForLocalMetadata(metadata);
                    }

                    public String getPathForRemoteMetadata(Metadata metadata, RemoteRepository repository, String context) {
                        return wrapped.getPathForRemoteMetadata(metadata, repository, context);
                    }

                    public LocalArtifactResult find(RepositorySystemSession session, LocalArtifactRequest request) {
                        return wrapped.find(session, request);
                    }

                    public void add(RepositorySystemSession session, LocalArtifactRegistration request) {
                        wrapped.add(session, request);
                    }

                    public LocalMetadataResult find(RepositorySystemSession session, LocalMetadataRequest request) {
                        if (request.getRepository() == null) {
                            LocalMetadataResult ret = new LocalMetadataResult(request);
                            ret.setFile(new File("<faked-to-force-remote-only-resolution-of-artifacts>"));
                            return ret;
                        }
                        return wrapped.find(session, request);
                    }

                    public void add(RepositorySystemSession session, LocalMetadataRegistration request) {
                        wrapped.add(session, request);
                    }
                };
            }
        };
    }

    public static final class CollectionResult {
        private final Set<Artifact> resolvedArtifacts;
        private final Set<Exception> failures;

        private CollectionResult(Set<Exception> failures, Set<Artifact> resolvedArtifacts) {
            this.failures = failures;
            this.resolvedArtifacts = resolvedArtifacts;
        }

        public Set<Exception> getFailures() {
            return this.failures;
        }

        public Set<Artifact> getResolvedArtifacts() {
            return this.resolvedArtifacts;
        }
    }
}

