/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.revapi.AnalysisContext;
import org.revapi.Revapi;
import org.revapi.configuration.JSONUtil;
import org.revapi.configuration.XmlToJson;
import org.revapi.maven.ConfigurationFile;
import org.revapi.maven.PropertyValueResolver;

final class AnalysisConfigurationGatherer {
    private final PlexusConfiguration analysisConfiguration;
    private final Object[] analysisConfigurationFiles;
    private final boolean failOnMissingConfigurationFiles;
    private final boolean expandProperties;
    private final PropertyValueResolver propertyValueResolver;
    private final File relativePathBaseDir;
    private final Log log;

    AnalysisConfigurationGatherer(PlexusConfiguration analysisConfiguration2, Object[] analysisConfigurationFiles2, boolean failOnMissingConfigurationFiles2, boolean expandProperties2, PropertyValueResolver propertyValueResolver, File relativePathBaseDir, Log log) {
        this.analysisConfiguration = analysisConfiguration2;
        this.analysisConfigurationFiles = analysisConfigurationFiles2;
        this.failOnMissingConfigurationFiles = failOnMissingConfigurationFiles2;
        this.expandProperties = expandProperties2;
        this.log = log;
        this.propertyValueResolver = propertyValueResolver;
        this.relativePathBaseDir = relativePathBaseDir;
    }

    void gatherConfig(Revapi revapi, AnalysisContext.Builder ctxBld) throws MojoExecutionException {
        if (this.analysisConfigurationFiles != null && this.analysisConfigurationFiles.length > 0) {
            for (Object pathOrConfigFile : this.analysisConfigurationFiles) {
                Supplier<Iterator> configFileContents;
                ConfigurationFile configFile;
                if (pathOrConfigFile instanceof String) {
                    configFile = new ConfigurationFile();
                    configFile.setPath((String)pathOrConfigFile);
                } else {
                    configFile = (ConfigurationFile)pathOrConfigFile;
                }
                String path = configFile.getPath();
                String resource = configFile.getResource();
                if (path == null && resource == null) {
                    throw new MojoExecutionException("Either 'path' or 'resource' has to be specified in a configurationFile definition.");
                }
                if (path != null && resource != null) {
                    throw new MojoExecutionException("Either 'path' or 'resource' has to be specified in a configurationFile definition but not both.");
                }
                String readErrorMessage = "Error while processing the configuration file on " + (path == null ? "classpath " + resource : "path " + path) + ": ";
                if (path != null) {
                    File f = new File(path);
                    if (!f.isAbsolute()) {
                        f = new File(this.relativePathBaseDir, path);
                    }
                    if (!f.isFile() || !f.canRead()) {
                        String message = "Could not locate analysis configuration file '" + f.getAbsolutePath() + "'.";
                        if (this.failOnMissingConfigurationFiles) {
                            throw new MojoExecutionException(message);
                        }
                        this.log.debug((CharSequence)message);
                        continue;
                    }
                    File ff = f;
                    configFileContents = () -> {
                        try {
                            return Collections.singletonList(new FileInputStream(ff)).iterator();
                        }
                        catch (FileNotFoundException e) {
                            throw new IllegalArgumentException("Failed to read the configuration file '" + ff.getAbsolutePath() + "'.", e);
                        }
                    };
                } else {
                    configFileContents = () -> {
                        try {
                            return Collections.list(this.getClass().getClassLoader().getResources(resource)).stream().map(url -> {
                                try {
                                    return url.openStream();
                                }
                                catch (IOException e) {
                                    throw new IllegalArgumentException("Failed to read the classpath resource '" + url + "'.");
                                }
                            }).iterator();
                        }
                        catch (IOException e) {
                            throw new IllegalArgumentException("Failed to locate classpath resources on path '" + resource + "'.");
                        }
                    };
                }
                Iterator it = configFileContents.get();
                ArrayList<Integer> nonJsonIndexes = new ArrayList<Integer>(4);
                int idx = 0;
                while (it.hasNext()) {
                    JsonNode config;
                    try (InputStream in = (InputStream)it.next();){
                        config = this.readJson(in);
                    }
                    catch (IOException | IllegalArgumentException e) {
                        throw new MojoExecutionException(readErrorMessage + e.getMessage(), e);
                    }
                    if (config == null) {
                        nonJsonIndexes.add(idx);
                        continue;
                    }
                    config = this.expandVariables(config);
                    this.mergeJsonConfigFile(ctxBld, configFile, config);
                    ++idx;
                }
                if (nonJsonIndexes.isEmpty()) continue;
                idx = 0;
                it = configFileContents.get();
                while (it.hasNext()) {
                    try (InputStreamReader rdr = new InputStreamReader((InputStream)it.next());){
                        if (nonJsonIndexes.contains(idx)) {
                            this.mergeXmlConfigFile(revapi, ctxBld, configFile, rdr);
                        }
                    }
                    catch (IOException | IllegalArgumentException | org.apache.maven.shared.utils.xml.pull.XmlPullParserException e) {
                        throw new MojoExecutionException(readErrorMessage + e.getMessage(), (Exception)e);
                    }
                    ++idx;
                }
            }
        }
        if (this.analysisConfiguration != null) {
            try {
                String text = this.analysisConfiguration.getValue();
                if (text == null || text.isEmpty()) {
                    this.convertNewStyleConfigFromXml(ctxBld, revapi);
                } else {
                    ctxBld.mergeConfiguration(this.expandVariables(JSONUtil.parse((String)JSONUtil.stripComments((String)text))));
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to read the configuration: " + e.getMessage(), e);
            }
        }
    }

    private void mergeXmlConfigFile(Revapi revapi, AnalysisContext.Builder ctxBld, ConfigurationFile configFile, Reader rdr) throws IOException, org.apache.maven.shared.utils.xml.pull.XmlPullParserException {
        PlexusConfigurationWrapper xml;
        XmlToJson conv = XmlToJson.fromRevapi((Revapi)revapi, PlexusConfigurationWrapper::getName, PlexusConfigurationWrapper::getValue, PlexusConfigurationWrapper::getAttribute, PlexusConfigurationWrapper::getChildren);
        try {
            xml = new PlexusConfigurationWrapper((PlexusConfiguration)new XmlPlexusConfiguration(Xpp3DomBuilder.build((Reader)rdr)));
        }
        catch (XmlPullParserException e) {
            throw new org.apache.maven.shared.utils.xml.pull.XmlPullParserException(e.getMessage());
        }
        String[] roots = configFile.getRoots();
        if (roots == null) {
            ctxBld.mergeConfiguration(this.expandVariables(conv.convertXml((Object)xml)));
        } else {
            block2: for (String r : roots) {
                String[] rootPath;
                PlexusConfigurationWrapper root = xml;
                boolean first = true;
                for (String name : rootPath = r.split("/")) {
                    if (first) {
                        first = false;
                        if (name.equals(root.getName())) continue;
                        continue block2;
                    }
                    if ((root = root.getChild(name)) == null) continue block2;
                }
                ctxBld.mergeConfiguration(this.expandVariables(conv.convertXml((Object)root)));
            }
        }
    }

    private void mergeJsonConfigFile(AnalysisContext.Builder ctxBld, ConfigurationFile configFile, JsonNode config) {
        String[] roots = configFile.getRoots();
        if (roots == null) {
            ctxBld.mergeConfiguration(config);
        } else {
            for (String r : roots) {
                String[] rootPath = r.split("/");
                JsonNode root = config;
                for (String path : rootPath) {
                    root = root.path(path);
                }
                if (root.isMissingNode()) continue;
                ctxBld.mergeConfiguration(root);
            }
        }
    }

    private void convertNewStyleConfigFromXml(AnalysisContext.Builder bld, Revapi revapi) {
        XmlToJson conv = XmlToJson.fromRevapi((Revapi)revapi, PlexusConfigurationWrapper::getName, PlexusConfigurationWrapper::getValue, PlexusConfigurationWrapper::getAttribute, PlexusConfigurationWrapper::getChildren);
        bld.mergeConfiguration(this.expandVariables(conv.convertXml((Object)new PlexusConfigurationWrapper(this.analysisConfiguration))));
    }

    private JsonNode readJson(InputStream in) {
        try {
            return JSONUtil.parse((Reader)JSONUtil.stripComments((InputStream)in));
        }
        catch (IOException e) {
            return null;
        }
    }

    private JsonNode expandVariables(JsonNode config) {
        if (!this.expandProperties) {
            return config;
        }
        if (config.isArray()) {
            for (int i = 0; i < config.size(); ++i) {
                ((ArrayNode)config).set(i, this.expandVariables(config.get(i)));
            }
        } else if (config.isObject()) {
            Iterator it = config.fields();
            while (it.hasNext()) {
                Map.Entry e = (Map.Entry)it.next();
                e.setValue(this.expandVariables((JsonNode)e.getValue()));
            }
        } else {
            config = AnalysisConfigurationGatherer.expandVariable(config, this.propertyValueResolver);
        }
        return config;
    }

    private static JsonNode expandVariable(JsonNode node, PropertyValueResolver resolver) {
        String val = node.toString();
        if (!resolver.containsVariables(val)) {
            return node;
        }
        return JSONUtil.parse((String)resolver.resolve(val));
    }

    private static void plexusToString(int indent, StringBuilder sb, PlexusConfiguration cfg) {
        int childCount;
        AnalysisConfigurationGatherer.indent(sb, indent * 2);
        sb.append("<").append(cfg.getName());
        String[] attrs = cfg.getAttributeNames();
        if (attrs != null && attrs.length > 0) {
            for (String attr : attrs) {
                sb.append(" ").append(attr).append("=\"");
                sb.append(cfg.getAttribute(attr, "$$UNKNOWN$$"));
                sb.append("\"");
            }
        }
        if ((childCount = cfg.getChildCount()) > 0) {
            sb.append(">\n");
            for (int i = 0; i < childCount; ++i) {
                AnalysisConfigurationGatherer.plexusToString(indent + 1, sb, cfg.getChild(i));
                sb.append("\n");
            }
            AnalysisConfigurationGatherer.indent(sb, indent * 2);
            sb.append("</").append(cfg.getName()).append(">");
        } else {
            String val = cfg.getValue(null);
            if (val == null) {
                sb.append(" />");
            } else {
                sb.append(">");
                sb.append(val);
                sb.append("</").append(cfg.getName()).append(">");
            }
        }
    }

    private static void indent(StringBuilder sb, int times) {
        for (int i = 0; i < times; ++i) {
            sb.append(" ");
        }
    }

    private static final class PlexusConfigurationWrapper {
        private final PlexusConfiguration config;

        private PlexusConfigurationWrapper(PlexusConfiguration config) {
            this.config = config;
        }

        public String getName() {
            return this.config.getName();
        }

        public String getValue() {
            return this.config.getValue();
        }

        public String getAttribute(String name) {
            return this.config.getAttribute(name);
        }

        public List<PlexusConfigurationWrapper> getChildren() {
            return Stream.of(this.config.getChildren()).map(PlexusConfigurationWrapper::new).collect(Collectors.toList());
        }

        @Nullable
        public PlexusConfigurationWrapper getChild(String name) {
            PlexusConfiguration c = this.config.getChild(name);
            return c == null ? null : new PlexusConfigurationWrapper(c);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            AnalysisConfigurationGatherer.plexusToString(0, sb, this.config);
            return sb.toString();
        }
    }
}

