/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.revapi.Criticality;
import org.revapi.DifferenceSeverity;
import org.revapi.PipelineConfiguration;
import org.revapi.configuration.JSONUtil;

final class PipelineConfigurationParser {
    private PipelineConfigurationParser() {
    }

    static PipelineConfiguration.Builder parse(PlexusConfiguration pipelineConfiguration2) {
        PipelineConfiguration.Builder ret;
        String jsonConfig;
        String string = jsonConfig = pipelineConfiguration2 == null ? null : pipelineConfiguration2.getValue();
        if (jsonConfig == null) {
            ret = PipelineConfigurationParser.parsePipelineConfigurationXML(pipelineConfiguration2);
        } else {
            JsonNode json = JSONUtil.parse((String)jsonConfig);
            ret = PipelineConfiguration.parse((JsonNode)json);
        }
        return ret;
    }

    private static PipelineConfiguration.Builder parsePipelineConfigurationXML(PlexusConfiguration pipelineConfiguration2) {
        PipelineConfiguration.Builder bld = PipelineConfiguration.builder();
        if (pipelineConfiguration2 == null) {
            return bld;
        }
        block18: for (PlexusConfiguration c : pipelineConfiguration2.getChildren()) {
            switch (c.getName()) {
                case "analyzers": {
                    PipelineConfigurationParser.parseIncludeExclude(c, arg_0 -> ((PipelineConfiguration.Builder)bld).addAnalyzerExtensionIdInclude(arg_0), arg_0 -> ((PipelineConfiguration.Builder)bld).addAnalyzerExtensionIdExclude(arg_0));
                    continue block18;
                }
                case "reporters": {
                    PipelineConfigurationParser.parseIncludeExclude(c, arg_0 -> ((PipelineConfiguration.Builder)bld).addReporterExtensionIdInclude(arg_0), arg_0 -> ((PipelineConfiguration.Builder)bld).addReporterExtensionIdExclude(arg_0));
                    continue block18;
                }
                case "filters": {
                    PipelineConfigurationParser.parseIncludeExclude(c, arg_0 -> ((PipelineConfiguration.Builder)bld).addFilterExtensionIdInclude(arg_0), arg_0 -> ((PipelineConfiguration.Builder)bld).addFilterExtensionIdExclude(arg_0));
                    continue block18;
                }
                case "transforms": {
                    PipelineConfigurationParser.parseIncludeExclude(c, arg_0 -> ((PipelineConfiguration.Builder)bld).addTransformExtensionIdInclude(arg_0), arg_0 -> ((PipelineConfiguration.Builder)bld).addTransformExtensionIdExclude(arg_0));
                    continue block18;
                }
                case "transformBlocks": {
                    for (PlexusConfiguration b : c.getChildren()) {
                        List blockIds = Stream.of(b.getChildren()).map(PlexusConfiguration::getValue).collect(Collectors.toList());
                        bld.addTransformationBlock(blockIds);
                    }
                    continue block18;
                }
                case "criticalities": {
                    for (PlexusConfiguration t : c.getChildren()) {
                        String name = t.getChild("name").getValue();
                        int level = Integer.parseInt(t.getChild("level").getValue());
                        bld.addCriticality(new Criticality(name, level));
                    }
                    continue block18;
                }
                case "severityMapping": {
                    for (PlexusConfiguration m : c.getChildren()) {
                        String severityName = m.getName();
                        String criticalityName = m.getValue();
                        DifferenceSeverity severity = DifferenceSeverity.fromCamelCase((String)severityName);
                        if (severity == null) {
                            throw new IllegalArgumentException("Unknown severity encountered while processing the severityMapping: " + severityName);
                        }
                        bld.addUntypedSeverityMapping(severity, criticalityName);
                    }
                    continue block18;
                }
            }
        }
        return bld;
    }

    private static void parseIncludeExclude(PlexusConfiguration parent, Consumer<String> handleInclude, Consumer<String> handleExclude) {
        PlexusConfiguration include = parent.getChild("include");
        PlexusConfiguration exclude = parent.getChild("exclude");
        if (include != null) {
            Stream.of(include.getChildren()).forEach(c -> handleInclude.accept(c.getValue()));
        }
        if (exclude != null) {
            Stream.of(exclude.getChildren()).forEach(c -> handleExclude.accept(c.getValue()));
        }
    }
}

