/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.revapi.AnalysisContext;
import org.revapi.Revapi;
import org.revapi.configuration.JSONUtil;
import org.revapi.configuration.XmlToJson;
import org.revapi.maven.ConfigurationFile;
import org.revapi.maven.PropertyValueResolver;

final class AnalysisConfigurationGatherer {
    private final PlexusConfiguration analysisConfiguration;
    private final Object[] analysisConfigurationFiles;
    private final boolean failOnMissingConfigurationFiles;
    private final boolean expandProperties;
    private final PropertyValueResolver propertyValueResolver;
    private final File relativePathBaseDir;
    private final Log log;

    AnalysisConfigurationGatherer(PlexusConfiguration analysisConfiguration2, Object[] analysisConfigurationFiles2, boolean failOnMissingConfigurationFiles2, boolean expandProperties2, PropertyValueResolver propertyValueResolver, File relativePathBaseDir, Log log) {
        this.analysisConfiguration = analysisConfiguration2;
        this.analysisConfigurationFiles = analysisConfigurationFiles2;
        this.failOnMissingConfigurationFiles = failOnMissingConfigurationFiles2;
        this.expandProperties = expandProperties2;
        this.log = log;
        this.propertyValueResolver = propertyValueResolver;
        this.relativePathBaseDir = relativePathBaseDir;
    }

    void gatherConfig(Revapi revapi, AnalysisContext.Builder ctxBld) throws MojoExecutionException {
        if (this.analysisConfigurationFiles != null && this.analysisConfigurationFiles.length > 0) {
            for (Object pathOrConfigFile : this.analysisConfigurationFiles) {
                Supplier<Iterator> configFileContents;
                ConfigurationFile configFile;
                if (pathOrConfigFile instanceof String) {
                    configFile = new ConfigurationFile();
                    configFile.setPath((String)pathOrConfigFile);
                } else {
                    configFile = (ConfigurationFile)pathOrConfigFile;
                }
                String path = configFile.getPath();
                String resource = configFile.getResource();
                if (path == null && resource == null) {
                    throw new MojoExecutionException("Either 'path' or 'resource' has to be specified in a configurationFile definition.");
                }
                if (path != null && resource != null) {
                    throw new MojoExecutionException("Either 'path' or 'resource' has to be specified in a configurationFile definition but not both.");
                }
                String readErrorMessage = "Error while processing the configuration file on " + (path == null ? "classpath " + resource : "path " + path);
                if (path != null) {
                    File f = new File(path);
                    if (!f.isAbsolute()) {
                        f = new File(this.relativePathBaseDir, path);
                    }
                    if (!f.isFile() || !f.canRead()) {
                        String message = "Could not locate analysis configuration file '" + f.getAbsolutePath() + "'.";
                        if (this.failOnMissingConfigurationFiles) {
                            throw new MojoExecutionException(message);
                        }
                        this.log.debug((CharSequence)message);
                        continue;
                    }
                    File ff = f;
                    configFileContents = () -> {
                        try {
                            return Collections.singletonList(new FileInputStream(ff)).iterator();
                        }
                        catch (FileNotFoundException e) {
                            throw new IllegalArgumentException("Failed to read the configuration file '" + ff.getAbsolutePath() + "'.", e);
                        }
                    };
                } else {
                    configFileContents = () -> {
                        try {
                            return Collections.list(this.getClass().getClassLoader().getResources(resource)).stream().map(url -> {
                                try {
                                    return url.openStream();
                                }
                                catch (IOException e) {
                                    throw new IllegalArgumentException("Failed to read the classpath resource '" + url + "'.");
                                }
                            }).iterator();
                        }
                        catch (IOException e) {
                            throw new IllegalArgumentException("Failed to locate classpath resources on path '" + resource + "'.");
                        }
                    };
                }
                Iterator it = configFileContents.get();
                ArrayList<Integer> nonJsonIndexes = new ArrayList<Integer>(4);
                int idx = 0;
                while (it.hasNext()) {
                    JsonNode config;
                    try (InputStream in = (InputStream)it.next();){
                        config = this.readJson(in);
                    }
                    catch (IOException | IllegalArgumentException e) {
                        throw new MojoExecutionException(readErrorMessage, e.getCause());
                    }
                    if (config == null) {
                        nonJsonIndexes.add(idx);
                        continue;
                    }
                    config = this.expandVariables(config);
                    this.mergeJsonConfigFile(ctxBld, configFile, config);
                    ++idx;
                }
                if (nonJsonIndexes.isEmpty()) continue;
                idx = 0;
                it = configFileContents.get();
                while (it.hasNext()) {
                    try (InputStreamReader rdr = new InputStreamReader((InputStream)it.next());){
                        if (nonJsonIndexes.contains(idx)) {
                            this.mergeXmlConfigFile(revapi, ctxBld, configFile, rdr);
                        }
                    }
                    catch (IOException | IllegalArgumentException | XmlPullParserException e) {
                        throw new MojoExecutionException(readErrorMessage, e.getCause());
                    }
                    ++idx;
                }
            }
        }
        if (this.analysisConfiguration != null) {
            String text = this.analysisConfiguration.getValue();
            if (text == null || text.isEmpty()) {
                this.convertNewStyleConfigFromXml(ctxBld, revapi);
            } else {
                ctxBld.mergeConfiguration(this.expandVariables(JSONUtil.parse((String)JSONUtil.stripComments((String)text))));
            }
        }
    }

    private void mergeXmlConfigFile(Revapi revapi, AnalysisContext.Builder ctxBld, ConfigurationFile configFile, Reader rdr) throws IOException, XmlPullParserException {
        XmlToJson conv = new XmlToJson(revapi, PlexusConfiguration::getName, PlexusConfiguration::getValue, PlexusConfiguration::getAttribute, x -> Arrays.asList(x.getChildren()));
        XmlPlexusConfiguration xml = new XmlPlexusConfiguration(Xpp3DomBuilder.build((Reader)rdr));
        String[] roots = configFile.getRoots();
        if (roots == null) {
            ctxBld.mergeConfiguration(this.expandVariables(conv.convertXml((Object)xml)));
        } else {
            block0: for (String r : roots) {
                String[] rootPath;
                XmlPlexusConfiguration root = xml;
                boolean first = true;
                for (String name : rootPath = r.split("/")) {
                    if (first) {
                        first = false;
                        if (name.equals(root.getName())) continue;
                        continue block0;
                    }
                    if ((root = root.getChild(name)) == null) continue block0;
                }
                ctxBld.mergeConfiguration(this.expandVariables(conv.convertXml((Object)root)));
            }
        }
    }

    private void mergeJsonConfigFile(AnalysisContext.Builder ctxBld, ConfigurationFile configFile, JsonNode config) {
        String[] roots = configFile.getRoots();
        if (roots == null) {
            ctxBld.mergeConfiguration(config);
        } else {
            for (String r : roots) {
                String[] rootPath = r.split("/");
                JsonNode root = config;
                for (String path : rootPath) {
                    root = root.path(path);
                }
                if (root.isMissingNode()) continue;
                ctxBld.mergeConfiguration(root);
            }
        }
    }

    private void convertNewStyleConfigFromXml(AnalysisContext.Builder bld, Revapi revapi) {
        XmlToJson conv = XmlToJson.fromRevapi((Revapi)revapi, PlexusConfiguration::getName, PlexusConfiguration::getValue, PlexusConfiguration::getAttribute, x -> Arrays.asList(x.getChildren()));
        bld.mergeConfiguration(this.expandVariables(conv.convertXml((Object)this.analysisConfiguration)));
    }

    private JsonNode readJson(InputStream in) {
        try {
            return JSONUtil.parse((Reader)JSONUtil.stripComments((InputStream)in));
        }
        catch (IOException e) {
            return null;
        }
    }

    private JsonNode expandVariables(JsonNode config) {
        if (!this.expandProperties) {
            return config;
        }
        if (config.isArray()) {
            for (int i = 0; i < config.size(); ++i) {
                ((ArrayNode)config).set(i, this.expandVariables(config.get(i)));
            }
        } else if (config.isObject()) {
            Iterator it = config.fields();
            while (it.hasNext()) {
                Map.Entry e = (Map.Entry)it.next();
                e.setValue(this.expandVariables((JsonNode)e.getValue()));
            }
        } else {
            config = AnalysisConfigurationGatherer.expandVariable(config, this.propertyValueResolver);
        }
        return config;
    }

    private static JsonNode expandVariable(JsonNode node, PropertyValueResolver resolver) {
        String val = node.toString();
        if (!resolver.containsVariables(val)) {
            return node;
        }
        return JSONUtil.parse((String)resolver.resolve(val));
    }
}

