/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.revapi.maven.AbstractVersionModifyingMojo;
import org.revapi.maven.Version;

@Mojo(name="update-release-properties", requiresDirectInvocation=true)
@Execute(phase=LifecyclePhase.PACKAGE)
public class UpdateReleasePropertiesMojo
extends AbstractVersionModifyingMojo {
    @Parameter(name="releaseVersionSuffix", property="revapi.releaseVersionSuffix")
    private String releaseVersionSuffix;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.setPreserveSuffix(false);
        this.setReplacementSuffix(this.releaseVersionSuffix);
        super.execute();
    }

    @Override
    void updateProjectVersion(MavenProject project, Version version) throws MojoExecutionException {
        String devProp;
        String relProp;
        File rpf = this.getReleasePropertiesFile();
        Properties ps = this.readProperties(rpf);
        if (this.isSingleVersionForAllModules()) {
            relProp = "project.rel." + project.getGroupId() + ":" + project.getArtifactId();
            devProp = "project.dev." + project.getGroupId() + ":" + project.getArtifactId();
        } else {
            relProp = "releaseVersion";
            devProp = "developmentVersion";
        }
        ps.setProperty(relProp, version.toString());
        Version dev = version.clone();
        dev.setPatch(dev.getPatch() + 1);
        dev.setSuffix(this.releaseVersionSuffix == null ? "SNAPSHOT" : this.releaseVersionSuffix + "-SNAPSHOT");
        ps.setProperty(devProp, dev.toString());
        try (FileOutputStream out = new FileOutputStream(rpf);){
            ps.store(out, null);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write to the release.properties file.", (Exception)e);
        }
    }

    @Override
    void updateProjectParentVersion(MavenProject project, Version version) throws MojoExecutionException {
    }

    private File getReleasePropertiesFile() {
        return new File(this.mavenSession.getExecutionRootDirectory(), "release.properties");
    }

    private Properties readProperties(File file) {
        Properties properties;
        Properties ps = new Properties();
        FileInputStream in = new FileInputStream(file);
        try {
            ps.load(in);
            properties = ps;
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return ps;
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not read the release.properties file.", e);
            }
        }
        in.close();
        return properties;
    }
}

