/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import java.io.File;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.revapi.AnalysisResult;
import org.revapi.Criticality;
import org.revapi.PipelineConfiguration;
import org.revapi.maven.AbstractRevapiMojo;
import org.revapi.maven.BuildTimeReporter;
import org.revapi.maven.JsonSuggestionsBuilder;
import org.revapi.maven.PipelineConfigurationParser;
import org.revapi.maven.XmlSuggestionsBuilder;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class CheckMojo
extends AbstractRevapiMojo {
    @Parameter(property="revapi.outputIgnoreSuggestions", defaultValue="true")
    private boolean outputIgnoreSuggestions;
    @Parameter(property="revapi.outputNonIdentifyingDifferenceInfo", defaultValue="true")
    private boolean outputNonIdentifyingDifferenceInfo;
    @Parameter(property="revapi.ignoreSuggestionsFormat", defaultValue="json")
    private String ignoreSuggestionsFormat;
    @Parameter(property="revapi.ignoreSuggestionsFile", defaultValue="")
    private File ignoreSuggestionsFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        StringWriter wrt = new StringWriter();
        PipelineConfiguration.Builder pipelineCfg = PipelineConfigurationParser.parse(this.pipelineConfiguration);
        Criticality maxCriticality = this.determineMaximumCriticality(pipelineCfg.build());
        try (AnalysisResult res = this.analyze(BuildTimeReporter.class, pipelineCfg, "org.revapi.maven.buildTimeBreakingCriticality", maxCriticality, "maven-log", this.getLog(), "writer", wrt, "org.revapi.maven.outputNonIdentifyingAttachments", this.outputNonIdentifyingDifferenceInfo, "org.revapi.maven.buildTimeSuggestionsBuilder", this.getSuggestionsBuilder());){
            res.throwIfFailed();
            BuildTimeReporter reporter = (BuildTimeReporter)res.getExtensions().getFirstExtension(BuildTimeReporter.class, null);
            if (reporter != null && reporter.hasBreakingProblems()) {
                String report = reporter.getAllProblemsMessage();
                String additionalOutput = wrt.toString();
                if (!additionalOutput.isEmpty()) {
                    report = report + "\n\nAdditionally, the configured reporters reported:\n\n" + additionalOutput;
                }
                if (this.outputIgnoreSuggestions || this.ignoreSuggestionsFile != null) {
                    this.getLog().info((CharSequence)"API problems found.");
                    String message = "If you're using the semver-ignore extension, update your module's version to one compatible with the current changes (e.g. mvn package revapi:update-versions). If you want to explicitly ignore these changes or provide justifications for them, add the " + this.ignoreSuggestionsFormat + " snippets to your Revapi configuration for the \"revapi.differences\" extension.";
                    String suggestions = reporter.getIgnoreSuggestion();
                    if (this.outputIgnoreSuggestions) {
                        this.getLog().info((CharSequence)(message + "\n\n" + suggestions));
                    }
                    if (this.ignoreSuggestionsFile != null && suggestions != null) {
                        Files.write(this.ignoreSuggestionsFile.toPath(), suggestions.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
                        if (!this.outputIgnoreSuggestions) {
                            this.getLog().info((CharSequence)message);
                        }
                        this.getLog().info((CharSequence)("Snippets written to " + this.ignoreSuggestionsFile));
                    }
                    if (this.failBuildOnProblemsFound) {
                        report = report + "\nConsult the plugin output above for suggestions on how to ignore the found problems.";
                    }
                }
                if (this.failBuildOnProblemsFound) {
                    throw new MojoFailureException(report);
                }
                if (!this.outputIgnoreSuggestions) {
                    this.getLog().info((CharSequence)"API problems found but letting the build pass as configured.");
                    Stream.of(report.split("\n")).forEach(l -> this.getLog().info((CharSequence)l));
                }
            } else {
                this.getLog().info((CharSequence)"API checks completed without failures.");
            }
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to execute the API analysis.", e);
        }
    }

    private BuildTimeReporter.SuggestionsBuilder getSuggestionsBuilder() {
        switch (this.ignoreSuggestionsFormat) {
            case "json": {
                return new JsonSuggestionsBuilder();
            }
            case "xml": {
                return new XmlSuggestionsBuilder();
            }
        }
        throw new IllegalArgumentException("`ignoreSuggestionsFormat` only accepts \"json\" or \"xml\" but \"" + this.ignoreSuggestionsFormat + "\" was provided.");
    }
}

