/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.revapi.AnalysisResult;
import org.revapi.Criticality;
import org.revapi.DifferenceSeverity;
import org.revapi.PipelineConfiguration;
import org.revapi.Reporter;
import org.revapi.maven.Analyzer;
import org.revapi.maven.AnalyzerBuilder;
import org.revapi.maven.FailSeverity;
import org.revapi.maven.PromotedDependency;

abstract class AbstractRevapiMojo
extends AbstractMojo {
    @Parameter(property="", defaultValue="")
    protected PlexusConfiguration pipelineConfiguration;
    @Parameter(property="", defaultValue="")
    protected PlexusConfiguration analysisConfiguration;
    @Parameter(property="revapi.failOnMissingConfigurationFiles", defaultValue="true")
    protected boolean failOnMissingConfigurationFiles;
    @Parameter(property="revapi.analysisConfigurationFiles", defaultValue="")
    protected Object[] analysisConfigurationFiles;
    @Parameter(property="", defaultValue="")
    protected PromotedDependency[] promotedDependencies;
    @Parameter(property="revapi.oldArtifacts", defaultValue="")
    protected String[] oldArtifacts;
    @Parameter(property="revapi.oldVersion", defaultValue="RELEASE")
    protected String oldVersion;
    @Parameter(property="", defaultValue="")
    protected PromotedDependency[] oldPromotedDependencies;
    @Parameter(property="revapi.newArtifacts", defaultValue="")
    protected String[] newArtifacts;
    @Parameter(property="revapi.newVersion", defaultValue="${project.version}")
    protected String newVersion;
    @Parameter(property="", defaultValue="")
    protected PromotedDependency[] newPromotedDependencies;
    @Parameter(property="revapi.skip", defaultValue="false")
    protected boolean skip;
    @Deprecated
    @Parameter(property="revapi.failSeverity", defaultValue="potentiallyBreaking")
    protected FailSeverity failSeverity;
    @Parameter(property="revapi.maximumCriticality")
    protected String failCriticality;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Component
    protected RepositorySystem repositorySystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected RepositorySystemSession repositorySystemSession;
    @Parameter(property="revapi.alwaysCheckForReleaseVersion", defaultValue="true")
    protected boolean alwaysCheckForReleaseVersion;
    @Parameter(property="revapi.failBuildOnProblemsFound", defaultValue="true")
    protected boolean failBuildOnProblemsFound;
    @Parameter(property="revapi.failOnUnresolvedArtifacts", defaultValue="false")
    protected boolean failOnUnresolvedArtifacts;
    @Parameter(property="revapi.failOnUnresolvedDependencies", defaultValue="false")
    protected boolean failOnUnresolvedDependencies;
    @Parameter(property="revapi.checkDependencies", defaultValue="true")
    protected boolean checkDependencies;
    @Parameter(property="revapi.resolveProvidedDependencies", defaultValue="true")
    protected boolean resolveProvidedDependencies;
    @Parameter(property="revapi.resolveTransitiveProvidedDependencies", defaultValue="false")
    protected boolean resolveTransitiveProvidedDependencies;
    @Parameter(property="revapi.versionFormat", defaultValue="")
    protected String versionFormat;
    @Deprecated
    @Parameter(property="revapi.disallowedExtensions", defaultValue="")
    protected String disallowedExtensions;
    @Parameter(property="revapi.expandProperties", defaultValue="false")
    protected boolean expandProperties;

    AbstractRevapiMojo() {
    }

    static Criticality determineCriticality(PipelineConfiguration configuration, String propertyValue, String propertyName, DifferenceSeverity fallBackSeverity) throws MojoExecutionException {
        if (propertyValue != null) {
            return configuration.getCriticalities().stream().filter(c -> propertyValue.equals(c.getName())).findFirst().orElseThrow(() -> new MojoExecutionException("'" + propertyName + "' is not a valid criticality. Please use one of the values defined in the pipeline configuration for the " + propertyName + "."));
        }
        return (Criticality)configuration.getSeverityMapping().get(fallBackSeverity);
    }

    protected Criticality determineMaximumCriticality(PipelineConfiguration pipelineConfiguration2) throws MojoExecutionException {
        return AbstractRevapiMojo.determineCriticality(pipelineConfiguration2, this.failCriticality, "maximumCriticality", this.failSeverity.asDifferenceSeverity());
    }

    protected AnalysisResult analyze(Class<? extends Reporter> reporter, PipelineConfiguration.Builder pipelineConfiguration2, Object ... contextDataKeyValues) throws MojoExecutionException, MojoFailureException {
        Analyzer analyzer = this.prepareAnalyzer(this.project, pipelineConfiguration2, reporter, this.toContextData(contextDataKeyValues));
        if (analyzer != null) {
            return analyzer.analyze();
        }
        return AnalysisResult.fakeSuccess();
    }

    protected Analyzer prepareAnalyzer(MavenProject project, PipelineConfiguration.Builder pipelineConfiguration2, Class<? extends Reporter> reporter, Map<String, Object> contextData) {
        AnalyzerBuilder.Result res = this.buildAnalyzer(project, pipelineConfiguration2, reporter, contextData);
        if (res.skip) {
            this.skip = true;
        }
        this.oldArtifacts = res.oldArtifacts;
        this.newArtifacts = res.newArtifacts;
        return res.analyzer;
    }

    protected Analyzer prepareAnalyzer(MavenProject project, PipelineConfiguration.Builder pipelineConfiguration2, Class<? extends Reporter> reporter, Map<String, Object> contextData, Map<String, Object> propertyOverrides) {
        AnalyzerBuilder.Result res = this.buildAnalyzer(project, pipelineConfiguration2, reporter, contextData, propertyOverrides);
        if (res.skip) {
            this.skip = true;
        }
        this.oldArtifacts = res.oldArtifacts;
        this.newArtifacts = res.newArtifacts;
        return res.analyzer;
    }

    AnalyzerBuilder.Result buildAnalyzer(MavenProject project, PipelineConfiguration.Builder pipelineConfiguration2, Class<? extends Reporter> reporter, Map<String, Object> contextData) {
        return this.buildAnalyzer(project, pipelineConfiguration2, reporter, contextData, Collections.emptyMap());
    }

    AnalyzerBuilder.Result buildAnalyzer(MavenProject project, PipelineConfiguration.Builder pipelineConfiguration2, Class<? extends Reporter> reporter, Map<String, Object> contextData, Map<String, Object> propertyOverrides) {
        return AnalyzerBuilder.forGavs(this.oldArtifacts, this.newArtifacts).withAlwaysCheckForReleasedVersion(this.overrideOrDefault("alwaysCheckForReleaseVersion", this.alwaysCheckForReleaseVersion, propertyOverrides)).withPipelineConfiguration(pipelineConfiguration2).withAnalysisConfiguration(this.overrideOrDefault("analysisConfiguration", this.analysisConfiguration, propertyOverrides)).withAnalysisConfigurationFiles(this.overrideOrDefault("analysisConfigurationFiles", this.analysisConfigurationFiles, propertyOverrides)).withCheckDependencies(this.overrideOrDefault("checkDependencies", this.checkDependencies, propertyOverrides)).withResolveProvidedDependencies(this.overrideOrDefault("resolveProvidedDependencies", this.resolveProvidedDependencies, propertyOverrides)).withResolveTransitiveProvidedDependencies(this.overrideOrDefault("resolveTransitiveProvidedDependencies", this.resolveTransitiveProvidedDependencies, propertyOverrides)).withDisallowedExtensions(this.overrideOrDefault("disallowedExtensions", this.disallowedExtensions, propertyOverrides)).withFailOnMissingConfigurationFiles(this.overrideOrDefault("failOnMissingConfigurationFiles", this.failOnMissingConfigurationFiles, propertyOverrides)).withFailOnUnresolvedArtifacts(this.overrideOrDefault("failOnUnresolvedArtifacts", this.failOnUnresolvedArtifacts, propertyOverrides)).withFailOnUnresolvedDependencies(this.overrideOrDefault("failOnUnresolvedDependencies", this.failOnUnresolvedDependencies, propertyOverrides)).withLocale(Locale.getDefault()).withLog(this.getLog()).withNewVersion(this.overrideOrDefault("newVersion", this.newVersion, propertyOverrides)).withOldVersion(this.overrideOrDefault("oldVersion", this.oldVersion, propertyOverrides)).withProject(project).withReporter(reporter).withRepositorySystem(this.repositorySystem).withRepositorySystemSession(this.repositorySystemSession).withSkip(this.overrideOrDefault("skip", this.skip, propertyOverrides)).withVersionFormat(this.overrideOrDefault("versionFormat", this.versionFormat, propertyOverrides)).withContextData(contextData).withExpandProperties(this.overrideOrDefault("expandProperties", this.expandProperties, propertyOverrides)).withNewPromotedDependencies(this.newPromotedDependencies == null ? this.promotedDependencies : this.newPromotedDependencies).withOldPromotedDependencies(this.oldPromotedDependencies == null ? this.promotedDependencies : this.oldPromotedDependencies).build();
    }

    private <T> T overrideOrDefault(String propertyName, T defaultValue, Map<String, Object> overrides) {
        Object val = overrides.get(propertyName);
        if (val == null) {
            return defaultValue;
        }
        return (T)val;
    }

    protected boolean initializeComparisonArtifacts() {
        if (this.newArtifacts != null && this.newArtifacts.length == 1 && "BUILD".equals(this.newArtifacts[0])) {
            this.getLog().warn((CharSequence)"\"BUILD\" coordinates are deprecated. Just leave \"newArtifacts\" undefined and specify \"${project.version}\" as the value for \"newVersion\" (which is the default, so you don't actually have to do that either).");
            this.oldArtifacts = null;
        }
        if (this.oldArtifacts == null || this.oldArtifacts.length == 0) {
            this.oldArtifacts = new String[]{Analyzer.getProjectArtifactCoordinates(this.project, this.oldVersion)};
            if (!this.project.getArtifact().getArtifactHandler().isAddedToClasspath()) {
                return false;
            }
        }
        if (this.newArtifacts == null || this.newArtifacts.length == 0) {
            this.newArtifacts = new String[]{Analyzer.getProjectArtifactCoordinates(this.project, this.newVersion)};
            if (!this.project.getArtifact().getArtifactHandler().isAddedToClasspath()) {
                return false;
            }
        }
        return true;
    }

    private Map<String, Object> toContextData(Object ... contextDataKeyValues) {
        if (contextDataKeyValues.length % 2 != 0) {
            throw new IllegalArgumentException("Key-value pairs not balanced.");
        }
        HashMap<String, Object> ret = new HashMap<String, Object>(contextDataKeyValues.length / 2);
        boolean isKey = true;
        String key = null;
        for (Object kv : contextDataKeyValues) {
            if (isKey) {
                if (!(kv instanceof String)) {
                    throw new IllegalArgumentException("Found non-string key.");
                }
                key = (String)kv;
                isKey = false;
                continue;
            }
            ret.put(key, kv);
            isKey = true;
        }
        return ret;
    }
}

