/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.revapi.configuration.ValidationResult;
import org.revapi.maven.AbstractRevapiMojo;
import org.revapi.maven.Analyzer;
import org.revapi.maven.PipelineConfigurationParser;
import org.revapi.simple.SimpleReporter;

@Mojo(name="validate-configuration", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class ValidateConfigurationMojo
extends AbstractRevapiMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        Analyzer analyzer = this.prepareAnalyzer(this.project, PipelineConfigurationParser.parse(this.pipelineConfiguration), ValidateReporter.class, Collections.emptyMap());
        try {
            ValidationResult res;
            if (analyzer != null && !(res = analyzer.validateConfiguration()).isSuccessful()) {
                String errors = res.getErrors() == null ? "" : Stream.of(res.getErrors()).map(e -> e.message + " @ " + e.dataPath).collect(Collectors.joining(", ", "Errors: ", ""));
                String missingSchemas = res.getMissingSchemas() == null ? "" : Stream.of(res.getMissingSchemas()).collect(Collectors.joining(", ", "Missing schemas: ", ""));
                throw new MojoExecutionException("Failed to validate configuration. " + errors + " " + missingSchemas);
            }
        }
        catch (MojoExecutionException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new MojoExecutionException("Failed to validate configuration.", e3);
        }
    }

    public static final class ValidateReporter
    extends SimpleReporter {
        public String getExtensionId() {
            return "revapi.maven.validate-configuration-mojo-reporter";
        }
    }
}

