/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.maven.model.Model;
import org.apache.maven.model.interpolation.MavenBuildTimestamp;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.AbstractValueSource;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PrefixedValueSourceWrapper;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.ValueSource;

public final class PropertyValueInterpolator {
    private static final List<String> PROJECT_PREFIXES = Arrays.asList("project.", "pom.");
    private final List<ValueSource> valueSources;

    public PropertyValueInterpolator(Properties props) {
        this.valueSources = Collections.singletonList(new PropertiesBasedValueSource(props));
    }

    public PropertyValueInterpolator(MavenProject project) {
        this.valueSources = new ArrayList<ValueSource>(8);
        final MavenBuildTimestamp now = new MavenBuildTimestamp();
        Model model = project.getModel();
        Properties modelProperties = model.getProperties();
        final File projectDir = project.getBasedir();
        PrefixedObjectValueSource prefixedProjectValues = new PrefixedObjectValueSource(PROJECT_PREFIXES, (Object)model, false);
        this.valueSources.add((ValueSource)prefixedProjectValues);
        ObjectBasedValueSource unprefixedProjectValues = new ObjectBasedValueSource((Object)model);
        this.valueSources.add((ValueSource)unprefixedProjectValues);
        PrefixedValueSourceWrapper basedirValueSource = new PrefixedValueSourceWrapper((ValueSource)new AbstractValueSource(false){

            public Object getValue(String expression) {
                if ("basedir".equals(expression)) {
                    return projectDir.getAbsolutePath();
                }
                return null;
            }
        }, PROJECT_PREFIXES, true);
        this.valueSources.add((ValueSource)basedirValueSource);
        PrefixedValueSourceWrapper baseUriValueSource = new PrefixedValueSourceWrapper((ValueSource)new AbstractValueSource(false){

            public Object getValue(String expression) {
                if ("baseUri".equals(expression)) {
                    return projectDir.getAbsoluteFile().toURI().toString();
                }
                return null;
            }
        }, PROJECT_PREFIXES, false);
        this.valueSources.add((ValueSource)baseUriValueSource);
        PrefixedValueSourceWrapper buildTimeStampValueSource = new PrefixedValueSourceWrapper((ValueSource)new AbstractValueSource(false){

            public Object getValue(String expression) {
                if ("build.timestamp".equals(expression)) {
                    return now.formattedTimestamp();
                }
                return null;
            }
        }, Collections.singletonList("maven."), true);
        this.valueSources.add((ValueSource)buildTimeStampValueSource);
        this.valueSources.add((ValueSource)new MapBasedValueSource((Map)System.getProperties()));
        this.valueSources.add((ValueSource)new MapBasedValueSource((Map)modelProperties));
        try {
            this.valueSources.add((ValueSource)new EnvarBasedValueSource(false));
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not construct environment variable value source for property interpolation.");
        }
    }

    public String interpolate(String name) {
        return this.valueSources.stream().map(s -> s.getValue(name)).filter(Objects::nonNull).map(Object::toString).findFirst().orElse(null);
    }
}

