/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.revapi.API;
import org.revapi.AnalysisContext;
import org.revapi.AnalysisResult;
import org.revapi.PipelineConfiguration;
import org.revapi.Reporter;
import org.revapi.Revapi;
import org.revapi.configuration.ValidationResult;
import org.revapi.maven.AnalysisConfigurationGatherer;
import org.revapi.maven.MavenArchive;
import org.revapi.maven.PropertyValueInterpolator;
import org.revapi.maven.utils.ArtifactResolver;

public final class Analyzer {
    private static final Pattern ANY_NON_SNAPSHOT = Pattern.compile("^.*(?<!-SNAPSHOT)$");
    private static final Pattern ANY = Pattern.compile(".*");
    private final PipelineConfiguration.Builder pipelineConfiguration;
    private final String[] oldGavs;
    private final String[] newGavs;
    private final org.eclipse.aether.artifact.Artifact[] oldArtifacts;
    private final org.eclipse.aether.artifact.Artifact[] newArtifacts;
    private final MavenProject project;
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession repositorySystemSession;
    private final Class<? extends Reporter> reporterType;
    private final Map<String, Object> contextData;
    private final Locale locale;
    private final Log log;
    private final boolean failOnMissingArchives;
    private final boolean failOnMissingSupportArchives;
    private final Consumer<PipelineConfiguration.Builder> pipelineModifier;
    private final boolean resolveDependencies;
    private final AnalysisConfigurationGatherer configGatherer;
    private final Pattern versionRegex;
    private API resolvedOldApi;
    private API resolvedNewApi;
    private Revapi revapi;

    Analyzer(PipelineConfiguration.Builder pipelineConfiguration2, PlexusConfiguration analysisConfiguration2, Object[] analysisConfigurationFiles2, org.eclipse.aether.artifact.Artifact[] oldArtifacts2, org.eclipse.aether.artifact.Artifact[] newArtifacts2, String[] oldGavs, String[] newGavs, MavenProject project, RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession, Class<? extends Reporter> reporterType, Map<String, Object> contextData, Locale locale, Log log, boolean failOnMissingConfigurationFiles2, boolean failOnMissingArchives, boolean failOnMissingSupportArchives, boolean alwaysUpdate, boolean resolveDependencies, boolean resolveProvidedDependencies2, boolean resolveTransitiveProvidedDependencies2, boolean expandProperties2, String versionRegex, Consumer<PipelineConfiguration.Builder> pipelineModifier, Revapi sharedRevapi) {
        this.pipelineConfiguration = pipelineConfiguration2;
        this.oldGavs = oldGavs;
        this.newGavs = newGavs;
        this.oldArtifacts = oldArtifacts2;
        this.newArtifacts = newArtifacts2;
        this.project = project;
        this.repositorySystem = repositorySystem;
        this.resolveDependencies = resolveDependencies;
        this.versionRegex = versionRegex == null ? null : Pattern.compile(versionRegex);
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(repositorySystemSession);
        session.setDependencySelector(ArtifactResolver.getRevapiDependencySelector((boolean)resolveProvidedDependencies2, (boolean)resolveTransitiveProvidedDependencies2));
        session.setDependencyTraverser(ArtifactResolver.getRevapiDependencyTraverser((boolean)resolveProvidedDependencies2, (boolean)resolveTransitiveProvidedDependencies2));
        if (alwaysUpdate) {
            session.setUpdatePolicy("always");
        }
        this.repositorySystemSession = session;
        this.reporterType = reporterType;
        this.contextData = contextData;
        this.locale = locale;
        this.log = log;
        this.failOnMissingArchives = failOnMissingArchives;
        this.failOnMissingSupportArchives = failOnMissingSupportArchives;
        this.revapi = sharedRevapi;
        this.pipelineModifier = pipelineModifier;
        this.configGatherer = new AnalysisConfigurationGatherer(analysisConfiguration2, analysisConfigurationFiles2, failOnMissingConfigurationFiles2, expandProperties2, new PropertyValueInterpolator(project), project.getBasedir(), log);
    }

    public static String getProjectArtifactCoordinates(MavenProject project, String versionOverride) {
        String version;
        Artifact artifact = project.getArtifact();
        String extension = artifact.getArtifactHandler().getExtension();
        String string = version = versionOverride == null ? project.getVersion() : versionOverride;
        if (artifact.hasClassifier()) {
            return project.getGroupId() + ":" + project.getArtifactId() + ":" + extension + ":" + artifact.getClassifier() + ":" + version;
        }
        return project.getGroupId() + ":" + project.getArtifactId() + ":" + extension + ":" + version;
    }

    ValidationResult validateConfiguration() throws Exception {
        this.buildRevapi();
        AnalysisContext.Builder ctxBuilder = AnalysisContext.builder((Revapi)this.revapi).withLocale(this.locale);
        this.configGatherer.gatherConfig(this.revapi, ctxBuilder);
        ctxBuilder.withData(this.contextData);
        return this.revapi.validateConfiguration(ctxBuilder.build());
    }

    static org.eclipse.aether.artifact.Artifact resolveConstrained(MavenProject project, String gav, Pattern versionRegex, ArtifactResolver resolver) throws VersionRangeResolutionException, ArtifactResolutionException {
        boolean latest = gav.endsWith(":LATEST");
        if (latest || gav.endsWith(":RELEASE")) {
            DefaultArtifact a = new DefaultArtifact(gav);
            versionRegex = latest ? (versionRegex == null ? ANY : versionRegex) : (versionRegex == null ? ANY_NON_SNAPSHOT : versionRegex);
            String upTo = project.getGroupId().equals(a.getGroupId()) && project.getArtifactId().equals(a.getArtifactId()) ? project.getVersion() : null;
            return resolver.resolveNewestMatching(gav, upTo, versionRegex, latest, latest);
        }
        String projectGav = Analyzer.getProjectArtifactCoordinates(project, null);
        org.eclipse.aether.artifact.Artifact ret = null;
        if (projectGav.equals(gav)) {
            ret = Analyzer.findProjectArtifact(project);
        }
        return ret == null ? resolver.resolveArtifact(gav) : ret;
    }

    private static org.eclipse.aether.artifact.Artifact findProjectArtifact(MavenProject project) {
        String extension = project.getArtifact().getArtifactHandler().getExtension();
        String fileName = project.getModel().getBuild().getFinalName() + "." + extension;
        File f = new File(new File(project.getBasedir(), "target"), fileName);
        if (f.exists()) {
            org.eclipse.aether.artifact.Artifact ret = RepositoryUtils.toArtifact((Artifact)project.getArtifact());
            return ret.setFile(f);
        }
        return null;
    }

    void resolveArtifacts() {
        if (this.resolvedOldApi == null) {
            ArtifactResolver resolver = new ArtifactResolver(this.repositorySystem, this.repositorySystemSession, this.project.getRemoteProjectRepositories());
            Function<String, MavenArchive> toFileArchive = gav -> {
                try {
                    org.eclipse.aether.artifact.Artifact a = Analyzer.resolveConstrained(this.project, gav, this.versionRegex, resolver);
                    return MavenArchive.of(a);
                }
                catch (IllegalArgumentException | ArtifactResolutionException | VersionRangeResolutionException e) {
                    throw new MarkerException(e.getMessage(), e);
                }
            };
            List<Object> oldArchives = new ArrayList(1);
            try {
                if (this.oldGavs != null) {
                    oldArchives = Stream.of(this.oldGavs).map(toFileArchive).collect(Collectors.toList());
                }
                if (this.oldArtifacts != null) {
                    oldArchives.addAll(Stream.of(this.oldArtifacts).map(MavenArchive::of).collect(Collectors.toList()));
                }
            }
            catch (IllegalArgumentException | MarkerException e) {
                String message = "Failed to resolve old artifacts: " + e.getMessage() + ".";
                if (this.failOnMissingArchives) {
                    throw new IllegalStateException(message, e);
                }
                this.log.warn((CharSequence)(message + " The API analysis will proceed comparing the new archives against an empty archive."));
            }
            List<Object> newArchives = new ArrayList(1);
            try {
                if (this.newGavs != null) {
                    newArchives = Stream.of(this.newGavs).map(toFileArchive).collect(Collectors.toList());
                }
                if (this.newArtifacts != null) {
                    newArchives.addAll(Stream.of(this.newArtifacts).map(MavenArchive::of).collect(Collectors.toList()));
                }
            }
            catch (IllegalArgumentException | MarkerException e) {
                String message = "Failed to resolve new artifacts: " + e.getMessage() + ".";
                if (this.failOnMissingArchives) {
                    throw new IllegalStateException(message, e);
                }
                this.log.warn((CharSequence)(message + " The API analysis will not proceed."));
                return;
            }
            HashSet<MavenArchive> oldTransitiveDeps = new HashSet<MavenArchive>();
            HashSet<MavenArchive> newTransitiveDeps = new HashSet<MavenArchive>();
            if (this.resolveDependencies) {
                String[] resolvedOld = (String[])oldArchives.stream().map(MavenArchive::getName).toArray(String[]::new);
                String[] resolvedNew = (String[])newArchives.stream().map(MavenArchive::getName).toArray(String[]::new);
                oldTransitiveDeps.addAll(this.collectDeps("old", resolver, resolvedOld));
                newTransitiveDeps.addAll(this.collectDeps("new", resolver, resolvedNew));
            }
            this.resolvedOldApi = API.of(oldArchives).supportedBy(oldTransitiveDeps).build();
            this.resolvedNewApi = API.of(newArchives).supportedBy(newTransitiveDeps).build();
        }
    }

    private Set<MavenArchive> collectDeps(String depDescription, ArtifactResolver resolver, String ... gavs) {
        try {
            if (gavs == null) {
                return Collections.emptySet();
            }
            ArtifactResolver.CollectionResult res = resolver.collectTransitiveDeps(gavs);
            return this.collectDeps(depDescription, res);
        }
        catch (RepositoryException e) {
            return this.handleResolutionError((Exception)((Object)e), depDescription, null);
        }
    }

    private Set<MavenArchive> collectDeps(String depDescription, ArtifactResolver.CollectionResult res) {
        HashSet<MavenArchive> ret = null;
        try {
            ret = new HashSet<MavenArchive>();
            for (org.eclipse.aether.artifact.Artifact a : res.getResolvedArtifacts()) {
                try {
                    ret.add(MavenArchive.of(a));
                }
                catch (IllegalArgumentException e) {
                    res.getFailures().add(e);
                }
            }
            if (!res.getFailures().isEmpty()) {
                StringBuilder bld = new StringBuilder();
                for (Exception e : res.getFailures()) {
                    bld.append(e.getMessage()).append(", ");
                }
                bld.replace(bld.length() - 2, bld.length(), "");
                throw new MarkerException("Resolution of some artifacts failed: " + bld.toString());
            }
            return ret;
        }
        catch (MarkerException e) {
            return this.handleResolutionError(e, depDescription, ret);
        }
    }

    private Set<MavenArchive> handleResolutionError(Exception e, String depDescription, Set<MavenArchive> toReturn) {
        String message = "Failed to resolve dependencies of " + depDescription + " artifacts: " + e.getMessage() + ".";
        if (this.failOnMissingSupportArchives) {
            throw new IllegalArgumentException(message, e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.warn((CharSequence)(message + ". The API analysis might produce unexpected results."), (Throwable)e);
        } else {
            this.log.warn((CharSequence)(message + ". The API analysis might produce unexpected results."));
        }
        return toReturn == null ? Collections.emptySet() : toReturn;
    }

    AnalysisResult analyze() throws MojoExecutionException {
        this.resolveArtifacts();
        if (this.resolvedOldApi == null || this.resolvedNewApi == null) {
            return AnalysisResult.fakeSuccess();
        }
        List oldArchives = StreamSupport.stream(this.resolvedOldApi.getArchives().spliterator(), false).map(MavenArchive::getName).collect(Collectors.toList());
        List newArchives = StreamSupport.stream(this.resolvedNewApi.getArchives().spliterator(), false).map(MavenArchive::getName).collect(Collectors.toList());
        this.log.info((CharSequence)("Comparing " + oldArchives + " against " + newArchives + (this.resolveDependencies ? " (including their transitive dependencies)." : ".")));
        try {
            this.buildRevapi();
            AnalysisContext.Builder ctxBuilder = AnalysisContext.builder((Revapi)this.revapi).withOldAPI(this.resolvedOldApi).withNewAPI(this.resolvedNewApi).withLocale(this.locale);
            this.configGatherer.gatherConfig(this.revapi, ctxBuilder);
            ctxBuilder.withData(this.contextData);
            AnalysisContext ctx = ctxBuilder.build();
            this.log.debug((CharSequence)("Effective analysis configuration:\n" + ctx.getConfiguration().toJSONString(false)));
            return this.revapi.analyze(ctxBuilder.build());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to analyze archives", e);
        }
    }

    public API getResolvedNewApi() {
        return this.resolvedNewApi;
    }

    public API getResolvedOldApi() {
        return this.resolvedOldApi;
    }

    public Revapi getRevapi() {
        this.buildRevapi();
        return this.revapi;
    }

    private void buildRevapi() {
        if (this.revapi == null) {
            this.pipelineModifier.accept(this.pipelineConfiguration);
            if (this.reporterType != null) {
                this.pipelineConfiguration.withReporters(new Class[]{this.reporterType});
            }
            this.revapi = new Revapi(this.pipelineConfiguration.build());
        }
    }

    private static final class MarkerException
    extends RuntimeException {
        public MarkerException(String message) {
            super(message);
        }

        public MarkerException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

