/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Supplier;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ValueExpression;
import org.jboss.dmr.ValueExpressionResolver;
import org.revapi.AnalysisContext;
import org.revapi.Revapi;
import org.revapi.configuration.JSONUtil;
import org.revapi.configuration.XmlToJson;
import org.revapi.maven.ConfigurationFile;
import org.revapi.maven.PropertyValueInterpolator;

final class AnalysisConfigurationGatherer {
    private final PlexusConfiguration analysisConfiguration;
    private final Object[] analysisConfigurationFiles;
    private final boolean failOnMissingConfigurationFiles;
    private final boolean expandProperties;
    private final ValueExpressionResolver resolver;
    private final File relativePathBaseDir;
    private final Log log;

    AnalysisConfigurationGatherer(PlexusConfiguration analysisConfiguration2, Object[] analysisConfigurationFiles2, boolean failOnMissingConfigurationFiles2, boolean expandProperties2, PropertyValueInterpolator interpolator, File relativePathBaseDir, Log log) {
        this.analysisConfiguration = analysisConfiguration2;
        this.analysisConfigurationFiles = analysisConfigurationFiles2;
        this.failOnMissingConfigurationFiles = failOnMissingConfigurationFiles2;
        this.expandProperties = expandProperties2;
        this.log = log;
        this.resolver = new PropertyExpressionResolver(interpolator);
        this.relativePathBaseDir = relativePathBaseDir;
    }

    void gatherConfig(Revapi revapi, AnalysisContext.Builder ctxBld) throws MojoExecutionException {
        if (this.analysisConfigurationFiles != null && this.analysisConfigurationFiles.length > 0) {
            for (Object pathOrConfigFile : this.analysisConfigurationFiles) {
                Supplier<Iterator> configFileContents;
                ConfigurationFile configFile;
                if (pathOrConfigFile instanceof String) {
                    configFile = new ConfigurationFile();
                    configFile.setPath((String)pathOrConfigFile);
                } else {
                    configFile = (ConfigurationFile)pathOrConfigFile;
                }
                String path = configFile.getPath();
                String resource = configFile.getResource();
                if (path == null && resource == null) {
                    throw new MojoExecutionException("Either 'path' or 'resource' has to be specified in a configurationFile definition.");
                }
                if (path != null && resource != null) {
                    throw new MojoExecutionException("Either 'path' or 'resource' has to be specified in a configurationFile definition but not both.");
                }
                String readErrorMessage = "Error while processing the configuration file on " + (path == null ? "classpath " + resource : "path " + path);
                if (path != null) {
                    File f = new File(path);
                    if (!f.isAbsolute()) {
                        f = new File(this.relativePathBaseDir, path);
                    }
                    if (!f.isFile() || !f.canRead()) {
                        String message = "Could not locate analysis configuration file '" + f.getAbsolutePath() + "'.";
                        if (this.failOnMissingConfigurationFiles) {
                            throw new MojoExecutionException(message);
                        }
                        this.log.debug((CharSequence)message);
                        continue;
                    }
                    File ff = f;
                    configFileContents = () -> {
                        try {
                            return Collections.singletonList(new FileInputStream(ff)).iterator();
                        }
                        catch (FileNotFoundException e) {
                            throw new IllegalArgumentException("Failed to read the configuration file '" + ff.getAbsolutePath() + "'.", e);
                        }
                    };
                } else {
                    configFileContents = () -> {
                        try {
                            return Collections.list(this.getClass().getClassLoader().getResources(resource)).stream().map(url -> {
                                try {
                                    return url.openStream();
                                }
                                catch (IOException e) {
                                    throw new IllegalArgumentException("Failed to read the classpath resource '" + url + "'.");
                                }
                            }).iterator();
                        }
                        catch (IOException e) {
                            throw new IllegalArgumentException("Failed to locate classpath resources on path '" + resource + "'.");
                        }
                    };
                }
                Iterator it = configFileContents.get();
                ArrayList<Integer> nonJsonIndexes = new ArrayList<Integer>(4);
                int idx = 0;
                while (it.hasNext()) {
                    ModelNode config;
                    try (InputStream in = (InputStream)it.next();){
                        config = this.readJson(in);
                    }
                    catch (IOException | IllegalArgumentException e) {
                        throw new MojoExecutionException(readErrorMessage, e.getCause());
                    }
                    if (config == null) {
                        nonJsonIndexes.add(idx);
                        continue;
                    }
                    this.expandVariables(config);
                    this.mergeJsonConfigFile(ctxBld, configFile, config);
                    ++idx;
                }
                if (nonJsonIndexes.isEmpty()) continue;
                idx = 0;
                it = configFileContents.get();
                while (it.hasNext()) {
                    try (InputStreamReader rdr = new InputStreamReader((InputStream)it.next());){
                        if (nonJsonIndexes.contains(idx)) {
                            this.mergeXmlConfigFile(revapi, ctxBld, configFile, rdr);
                        }
                    }
                    catch (IOException | IllegalArgumentException | XmlPullParserException e) {
                        throw new MojoExecutionException(readErrorMessage, e.getCause());
                    }
                    ++idx;
                }
            }
        }
        if (this.analysisConfiguration != null) {
            String text = this.analysisConfiguration.getValue();
            if (text == null || text.isEmpty()) {
                this.convertNewStyleConfigFromXml(ctxBld, revapi);
            } else {
                ctxBld.mergeConfiguration(this.expandVariables(ModelNode.fromJSONString((String)JSONUtil.stripComments((String)text))));
            }
        }
    }

    private void mergeXmlConfigFile(Revapi revapi, AnalysisContext.Builder ctxBld, ConfigurationFile configFile, Reader rdr) throws IOException, XmlPullParserException {
        XmlToJson conv = new XmlToJson(revapi, PlexusConfiguration::getName, PlexusConfiguration::getValue, PlexusConfiguration::getAttribute, x -> Arrays.asList(x.getChildren()));
        XmlPlexusConfiguration xml = new XmlPlexusConfiguration(Xpp3DomBuilder.build((Reader)rdr));
        String[] roots = configFile.getRoots();
        if (roots == null) {
            ctxBld.mergeConfiguration(this.expandVariables(conv.convert((Object)xml)));
        } else {
            block0: for (String r : roots) {
                String[] rootPath;
                XmlPlexusConfiguration root = xml;
                boolean first = true;
                for (String name : rootPath = r.split("/")) {
                    if (first) {
                        first = false;
                        if (name.equals(root.getName())) continue;
                        continue block0;
                    }
                    if ((root = root.getChild(name)) == null) continue block0;
                }
                ctxBld.mergeConfiguration(this.expandVariables(conv.convert((Object)root)));
            }
        }
    }

    private void mergeJsonConfigFile(AnalysisContext.Builder ctxBld, ConfigurationFile configFile, ModelNode config) {
        String[] roots = configFile.getRoots();
        if (roots == null) {
            ctxBld.mergeConfiguration(config);
        } else {
            for (String r : roots) {
                String[] rootPath = r.split("/");
                ModelNode root = config.get(rootPath);
                if (!root.isDefined()) continue;
                ctxBld.mergeConfiguration(root);
            }
        }
    }

    private void convertNewStyleConfigFromXml(AnalysisContext.Builder bld, Revapi revapi) {
        XmlToJson conv = new XmlToJson(revapi, PlexusConfiguration::getName, PlexusConfiguration::getValue, PlexusConfiguration::getAttribute, x -> Arrays.asList(x.getChildren()));
        bld.mergeConfiguration(this.expandVariables(conv.convert((Object)this.analysisConfiguration)));
    }

    private ModelNode readJson(InputStream in) {
        try {
            return ModelNode.fromJSONStream((InputStream)JSONUtil.stripComments((InputStream)in, (Charset)StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            return null;
        }
    }

    private ModelNode expandVariables(ModelNode config) {
        if (!this.expandProperties) {
            return config;
        }
        switch (config.getType()) {
            case LIST: {
                config.asList().forEach(this::expandVariables);
                break;
            }
            case OBJECT: {
                for (String key : config.asObject().keys()) {
                    this.expandVariables(config.get(key));
                }
                break;
            }
            default: {
                AnalysisConfigurationGatherer.expandVariable(config, this.resolver);
            }
        }
        return config;
    }

    private static void expandVariable(ModelNode node, ValueExpressionResolver resolver) {
        ValueExpression val = new ValueExpression(node.asString());
        switch (node.getType()) {
            case STRING: {
                node.set(val.resolveString(resolver));
                break;
            }
            case BOOLEAN: {
                node.set(val.resolveBoolean(resolver));
                break;
            }
            case LONG: {
                node.set(val.resolveLong(resolver));
                break;
            }
            case DOUBLE: {
                node.set(val.resolveBigDecimal(resolver).doubleValue());
                break;
            }
            case INT: {
                node.set(val.resolveInt(resolver));
                break;
            }
            case BIG_DECIMAL: {
                node.set(val.resolveBigDecimal(resolver));
                break;
            }
            case BIG_INTEGER: {
                node.set(val.resolveBigDecimal(resolver).toBigInteger());
            }
        }
    }

    private static final class PropertyExpressionResolver
    extends ValueExpressionResolver {
        private final PropertyValueInterpolator interpolator;

        private PropertyExpressionResolver(PropertyValueInterpolator interpolator) {
            this.interpolator = interpolator;
        }

        protected String resolvePart(String name) {
            return this.interpolator.interpolate(name);
        }
    }
}

