/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import java.util.List;
import java.util.Map;
import org.revapi.Difference;
import org.revapi.Report;
import org.revapi.maven.BuildTimeReporter;

public abstract class AbstractSuggestionsBuilder
implements BuildTimeReporter.SuggestionsBuilder {
    protected abstract void appendDifferenceField(StringBuilder var1, String var2, String var3);

    protected abstract void appendDifferenceFieldSeparator(StringBuilder var1);

    protected abstract void prologue(StringBuilder var1);

    protected abstract void startDifference(StringBuilder var1);

    protected abstract void endDifference(StringBuilder var1);

    protected abstract void startOptionalAttachmentsInComment(StringBuilder var1, String var2);

    protected abstract void endOptionalAttachmentsInComment(StringBuilder var1);

    protected abstract void epilogue(StringBuilder var1);

    @Override
    public String build(List<Report> allProblems, BuildTimeReporter.SuggestionBuilderContext context) {
        StringBuilder sb = new StringBuilder();
        this.prologue(sb);
        for (Report r : allProblems) {
            for (Difference d : r.getDifferences()) {
                if (!context.isReportable(d)) continue;
                this.startDifference(sb);
                this.appendDifferenceField(sb, "code", d.code);
                this.appendDifferenceFieldSeparator(sb);
                if (r.getOldElement() != null) {
                    this.appendDifferenceField(sb, "old", r.getOldElement().getFullHumanReadableString());
                    this.appendDifferenceFieldSeparator(sb);
                }
                if (r.getNewElement() != null) {
                    this.appendDifferenceField(sb, "new", r.getNewElement().getFullHumanReadableString());
                    this.appendDifferenceFieldSeparator(sb);
                }
                boolean hasOptionalAttachments = false;
                for (Map.Entry e : d.attachments.entrySet()) {
                    if (d.isIdentifyingAttachment((String)e.getKey())) {
                        this.appendDifferenceField(sb, (String)e.getKey(), (String)e.getValue());
                        this.appendDifferenceFieldSeparator(sb);
                        continue;
                    }
                    hasOptionalAttachments = true;
                }
                this.appendDifferenceField(sb, "justification", "ADD YOUR EXPLANATION FOR THE NECESSITY OF THIS CHANGE");
                if (context.isAttachmentsReported() && hasOptionalAttachments) {
                    this.startOptionalAttachmentsInComment(sb, "\n  Additionally, the following attachments can be used to further identify the difference:\n\n");
                    for (Map.Entry e : d.attachments.entrySet()) {
                        if (d.isIdentifyingAttachment((String)e.getKey())) continue;
                        this.appendDifferenceField(sb, (String)e.getKey(), (String)e.getValue());
                        this.appendDifferenceFieldSeparator(sb);
                    }
                    this.endOptionalAttachmentsInComment(sb);
                }
                this.endDifference(sb);
            }
        }
        this.epilogue(sb);
        return sb.toString();
    }
}

