/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.revapi.AnalysisContext;
import org.revapi.Archive;
import org.revapi.Difference;
import org.revapi.DifferenceSeverity;
import org.revapi.Element;
import org.revapi.Report;
import org.revapi.Reporter;

public final class BuildTimeReporter
implements Reporter {
    static final String BREAKING_SEVERITY_KEY = "org.revapi.maven.buildTimeBreakingSeverity";
    static final String OUTPUT_NON_IDENTIFYING_ATTACHMENTS = "org.revapi.maven.outputNonIdentifyingAttachments";
    private DifferenceSeverity breakingSeverity;
    private List<Report> allProblems;
    private List<Archive> oldApi;
    private List<Archive> newApi;
    private boolean outputNonIdentifyingAttachments;

    public boolean hasBreakingProblems() {
        return this.allProblems != null && !this.allProblems.isEmpty();
    }

    public String getAllProblemsMessage() {
        StringBuilder errors = new StringBuilder("The following API problems caused the build to fail:\n");
        for (Report r : this.allProblems) {
            Archive archive;
            Element element = r.getNewElement();
            if (element == null) {
                element = r.getOldElement();
                assert (element != null);
                archive = this.shouldOutputArchive(this.oldApi, element.getArchive()) ? element.getArchive() : null;
            } else {
                archive = this.shouldOutputArchive(this.newApi, element.getArchive()) ? element.getArchive() : null;
            }
            for (Difference d : r.getDifferences()) {
                if (!this.isReportable(d)) continue;
                errors.append(d.code).append(": ").append(element.getFullHumanReadableString()).append(": ").append(d.description);
                if (archive != null) {
                    errors.append(" [").append(archive.getName()).append("]");
                }
                errors.append("\n");
            }
        }
        return errors.toString();
    }

    public String getIgnoreSuggestion() {
        if (this.allProblems.isEmpty()) {
            return null;
        }
        StringBuilder ignores = new StringBuilder();
        for (Report r : this.allProblems) {
            for (Difference d : r.getDifferences()) {
                if (!this.isReportable(d)) continue;
                ignores.append("{\n");
                ignores.append("  \"code\": \"").append(BuildTimeReporter.escape(d.code)).append("\",\n");
                if (r.getOldElement() != null) {
                    ignores.append("  \"old\": \"").append(BuildTimeReporter.escape(r.getOldElement())).append("\",\n");
                }
                if (r.getNewElement() != null) {
                    ignores.append("  \"new\": \"").append(BuildTimeReporter.escape(r.getNewElement())).append("\",\n");
                }
                boolean hasOptionalAttachments = false;
                for (Map.Entry e : d.attachments.entrySet()) {
                    if (d.isIdentifyingAttachment((String)e.getKey())) {
                        ignores.append("  \"").append(BuildTimeReporter.escape(e.getKey())).append("\": \"").append(BuildTimeReporter.escape(e.getValue())).append("\",\n");
                        continue;
                    }
                    hasOptionalAttachments = true;
                }
                ignores.append("  \"justification\": <<<<< ADD YOUR EXPLANATION FOR THE NECESSITY OF THIS CHANGE >>>>>\n");
                if (this.outputNonIdentifyingAttachments && hasOptionalAttachments) {
                    ignores.append("  /*\n  Additionally, the following attachments can be used to further identify the difference:\n\n");
                    for (Map.Entry e : d.attachments.entrySet()) {
                        if (d.isIdentifyingAttachment((String)e.getKey())) continue;
                        ignores.append("  \"").append(BuildTimeReporter.escape(e.getKey())).append("\": \"").append(BuildTimeReporter.escape(e.getValue())).append("\",\n");
                    }
                    ignores.append("  */\n");
                }
                ignores.append("},\n");
            }
        }
        return ignores.toString();
    }

    @Nullable
    public String getExtensionId() {
        return "revapi.maven.internal.buildTimeReporter";
    }

    @Nullable
    public Reader getJSONSchema() {
        return null;
    }

    public void initialize(@Nonnull AnalysisContext context) {
        this.allProblems = new ArrayList<Report>();
        this.oldApi = new ArrayList<Archive>();
        for (Archive a : context.getOldApi().getArchives()) {
            this.oldApi.add(a);
        }
        this.newApi = new ArrayList<Archive>();
        for (Archive a : context.getNewApi().getArchives()) {
            this.newApi.add(a);
        }
        this.breakingSeverity = (DifferenceSeverity)context.getData(BREAKING_SEVERITY_KEY);
        Boolean outputNonIdentifyingAttachments = (Boolean)context.getData(OUTPUT_NON_IDENTIFYING_ATTACHMENTS);
        this.outputNonIdentifyingAttachments = outputNonIdentifyingAttachments == null ? true : outputNonIdentifyingAttachments;
    }

    public void report(@Nonnull Report report) {
        Element element = report.getNewElement();
        if (element == null) {
            element = report.getOldElement();
        }
        if (element == null) {
            return;
        }
        for (Difference d : report.getDifferences()) {
            if (!this.isReportable(d)) continue;
            this.allProblems.add(report);
            break;
        }
    }

    private boolean isReportable(Difference d) {
        DifferenceSeverity maxSeverity = DifferenceSeverity.NON_BREAKING;
        for (DifferenceSeverity s : d.classification.values()) {
            if (maxSeverity.compareTo((Enum)s) >= 0) continue;
            maxSeverity = s;
        }
        return maxSeverity.compareTo((Enum)this.breakingSeverity) >= 0;
    }

    private boolean shouldOutputArchive(List<Archive> primaryApi, Archive archive) {
        return !primaryApi.contains(archive) || primaryApi.size() > 1;
    }

    public void close() throws IOException {
    }

    private static String escape(Object obj) {
        if (obj == null) {
            return "null";
        }
        String string = obj.toString();
        int len = string.length();
        StringBuilder sb = new StringBuilder(len);
        block9: for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

