/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import java.io.StringWriter;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.revapi.AnalysisResult;
import org.revapi.maven.AbstractRevapiMojo;
import org.revapi.maven.BuildTimeReporter;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class CheckMojo
extends AbstractRevapiMojo {
    @Parameter(property="revapi.outputIgnoreSuggestions", defaultValue="true")
    private boolean outputIgnoreSuggestions;
    @Parameter(property="revapi.outputNonIdentifyingDifferenceInfo", defaultValue="true")
    private boolean outputNonIdentifyingDifferenceInfo;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        StringWriter wrt = new StringWriter();
        String report = null;
        try (AnalysisResult res = this.analyze(BuildTimeReporter.class, "org.revapi.maven.buildTimeBreakingSeverity", this.failSeverity.asDifferenceSeverity(), "maven-log", this.getLog(), "writer", wrt, "org.revapi.maven.outputNonIdentifyingAttachments", this.outputNonIdentifyingDifferenceInfo);){
            res.throwIfFailed();
            BuildTimeReporter reporter = (BuildTimeReporter)res.getExtensions().getFirstExtension(BuildTimeReporter.class, null);
            if (reporter != null && reporter.hasBreakingProblems()) {
                if (this.failBuildOnProblemsFound) {
                    report = reporter.getAllProblemsMessage();
                    String additionalOutput = wrt.toString();
                    if (!additionalOutput.isEmpty()) {
                        report = report + "\n\nAdditionally, the configured reporters reported:\n\n" + additionalOutput;
                    }
                    Stream.of(report.split("\n")).forEach(l -> this.getLog().info((CharSequence)l));
                    if (this.outputIgnoreSuggestions) {
                        this.getLog().info((CharSequence)"");
                        this.getLog().info((CharSequence)("If you're using the semver-ignore extension, update your module's version to one compatible with the current changes (e.g. mvn package revapi:update-versions). If you want to explicitly ignore this change and provide a justification for it, add the following JSON snippet to your Revapi configuration under \"revapi.ignore\" path:\n\n" + reporter.getIgnoreSuggestion()));
                        report = report + "\nConsult the plugin output above for suggestions on how to ignore the found problems.";
                    }
                } else {
                    this.getLog().info((CharSequence)"API problems found but letting the build pass as configured.");
                }
            } else {
                this.getLog().info((CharSequence)"API checks completed without failures.");
            }
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to execute the API analysis.", e);
        }
        if (report != null) {
            throw new MojoFailureException(report);
        }
    }
}

