/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import com.ximpleware.XMLModifier;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jboss.dmr.ModelNode;
import org.revapi.AnalysisContext;
import org.revapi.AnalysisResult;
import org.revapi.Revapi;
import org.revapi.configuration.Configurable;
import org.revapi.configuration.JSONUtil;
import org.revapi.maven.AbstractRevapiMojo;
import org.revapi.maven.AnalyzerBuilder;
import org.revapi.maven.SchemaDrivenJSONToXmlConverter;
import org.revapi.maven.XmlUtil;
import org.revapi.simple.SimpleReporter;

@Mojo(name="convert-config-to-xml", requiresDirectInvocation=true, defaultPhase=LifecyclePhase.VALIDATE)
public class ConvertToXmlConfigMojo
extends AbstractRevapiMojo {
    @Parameter(property="revapi.convertPomXml", defaultValue="true")
    private boolean convertPomXml;
    @Parameter(property="revapi.convertAnalysisConfigurationFiles", defaultValue="false")
    private boolean convertAnalysisConfigurationFiles;

    public void execute() throws MojoExecutionException, MojoFailureException {
        int indentationSize;
        Map<String, ModelNode> knownExtensionSchemas;
        if (this.skip) {
            return;
        }
        AnalyzerBuilder.Result res = this.buildAnalyzer(this.project, SimpleReporter.class, Collections.emptyMap());
        if (res.skip) {
            return;
        }
        Revapi revapi = res.analyzer.getRevapi();
        AnalysisContext ctx = AnalysisContext.builder((Revapi)revapi).build();
        AnalysisResult.Extensions extensions = revapi.prepareAnalysis(ctx);
        try {
            knownExtensionSchemas = ConvertToXmlConfigMojo.getKnownExtensionSchemas(extensions);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to extract the extension schemas from the configured Revapi extensions.", (Exception)e);
        }
        try (BufferedReader rdr = new BufferedReader(new FileReader(this.project.getFile()));){
            indentationSize = XmlUtil.estimateIndentationSize(rdr);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read pom.xml", (Exception)e);
        }
        if (this.convertPomXml) {
            try {
                ConvertToXmlConfigMojo.updateAllConfigurations(this.project.getFile(), knownExtensionSchemas, indentationSize);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to convert the JSON configuration in pom.xml to XML format.", e);
            }
        }
        if (this.convertAnalysisConfigurationFiles) {
            try {
                this.updateAllConfigurationFiles(this.project, knownExtensionSchemas, indentationSize);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to update the configuration files.", e);
            }
        }
    }

    private void updateAllConfigurationFiles(MavenProject project, Map<String, ModelNode> extensionSchemas, int indentationSize) throws Exception {
        VTDGen gen = new VTDGen();
        gen.enableIgnoredWhiteSpace(true);
        gen.parseFile(project.getFile().getAbsolutePath(), true);
        VTDNav nav = gen.getNav();
        XMLModifier mod = new XMLModifier(nav);
        AutoPilot ap = new AutoPilot(nav);
        ThrowingConsumer<String> update = xpath -> {
            ap.resetXPath();
            ap.selectXPath(xpath);
            while (ap.evalXPath() != -1) {
                int textPos = nav.getText();
                String configFile = nav.toString(textPos);
                File newFile = this.updateConfigurationFile(new File(configFile), extensionSchemas, indentationSize);
                if (newFile == null) continue;
                mod.updateToken(textPos, newFile.getPath());
            }
        };
        update.accept("//plugin[groupId = 'org.revapi' and artifactId = 'revapi-maven-plugin']/configuration/analysisConfigurationFiles/*[not(self::configurationFile)]");
        update.accept("//plugin[groupId = 'org.revapi' and artifactId = 'revapi-maven-plugin']/configuration/analysisConfigurationFiles/configurationFile[not(roots)]/path");
        update.accept("//plugin[groupId = 'org.revapi' and artifactId = 'revapi-maven-plugin']/executions/execution/configuration/analysisConfigurationFiles/*[not(self::configurationFile)]");
        update.accept("//plugin[groupId = 'org.revapi' and artifactId = 'revapi-maven-plugin']/executions/execution/configuration/analysisConfigurationFiles/configurationFile[not(roots)]/path");
        try (FileOutputStream out = new FileOutputStream(project.getFile());){
            mod.output((OutputStream)out);
        }
    }

    private File updateConfigurationFile(File configFile, Map<String, ModelNode> extensionSchemas, int indentationSize) throws Exception {
        ModelNode jsonConfig;
        try (FileInputStream is = new FileInputStream(configFile);){
            jsonConfig = ModelNode.fromJSONStream((InputStream)is);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        PlexusConfiguration xml = SchemaDrivenJSONToXmlConverter.convertToXml(extensionSchemas, jsonConfig);
        File newFile = configFile;
        String fileExtension = ConvertToXmlConfigMojo.getFileExtension(newFile);
        if (fileExtension != null && fileExtension.equalsIgnoreCase("json")) {
            String newFilePath = newFile.getPath().substring(0, newFile.getPath().length() - fileExtension.length()) + "xml";
            newFile = new File(newFilePath);
        }
        try (FileWriter wrt = new FileWriter(newFile);){
            StringWriter pretty = new StringWriter();
            XmlUtil.toIndentedString(xml, indentationSize, 0, pretty);
            wrt.write(pretty.toString());
        }
        return newFile;
    }

    private static PlexusConfiguration convertToXml(Map<String, ModelNode> extensionSchemas, String xmlOrJson) throws IOException, XmlPullParserException {
        ModelNode jsonConfig;
        try {
            jsonConfig = ModelNode.fromJSONString((String)JSONUtil.stripComments((String)xmlOrJson));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return SchemaDrivenJSONToXmlConverter.convertToXml(extensionSchemas, jsonConfig);
    }

    private static void updateAllConfigurations(File pomXml, Map<String, ModelNode> extensionSchemas, int indentationSize) throws Exception {
        VTDGen gen = new VTDGen();
        gen.enableIgnoredWhiteSpace(true);
        gen.parseFile(pomXml.getAbsolutePath(), true);
        VTDNav nav = gen.getNav();
        XMLModifier mod = new XMLModifier(nav);
        Callable<Void> update = () -> {
            int textPos = nav.getText();
            String jsonConfig = nav.toRawString(textPos);
            PlexusConfiguration xml = ConvertToXmlConfigMojo.convertToXml(extensionSchemas, jsonConfig);
            if (xml == null) {
                return null;
            }
            StringWriter pretty = new StringWriter();
            XmlUtil.toIndentedString(xml, indentationSize, nav.getTokenDepth(textPos), pretty);
            String prettyXml = pretty.toString().substring(indentationSize * nav.getTokenDepth(textPos));
            mod.insertAfterElement(prettyXml);
            mod.remove();
            return null;
        };
        AutoPilot ap = new AutoPilot(nav);
        ap.selectXPath("//plugin[groupId = 'org.revapi' and artifactId = 'revapi-maven-plugin']/configuration/analysisConfiguration");
        while (ap.evalXPath() != -1) {
            update.call();
        }
        ap.resetXPath();
        ap.selectXPath("//plugin[groupId = 'org.revapi' and artifactId = 'revapi-maven-plugin']/executions/execution/configuration/analysisConfiguration");
        while (ap.evalXPath() != -1) {
            update.call();
        }
        try (FileOutputStream out = new FileOutputStream(pomXml);){
            mod.output((OutputStream)out);
        }
    }

    private static String readFull(Reader rdr) throws IOException {
        int cnt;
        char[] buf = new char[512];
        StringBuilder bld = new StringBuilder();
        while ((cnt = rdr.read(buf)) != -1) {
            bld.append(buf, 0, cnt);
        }
        return bld.toString();
    }

    private static Map<String, ModelNode> getKnownExtensionSchemas(AnalysisResult.Extensions extensions) throws IOException {
        List exts = extensions.stream().map(e -> (Configurable)e.getKey()).collect(Collectors.toList());
        HashMap<String, ModelNode> extensionSchemas = new HashMap<String, ModelNode>();
        for (Configurable ext : exts) {
            String extensionId = ext.getExtensionId();
            if (extensionId == null || extensionSchemas.containsKey(extensionId)) continue;
            Reader schemaRdr = ext.getJSONSchema();
            Throwable throwable = null;
            try {
                if (schemaRdr == null) continue;
                ModelNode schema = ModelNode.fromJSONString((String)ConvertToXmlConfigMojo.readFull(schemaRdr));
                extensionSchemas.put(extensionId, schema);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (schemaRdr == null) continue;
                ConvertToXmlConfigMojo.$closeResource(throwable, schemaRdr);
            }
        }
        return extensionSchemas;
    }

    private static String getFileExtension(File f) {
        int p;
        String extension = null;
        String path = f.getPath();
        int i = path.lastIndexOf(46);
        if (i > (p = path.lastIndexOf(File.separator))) {
            extension = path.substring(i + 1);
        }
        return extension;
    }

    @FunctionalInterface
    private static interface ThrowingConsumer<T> {
        public void accept(T var1) throws Exception;
    }
}

