/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.revapi.AnalysisResult;
import org.revapi.maven.AbstractRevapiMojo;
import org.revapi.maven.BuildTimeReporter;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class CheckMojo
extends AbstractRevapiMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        try (AnalysisResult res = this.analyze(BuildTimeReporter.class, "org.revapi.maven.buildTimeBreakingSeverity", this.failSeverity.asDifferenceSeverity());){
            res.throwIfFailed();
            BuildTimeReporter reporter = (BuildTimeReporter)res.getExtensions().getFirstExtension(BuildTimeReporter.class, null);
            if (reporter != null && reporter.hasBreakingProblems()) {
                if (this.failBuildOnProblemsFound) {
                    throw new MojoFailureException(reporter.getAllProblemsMessage());
                }
                this.getLog().info((CharSequence)"API problems found but letting the build pass as configured.");
            } else {
                this.getLog().info((CharSequence)"API checks completed without failures.");
            }
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to execute the API analysis.", e);
        }
    }
}

