/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.model;

import javax.annotation.Nonnull;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.revapi.Archive;
import org.revapi.java.compilation.ProbingEnvironment;
import org.revapi.java.model.JavaElementBase;
import org.revapi.java.model.JavaElementFactory;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaMethodElement;
import org.revapi.java.spi.JavaMethodParameterElement;
import org.revapi.java.spi.Util;

public final class MethodParameterElement
extends JavaElementBase<VariableElement, TypeMirror>
implements JavaMethodParameterElement {
    private final int index;

    public MethodParameterElement(ProbingEnvironment env, Archive archive, VariableElement element, TypeMirror type) {
        super(env, archive, element, type);
        if (!(element.getEnclosingElement() instanceof ExecutableElement)) {
            throw new IllegalArgumentException("MethodParameterElement cannot be constructed using a VariableElement not representing a method parameter.");
        }
        this.index = ((ExecutableElement)element.getEnclosingElement()).getParameters().indexOf(element);
    }

    @Nonnull
    public JavaMethodElement getParent() {
        return (JavaMethodElement)super.getParent();
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    @Nonnull
    protected String getHumanReadableElementType() {
        return "parameter";
    }

    @Override
    public int compareTo(@Nonnull JavaElement o) {
        if (!o.getClass().equals(MethodParameterElement.class)) {
            return JavaElementFactory.compareByType(this, o);
        }
        MethodParameterElement other = (MethodParameterElement)o;
        return this.index - other.index;
    }

    @Override
    public boolean equals(Object obj) {
        String otherSig;
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MethodParameterElement)) {
            return false;
        }
        MethodParameterElement other = (MethodParameterElement)((Object)obj);
        ExecutableElement myMethodElement = (ExecutableElement)((VariableElement)this.getDeclaringElement()).getEnclosingElement();
        ExecutableElement otherMethodElement = (ExecutableElement)((VariableElement)other.getDeclaringElement()).getEnclosingElement();
        if (myMethodElement.getParameters().size() != otherMethodElement.getParameters().size()) {
            return false;
        }
        String mySig = this.getComparableSignature();
        return mySig.equals(otherSig = other.getComparableSignature()) && this.index == other.index;
    }

    @Override
    protected String createComparableSignature() {
        String myType = Util.toUniqueString((TypeMirror)((VariableElement)this.getDeclaringElement()).getEnclosingElement().getEnclosingElement().asType());
        String myMethod = ((VariableElement)this.getDeclaringElement()).getEnclosingElement().getSimpleName().toString();
        return myType + "::" + myMethod;
    }

    @Override
    public MethodParameterElement clone() {
        return (MethodParameterElement)super.clone();
    }
}

