/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.transforms.methods;

import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import org.revapi.AnalysisContext;
import org.revapi.Difference;
import org.revapi.DifferenceTransform;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaModelElement;

public class AnnotationTypeAttributeRemoved
implements DifferenceTransform<JavaModelElement> {
    private Locale locale;
    private final Pattern[] codes = new Pattern[]{Pattern.compile("^" + Pattern.quote(Code.METHOD_REMOVED.code()) + "$")};

    @Nonnull
    public Pattern[] getDifferenceCodePatterns() {
        return this.codes;
    }

    @Nullable
    public String getExtensionId() {
        return "revapi.java.annotationTypeAttributeRemoved";
    }

    @Nullable
    public Reader getJSONSchema() {
        return null;
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        this.locale = analysisContext.getLocale();
    }

    @Nullable
    public Difference transform(@Nullable JavaModelElement oldElement, @Nullable JavaModelElement newElement, @Nonnull Difference difference) {
        if (oldElement == null) {
            throw new IllegalStateException("Annotation type attribute detection called with one of the elements null. That should never be the case.");
        }
        ExecutableElement method = (ExecutableElement)oldElement.getDeclaringElement();
        if (method.getEnclosingElement().getKind() == ElementKind.ANNOTATION_TYPE) {
            return Code.METHOD_ATTRIBUTE_REMOVED_FROM_ANNOTATION_TYPE.createDifference(this.locale, new LinkedHashMap(difference.attachments));
        }
        return difference;
    }

    public void close() {
    }
}

