/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.basic;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.revapi.AnalysisContext;
import org.revapi.Archive;
import org.revapi.CompatibilityType;
import org.revapi.Criticality;
import org.revapi.Difference;
import org.revapi.DifferenceSeverity;
import org.revapi.Element;
import org.revapi.Reference;
import org.revapi.TransformationResult;
import org.revapi.base.BaseDifferenceTransform;
import org.revapi.basic.SemverVersion;

public class VersionsTransform<E extends Element<E>>
extends BaseDifferenceTransform<E> {
    private static final Pattern[] ALL_CODES = new Pattern[]{Pattern.compile(".*")};
    private static final Pattern[] NO_CODES = new Pattern[0];
    private boolean enabled;
    private List<String> passThroughDifferences;
    private VersionIncreaseConfig allowedInMajor;
    private VersionIncreaseConfig allowedInMinor;
    private VersionIncreaseConfig allowedInPatch;
    private VersionIncreaseConfig allowedInSuffix;
    private DifferenceModification allowedModify;
    private DifferenceModification disallowedModify;
    private Map<String, VersionRecord> archiveHints;

    private static DifferenceSeverity getMaxSeverity(Difference diff) {
        return diff.classification.values().stream().max(Comparator.comparingInt(Enum::ordinal)).orElse(DifferenceSeverity.EQUIVALENT);
    }

    public Pattern[] getDifferenceCodePatterns() {
        return this.enabled ? ALL_CODES : NO_CODES;
    }

    @Nonnull
    public List<Predicate<String>> getDifferenceCodePredicates() {
        return this.enabled ? Collections.singletonList(__ -> true) : Collections.emptyList();
    }

    public TransformationResult tryTransform(@Nullable E oldElement, @Nullable E newElement, Difference difference) {
        boolean allowed;
        Archive.Versioned decidingArchive;
        if (!this.enabled) {
            return TransformationResult.keep();
        }
        if (this.passThroughDifferences.contains(difference.code)) {
            return TransformationResult.keep();
        }
        Archive.Versioned oldArchive = (Archive.Versioned)(oldElement == null ? null : oldElement.getArchive());
        Archive.Versioned newArchive = (Archive.Versioned)(newElement == null ? null : newElement.getArchive());
        DifferenceSeverity maxSeverity = VersionsTransform.getMaxSeverity(difference);
        Archive.Versioned versioned = decidingArchive = newArchive == null ? oldArchive : newArchive;
        if (decidingArchive == null) {
            throw new IllegalStateException("At least one of the archives must not be null when comparing elements " + oldElement + " and " + newElement);
        }
        VersionRecord versionRecord = this.archiveHints.get(decidingArchive.getBaseName());
        if (versionRecord == null) {
            HashSet<Archive.Versioned> primaryReferencingArchives = new HashSet<Archive.Versioned>();
            if (newElement == null) {
                this.getAllReferencingAPIElements(oldElement, primaryReferencingArchives, new HashSet());
            } else {
                this.getAllReferencingAPIElements(newElement, primaryReferencingArchives, new HashSet());
            }
            versionRecord = primaryReferencingArchives.stream().map(a -> this.archiveHints.get(a.getBaseName())).reduce(null, (a, b) -> {
                if (a == null) {
                    return b;
                }
                if (b == null) {
                    return a;
                }
                return a.versionChange.compareTo(b.versionChange) > 0 ? b : a;
            });
            if (versionRecord == null) {
                return TransformationResult.replaceWith((Difference)VersionsTransform.markUnhandled(difference));
            }
        }
        switch (versionRecord.versionChange.ordinal()) {
            case 1: {
                allowed = true;
                break;
            }
            case 0: {
                if (newElement == null) {
                    allowed = true;
                    break;
                }
                return TransformationResult.replaceWith((Difference)VersionsTransform.markUnhandled(difference));
            }
            case 2: {
                allowed = this.allowedInSuffix.allows(versionRecord, difference, maxSeverity);
                break;
            }
            case 3: {
                allowed = this.allowedInPatch.allows(versionRecord, difference, maxSeverity);
                break;
            }
            case 4: {
                allowed = this.allowedInMinor.allows(versionRecord, difference, maxSeverity);
                break;
            }
            case 5: {
                allowed = this.allowedInMajor.allows(versionRecord, difference, maxSeverity);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled version change kind: " + (Object)((Object)versionRecord.versionChange));
            }
        }
        if (allowed) {
            return this.allowedModify.modify(difference);
        }
        return this.disallowedModify.modify(difference);
    }

    public String getExtensionId() {
        return "revapi.versions";
    }

    @Nullable
    public Reader getJSONSchema() {
        return new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/versions-schema.json"), StandardCharsets.UTF_8);
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        JsonNode config = analysisContext.getConfigurationNode();
        this.enabled = config.path("enabled").asBoolean(false);
        if (!this.enabled) {
            return;
        }
        Map oldArchives = StreamSupport.stream(analysisContext.getOldApi().getArchives().spliterator(), false).map(a -> (Archive.Versioned)a).collect(Collectors.toMap(Archive.Versioned::getBaseName, Function.identity()));
        Map newArchives = StreamSupport.stream(analysisContext.getNewApi().getArchives().spliterator(), false).map(a -> (Archive.Versioned)a).collect(Collectors.toMap(Archive.Versioned::getBaseName, Function.identity()));
        if (oldArchives.isEmpty() || newArchives.isEmpty()) {
            this.enabled = false;
            return;
        }
        this.passThroughDifferences = StreamSupport.stream(config.path("passThroughDifferences").spliterator(), false).map(JsonNode::asText).collect(Collectors.toList());
        this.allowedInMajor = VersionIncreaseConfig.parse(analysisContext, config.path("versionIncreaseAllows").path("major"));
        if (this.allowedInMajor == null) {
            this.allowedInMajor = VersionIncreaseConfig.DEFAULT_MAJOR;
        }
        this.allowedInMinor = VersionIncreaseConfig.parse(analysisContext, config.path("versionIncreaseAllows").path("minor"));
        if (this.allowedInMinor == null) {
            this.allowedInMinor = VersionIncreaseConfig.DEFAULT_MINOR;
        }
        this.allowedInPatch = VersionIncreaseConfig.parse(analysisContext, config.path("versionIncreaseAllows").path("patch"));
        if (this.allowedInPatch == null) {
            this.allowedInPatch = VersionIncreaseConfig.DEFAULT_PATCH;
        }
        this.allowedInSuffix = VersionIncreaseConfig.parse(analysisContext, config.path("versionIncreaseAllows").path("suffix"));
        if (this.allowedInSuffix == null) {
            this.allowedInSuffix = VersionIncreaseConfig.DEFAULT_SUFFIX;
        }
        this.allowedModify = DifferenceModification.parseModify(analysisContext, config.path("onAllowed"));
        if (this.allowedModify == null) {
            this.allowedModify = new DifferenceModification(Collections.emptyMap(), null, null, null, Collections.singletonMap("breaksVersioningRules", "false"));
        }
        this.disallowedModify = DifferenceModification.parseModify(analysisContext, config.path("onDisallowed"));
        if (this.disallowedModify == null) {
            Criticality breakingCriticality = analysisContext.getDefaultCriticality(DifferenceSeverity.BREAKING);
            this.disallowedModify = new DifferenceModification(Collections.emptyMap(), breakingCriticality, null, null, Collections.singletonMap("breaksVersioningRules", "true"));
        }
        boolean semantic0 = config.path("semantic0").asBoolean(true);
        boolean strictSemver = config.path("strictSemver").asBoolean(true);
        this.archiveHints = new HashMap<String, VersionRecord>();
        for (Map.Entry e : oldArchives.entrySet()) {
            boolean suffixChange;
            Archive.Versioned oldArchive = (Archive.Versioned)e.getValue();
            Archive.Versioned newArchive = (Archive.Versioned)newArchives.remove(e.getKey());
            SemverVersion oldVersion = SemverVersion.parse(oldArchive.getVersion(), strictSemver);
            if (newArchive == null) {
                this.archiveHints.put(oldArchive.getBaseName(), new VersionRecord(oldArchive, null, oldVersion, null, VersionChange.REMOVED));
                continue;
            }
            SemverVersion newVersion = SemverVersion.parse(newArchive.getVersion(), strictSemver);
            boolean majorIncrease = oldVersion.major < newVersion.major;
            boolean minorIncrease = oldVersion.major == newVersion.major && oldVersion.minor < newVersion.minor;
            boolean patchIncrease = oldVersion.major == newVersion.major && oldVersion.minor == newVersion.minor && oldVersion.patch < newVersion.patch;
            boolean bl = suffixChange = oldVersion.major == newVersion.major && oldVersion.minor == newVersion.minor && oldVersion.patch == newVersion.patch && !Objects.equals(oldVersion.suffix, newVersion.suffix);
            VersionChange versionChange = semantic0 && oldVersion.major == 0 && !majorIncrease ? (minorIncrease ? VersionChange.MAJOR : (patchIncrease ? VersionChange.MAJOR : (suffixChange ? VersionChange.MAJOR : VersionChange.NEW))) : (majorIncrease ? VersionChange.MAJOR : (minorIncrease ? VersionChange.MINOR : (patchIncrease ? VersionChange.PATCH : (suffixChange ? VersionChange.SUFFIX : VersionChange.NEW))));
            this.archiveHints.put(newArchive.getBaseName(), new VersionRecord(oldArchive, newArchive, oldVersion, newVersion, versionChange));
        }
        for (Map.Entry e : newArchives.entrySet()) {
            SemverVersion newVersion = SemverVersion.parse(((Archive.Versioned)e.getValue()).getVersion(), strictSemver);
            this.archiveHints.put(e.getKey(), new VersionRecord(null, (Archive.Versioned)e.getValue(), null, newVersion, VersionChange.NEW));
        }
    }

    private static Difference markUnhandled(Difference orig) {
        return ((Difference.Builder)Difference.copy((Difference)orig).addAttachment("breaksVersioningRules", "unknown")).build();
    }

    private void getAllReferencingAPIElements(@Nullable E element, Set<Archive.Versioned> results, Set<E> processed) {
        Element parent;
        if (element == null || processed.contains(element)) {
            return;
        }
        processed.add(element);
        if (element.getApi().getArchiveRole(element.getArchive()) == Archive.Role.PRIMARY) {
            results.add((Archive.Versioned)element.getArchive());
        }
        if ((parent = element.getParent()) != null) {
            this.getAllReferencingAPIElements(parent, results, processed);
        }
        for (Reference reference : element.getReferencingElements()) {
            Element el = reference.getElement();
            this.getAllReferencingAPIElements(el, results, processed);
        }
    }

    private static final class VersionRecord {
        @Nullable
        final Archive.Versioned oldArchive;
        @Nullable
        final Archive.Versioned newArchive;
        @Nullable
        final SemverVersion oldVersion;
        @Nullable
        final SemverVersion newVersion;
        final VersionChange versionChange;

        VersionRecord(@Nullable Archive.Versioned oldArchive, @Nullable Archive.Versioned newArchive, @Nullable SemverVersion oldVersion, @Nullable SemverVersion newVersion, VersionChange versionChange) {
            this.oldArchive = oldArchive;
            this.newArchive = newArchive;
            this.oldVersion = oldVersion;
            this.newVersion = newVersion;
            this.versionChange = versionChange;
        }
    }

    private static enum VersionChange {
        REMOVED,
        NEW,
        SUFFIX,
        PATCH,
        MINOR,
        MAJOR;

    }

    private static class VersionIncreaseConfig {
        static final VersionIncreaseConfig DEFAULT_MAJOR = new VersionIncreaseConfig(Collections.singletonList(new IncreaseAllows(false, SeverityCheck.BREAKING, null, null, null, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList(), null, null)));
        static final VersionIncreaseConfig DEFAULT_MINOR = new VersionIncreaseConfig(Collections.singletonList(new IncreaseAllows(false, SeverityCheck.NON_BREAKING, null, null, null, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList(), null, null)));
        static final VersionIncreaseConfig DEFAULT_PATCH = new VersionIncreaseConfig(Collections.singletonList(new IncreaseAllows(false, SeverityCheck.EQUIVALENT, null, null, null, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList(), null, null)));
        static final VersionIncreaseConfig DEFAULT_SUFFIX = new VersionIncreaseConfig(Collections.singletonList(new IncreaseAllows(false, SeverityCheck.EQUIVALENT, null, null, null, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList(), null, null)));
        final List<IncreaseAllows> allows;

        @Nullable
        static VersionIncreaseConfig parse(AnalysisContext ctx, JsonNode node) {
            if (node.isMissingNode()) {
                return null;
            }
            ArrayList<IncreaseAllows> parsedAllows = new ArrayList<IncreaseAllows>();
            if (node.isObject()) {
                parsedAllows.add(VersionIncreaseConfig.parseAllows(ctx, node));
            } else if (node.isArray()) {
                for (JsonNode allows : node) {
                    IncreaseAllows a = VersionIncreaseConfig.parseAllows(ctx, allows);
                    if (a == null) continue;
                    parsedAllows.add(a);
                }
            } else {
                throw new IllegalArgumentException("Expecting an object or array when specifying the allowed changes in a version increase.");
            }
            return new VersionIncreaseConfig(parsedAllows);
        }

        @Nullable
        private static IncreaseAllows parseAllows(AnalysisContext ctx, JsonNode node) {
            if (!node.isObject()) {
                return null;
            }
            boolean regex = node.path("regex").asBoolean(false);
            String severity = node.path("severity").asText(null);
            String criticality = node.path("criticality").asText(null);
            String code = node.path("code").asText(null);
            String justification = node.path("justification").asText(null);
            HashMap<String, String> attachments = new HashMap<String, String>();
            Iterator it = node.path("attachments").fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                attachments.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asText());
            }
            EnumMap<CompatibilityType, DifferenceSeverity> classification = new EnumMap<CompatibilityType, DifferenceSeverity>(CompatibilityType.class);
            it = node.path("classification").fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                classification.put(CompatibilityType.valueOf((String)((String)entry.getKey())), DifferenceSeverity.valueOf((String)((JsonNode)entry.getValue()).asText()));
            }
            String oldSuffix = node.path("old").asText(null);
            String newSuffix = node.path("new").asText(null);
            List inArchives = StreamSupport.stream(node.path("inArchives").spliterator(), false).map(JsonNode::asText).collect(Collectors.toList());
            return new IncreaseAllows(regex, severity == null ? null : SeverityCheck.valueOf(severity), criticality == null ? null : ctx.getCriticalityByName(criticality), code, justification, attachments, classification, inArchives, oldSuffix, newSuffix);
        }

        VersionIncreaseConfig(List<IncreaseAllows> allows) {
            this.allows = allows;
        }

        boolean allows(VersionRecord versionRecord, Difference difference, DifferenceSeverity maxSeverity) {
            return this.allows.stream().reduce(false, (a, b) -> a != false || b.allows(versionRecord, difference, maxSeverity), Boolean::logicalOr);
        }
    }

    private static class DifferenceModification {
        final Map<CompatibilityType, DifferenceSeverity> classification;
        @Nullable
        final Criticality criticality;
        @Nullable
        final TextModification justification;
        @Nullable
        final TextModification description;
        final Map<String, String> attachments;
        final boolean remove;

        @Nullable
        private static DifferenceModification parseModify(AnalysisContext ctx, JsonNode node) {
            if (node.isMissingNode()) {
                return null;
            }
            if (node.path("remove").asBoolean(false)) {
                return new DifferenceModification();
            }
            JsonNode classificationNode = node.path("classification");
            EnumMap<CompatibilityType, DifferenceSeverity> classification = new EnumMap<CompatibilityType, DifferenceSeverity>(CompatibilityType.class);
            if (classificationNode.has("SOURCE")) {
                classification.put(CompatibilityType.SOURCE, DifferenceSeverity.valueOf((String)classificationNode.get("SOURCE").asText()));
            }
            if (classificationNode.has("BINARY")) {
                classification.put(CompatibilityType.BINARY, DifferenceSeverity.valueOf((String)classificationNode.get("BINARY").asText()));
            }
            if (classificationNode.has("SEMANTIC")) {
                classification.put(CompatibilityType.SEMANTIC, DifferenceSeverity.valueOf((String)classificationNode.get("SEMANTIC").asText()));
            }
            if (classificationNode.has("OTHER")) {
                classification.put(CompatibilityType.OTHER, DifferenceSeverity.valueOf((String)classificationNode.get("OTHER").asText()));
            }
            Criticality criticality = !node.path("criticality").isMissingNode() ? ctx.getCriticalityByName(node.path("criticality").asText()) : null;
            TextModification justification = DifferenceModification.parseTextModification(node.path("justification"));
            TextModification description = DifferenceModification.parseTextModification(node.path("description"));
            JsonNode attachmentsNode = node.path("attachments");
            HashMap<String, String> attachments = new HashMap<String, String>();
            if (!attachmentsNode.isMissingNode()) {
                Iterator it = attachmentsNode.fields();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    attachments.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asText());
                }
            }
            return new DifferenceModification(classification, criticality, justification, description, attachments);
        }

        @Nullable
        private static TextModification parseTextModification(JsonNode modificationNode) {
            if (modificationNode.isTextual()) {
                return new TextModification(modificationNode.asText(), null, null);
            }
            if (modificationNode.isObject()) {
                String prepend = modificationNode.path("prepend").asText();
                String append = modificationNode.path("append").asText();
                return new TextModification(null, prepend, append);
            }
            return null;
        }

        private DifferenceModification() {
            this.remove = true;
            this.classification = Collections.emptyMap();
            this.criticality = null;
            this.justification = null;
            this.description = null;
            this.attachments = null;
        }

        private DifferenceModification(Map<CompatibilityType, DifferenceSeverity> classification, @Nullable Criticality criticality, @Nullable TextModification justification, @Nullable TextModification description, Map<String, String> attachments) {
            this.classification = classification;
            this.criticality = criticality;
            this.justification = justification;
            this.description = description;
            this.attachments = attachments;
            this.remove = false;
        }

        TransformationResult modify(Difference difference) {
            if (this.remove) {
                return TransformationResult.discard();
            }
            Difference.Builder bld = Difference.copy((Difference)difference);
            boolean changed = false;
            if (!this.classification.isEmpty()) {
                changed = true;
                bld.addClassifications(this.classification);
            }
            if (this.criticality != null) {
                changed = true;
                bld.withCriticality(this.criticality);
            }
            if (this.justification != null) {
                changed = true;
                bld.withJustification(this.justification.apply(difference.justification));
            }
            if (this.description != null) {
                changed = true;
                bld.withDescription(this.description.apply(difference.description));
            }
            if (!this.attachments.isEmpty()) {
                changed = true;
                bld.addAttachments(this.attachments);
            }
            if (changed) {
                Difference newDiff = bld.build();
                if (newDiff.equals((Object)difference)) {
                    return TransformationResult.keep();
                }
                return TransformationResult.replaceWith((Difference)bld.build());
            }
            return TransformationResult.keep();
        }
    }

    private static class TextModification {
        @Nullable
        final String value;
        @Nullable
        final String prepend;
        @Nullable
        final String append;

        private TextModification(@Nullable String value, @Nullable String prepend, @Nullable String append) {
            this.value = value;
            this.prepend = prepend;
            this.append = append;
        }

        @Nullable
        String apply(@Nullable String value) {
            if (this.value != null) {
                value = this.value;
            }
            if (this.prepend != null) {
                if (value == null) {
                    value = this.prepend;
                } else if (!value.startsWith(this.prepend)) {
                    value = this.prepend + value;
                }
            }
            if (this.append != null) {
                if (value == null) {
                    value = this.append;
                } else if (!value.endsWith(this.append)) {
                    value = value + this.append;
                }
            }
            return value;
        }
    }

    private static enum SeverityCheck {
        NONE,
        EQUIVALENT,
        NON_BREAKING,
        POTENTIALLY_BREAKING,
        BREAKING;


        boolean allows(DifferenceSeverity severity) {
            return this.ordinal() >= severity.ordinal() + 1;
        }
    }

    private static class IncreaseAllows {
        @Nullable
        final SeverityCheck severity;
        @Nullable
        final Criticality criticality;
        @Nullable
        final Pattern code;
        @Nullable
        final Pattern justification;
        final Map<String, Pattern> attachments;
        final Map<CompatibilityType, DifferenceSeverity> classification;
        final List<Pattern> inArchives;
        @Nullable
        final Pattern oldSuffix;
        @Nullable
        final Pattern newSuffix;

        private IncreaseAllows(boolean regex, @Nullable SeverityCheck severity, @Nullable Criticality criticality, @Nullable String code, @Nullable String justification, Map<String, String> attachments, Map<CompatibilityType, DifferenceSeverity> classification, List<String> inArchives, @Nullable String oldSuffix, @Nullable String newSuffix) {
            this.severity = severity;
            this.criticality = criticality;
            Pattern pattern = code == null ? null : (this.code = Pattern.compile(regex ? code : Pattern.quote(code)));
            this.justification = justification == null ? null : Pattern.compile(regex ? justification : Pattern.quote(justification));
            this.attachments = attachments.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Pattern.compile(regex ? (String)e.getValue() : Pattern.quote((String)e.getValue()))));
            this.classification = classification;
            this.inArchives = inArchives.stream().map(a -> Pattern.compile(regex ? a : Pattern.quote(a))).collect(Collectors.toList());
            Pattern pattern2 = oldSuffix == null ? null : (this.oldSuffix = Pattern.compile(regex ? oldSuffix : Pattern.quote(oldSuffix)));
            this.newSuffix = newSuffix == null ? null : Pattern.compile(regex ? newSuffix : Pattern.quote(newSuffix));
        }

        boolean allows(VersionRecord versionRecord, Difference difference, DifferenceSeverity maxSeverity) {
            String suffix;
            if (versionRecord.oldArchive == null && versionRecord.newArchive == null) {
                throw new IllegalStateException("At least one of the archives must be non-null.");
            }
            if (!this.inArchives.isEmpty() && this.inArchives.stream().noneMatch(p -> p.matcher(versionRecord.newArchive == null ? versionRecord.oldArchive.getBaseName() : versionRecord.newArchive.getBaseName()).matches())) {
                return false;
            }
            if (this.oldSuffix != null) {
                if (versionRecord.oldVersion == null) {
                    return false;
                }
                suffix = versionRecord.oldVersion.suffix;
                if (!this.oldSuffix.matcher(suffix == null ? "" : suffix).matches()) {
                    return false;
                }
            }
            if (this.newSuffix != null) {
                if (versionRecord.newVersion == null) {
                    return false;
                }
                suffix = versionRecord.newVersion.suffix;
                if (!this.newSuffix.matcher(suffix == null ? "" : suffix).matches()) {
                    return false;
                }
            }
            if (this.severity != null && !this.severity.allows(maxSeverity)) {
                return false;
            }
            if (this.criticality != null && difference.criticality != null && this.criticality.getLevel() < difference.criticality.getLevel()) {
                return false;
            }
            if (this.code != null && !this.code.matcher(difference.code).matches()) {
                return false;
            }
            if (this.justification != null && !this.justification.matcher(difference.justification == null ? "" : difference.justification).matches()) {
                return false;
            }
            if (this.attachments != null) {
                for (Map.Entry<String, Pattern> entry : this.attachments.entrySet()) {
                    String value;
                    String key = entry.getKey();
                    Pattern pattern = entry.getValue();
                    if (pattern.matcher((value = (String)difference.attachments.get(key)) == null ? "" : value).matches()) continue;
                    return false;
                }
            }
            if (this.classification != null) {
                for (Map.Entry<String, Pattern> entry : this.classification.entrySet()) {
                    DifferenceSeverity expected = (DifferenceSeverity)entry.getValue();
                    DifferenceSeverity actual = (DifferenceSeverity)difference.classification.get(entry.getKey());
                    if (actual == null || expected.compareTo((Enum)actual) >= 0) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

