/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.basic;

import java.io.Reader;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.revapi.AnalysisContext;
import org.revapi.ArchiveAnalyzer;
import org.revapi.Element;
import org.revapi.ElementMatcher;
import org.revapi.FilterStartResult;
import org.revapi.Ternary;
import org.revapi.TreeFilter;
import org.revapi.base.IndependentTreeFilter;

public final class RegexElementMatcher
implements ElementMatcher {
    public Optional<ElementMatcher.CompiledRecipe> compile(final String recipe) {
        try {
            return Optional.of(new ElementMatcher.CompiledRecipe(){
                final /* synthetic */ RegexElementMatcher this$0;
                {
                    this.this$0 = this$0;
                }

                public <E extends Element<E>> TreeFilter<E> filterFor(ArchiveAnalyzer<E> archiveAnalyzer) {
                    return new PatternMatch(Pattern.compile(recipe));
                }
            });
        }
        catch (PatternSyntaxException __) {
            return Optional.empty();
        }
    }

    public void close() throws Exception {
    }

    public String getMatcherId() {
        return "regex";
    }

    public String getExtensionId() {
        return "revapi.matcher.regex";
    }

    @Nullable
    public Reader getJSONSchema() {
        return null;
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
    }

    private static final class PatternMatch<E extends Element<E>>
    extends IndependentTreeFilter<E> {
        final Pattern match;

        private PatternMatch(Pattern match) {
            this.match = match;
        }

        protected FilterStartResult doStart(E element) {
            Ternary m = Ternary.fromBoolean((boolean)this.match.matcher(element.getFullHumanReadableString()).matches());
            return FilterStartResult.direct((Ternary)m, (Ternary)m);
        }
    }
}

