/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.basic;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.revapi.AnalysisContext;
import org.revapi.ApiAnalyzer;
import org.revapi.ArchiveAnalyzer;
import org.revapi.Difference;
import org.revapi.DifferenceTransform;
import org.revapi.Element;
import org.revapi.TransformationResult;
import org.revapi.basic.DifferenceMatchRecipe;
import org.revapi.basic.MatchingProgress;

public abstract class AbstractDifferenceReferringTransform<E extends Element<E>>
implements DifferenceTransform<E> {
    private final String extensionId;
    private Collection<DifferenceMatchRecipe> configuredRecipes;
    private Collection<MatchingProgress<?>> activeRecipes;
    private Pattern[] codes;
    private List<Predicate<String>> predicates;
    protected AnalysisContext analysisContext;

    protected AbstractDifferenceReferringTransform(@Nonnull String extensionId) {
        this.extensionId = extensionId;
    }

    @Nullable
    public String getExtensionId() {
        return this.extensionId;
    }

    @Nonnull
    public Pattern[] getDifferenceCodePatterns() {
        return this.codes;
    }

    @Nonnull
    public List<Predicate<String>> getDifferenceCodePredicates() {
        return this.predicates;
    }

    protected JsonNode getRecipesConfigurationAndInitialize() {
        return this.analysisContext.getConfigurationNode();
    }

    protected abstract DifferenceMatchRecipe newRecipe(JsonNode var1) throws IllegalArgumentException;

    public final void initialize(@Nonnull AnalysisContext analysisContext) {
        this.analysisContext = analysisContext;
        this.configuredRecipes = new ArrayList<DifferenceMatchRecipe>();
        JsonNode myNode = this.getRecipesConfigurationAndInitialize();
        if (!myNode.isArray()) {
            this.codes = new Pattern[0];
            this.predicates = Collections.emptyList();
            return;
        }
        ArrayList<Pattern> codes = new ArrayList<Pattern>();
        ArrayList<Predicate<String>> predicates = new ArrayList<Predicate<String>>();
        for (JsonNode config : myNode) {
            DifferenceMatchRecipe recipe = this.newRecipe(config);
            codes.add(recipe.codeRegex == null ? Pattern.compile("^" + Pattern.quote(recipe.code) + "$") : recipe.codeRegex);
            predicates.add(recipe.codeRegex == null ? recipe.code::equals : code -> recipe.codeRegex.matcher((CharSequence)code).matches());
            this.configuredRecipes.add(recipe);
        }
        this.codes = codes.toArray(new Pattern[0]);
        this.predicates = predicates;
    }

    public TransformationResult tryTransform(@Nullable E oldElement, @Nullable E newElement, Difference difference) {
        if (this.activeRecipes == null) {
            return TransformationResult.keep();
        }
        for (MatchingProgress<?> r : this.activeRecipes) {
            if (!r.matches(difference, (Element<?>)oldElement, (Element<?>)newElement)) continue;
            Difference d = r.transformMatching(difference, (Element<?>)oldElement, (Element<?>)newElement);
            if (d == null) {
                return TransformationResult.discard();
            }
            if (d == difference) {
                return TransformationResult.keep();
            }
            return TransformationResult.replaceWith((Difference)d);
        }
        return TransformationResult.keep();
    }

    public <X extends Element<X>> Optional<DifferenceTransform.TraversalTracker<X>> startTraversal(ApiAnalyzer<X> apiAnalyzer, ArchiveAnalyzer<X> oldArchiveAnalyzer, ArchiveAnalyzer<X> newArchiveAnalyzer) {
        if (this.configuredRecipes == null) {
            return Optional.empty();
        }
        final List recipes = this.configuredRecipes.stream().map(r -> r.startWithAnalyzers(oldArchiveAnalyzer, newArchiveAnalyzer)).collect(Collectors.toList());
        this.activeRecipes = recipes;
        return Optional.of(new DifferenceTransform.TraversalTracker<X>(){
            final /* synthetic */ AbstractDifferenceReferringTransform this$0;
            {
                this.this$0 = this$0;
            }

            public boolean startElements(@Nullable X oldElement, @Nullable X newElement) {
                boolean ret = false;
                for (MatchingProgress p : recipes) {
                    ret |= p.startElements(oldElement, newElement);
                }
                return ret;
            }

            public void endElements(@Nullable X oldElement, @Nullable X newElement) {
                for (MatchingProgress p : recipes) {
                    p.endElements(oldElement, newElement);
                }
            }

            public void endTraversal() {
                for (MatchingProgress p : recipes) {
                    p.endTraversal();
                }
            }
        });
    }

    public void endTraversal(DifferenceTransform.TraversalTracker<?> tracker) {
        this.activeRecipes = null;
    }
}

