/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.basic;

import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jboss.dmr.ModelNode;
import org.revapi.AnalysisContext;
import org.revapi.CompatibilityType;
import org.revapi.Criticality;
import org.revapi.Difference;
import org.revapi.DifferenceSeverity;
import org.revapi.Element;
import org.revapi.basic.AbstractDifferenceReferringTransform;
import org.revapi.basic.DifferenceMatchRecipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DifferencesTransform
extends AbstractDifferenceReferringTransform {
    private static final Logger LOG = LoggerFactory.getLogger(DifferencesTransform.class);
    private ModelNode bulkClassify;
    private ModelNode bulkIgnore;
    private ModelNode bulkJustification;
    private ModelNode bulkAttachments;
    private ModelNode bulkCriticality;

    public DifferencesTransform() {
        super("revapi.differences");
    }

    protected DifferencesTransform(String extensionId) {
        super(extensionId);
    }

    private static Map<CompatibilityType, DifferenceSeverity> parseClassification(ModelNode config) {
        EnumMap<CompatibilityType, DifferenceSeverity> classification = new EnumMap<CompatibilityType, DifferenceSeverity>(CompatibilityType.class);
        for (CompatibilityType ct : CompatibilityType.values()) {
            if (!config.has(ct.name())) continue;
            String val = config.get(ct.name()).asString();
            DifferenceSeverity sev = DifferenceSeverity.valueOf((String)val);
            classification.put(ct, sev);
        }
        return classification;
    }

    @Override
    @Nonnull
    protected DifferenceMatchRecipe newRecipe(ModelNode configNode) throws IllegalArgumentException {
        if (!(configNode = configNode.clone()).hasDefined("ignore") && this.bulkIgnore.isDefined()) {
            configNode.get("ignore").set(this.bulkIgnore.asBoolean());
        }
        if (!configNode.hasDefined("justification") && this.bulkJustification.isDefined()) {
            configNode.get("justification").set(this.bulkJustification.asString());
        }
        if (configNode.hasDefined("classify")) {
            ModelNode classify = configNode.get("classify");
            if (!classify.hasDefined("SOURCE") && this.bulkClassify.hasDefined("SOURCE")) {
                classify.get("SOURCE").set(this.bulkClassify.get("SOURCE").asString());
            }
            if (!classify.hasDefined("BINARY") && this.bulkClassify.hasDefined("BINARY")) {
                classify.get("BINARY").set(this.bulkClassify.get("BINARY").asString());
            }
            if (!classify.hasDefined("SEMANTIC") && this.bulkClassify.hasDefined("SEMANTIC")) {
                classify.get("SEMANTIC").set(this.bulkClassify.get("SEMANTIC").asString());
            }
            if (!classify.hasDefined("OTHER") && this.bulkClassify.hasDefined("OTHER")) {
                classify.get("OTHER").set(this.bulkClassify.get("OTHER").asString());
            }
        } else if (this.bulkClassify.isDefined()) {
            configNode.get("classify").set(this.bulkClassify.asObject());
        }
        if (configNode.hasDefined("attachments")) {
            ModelNode attachments = configNode.get("attachments");
            if (this.bulkAttachments.isDefined()) {
                for (String key : this.bulkAttachments.keys()) {
                    if (attachments.hasDefined(key)) continue;
                    attachments.get(key).set(this.bulkAttachments.get(key));
                }
            }
        } else if (this.bulkAttachments.isDefined()) {
            configNode.get("attachments").set(this.bulkAttachments.asObject());
        }
        if (!configNode.hasDefined("criticality") && this.bulkCriticality.isDefined()) {
            configNode.get("criticality").set(this.bulkCriticality.asString());
        }
        return new DifferenceRecipe(configNode, this.analysisContext);
    }

    public void close() throws Exception {
    }

    @Override
    protected ModelNode getRecipesConfigurationAndInitialize() {
        ModelNode configNode = this.analysisContext.getConfiguration();
        this.bulkClassify = configNode.get("classify");
        this.bulkIgnore = configNode.get("ignore");
        this.bulkJustification = configNode.get("justification");
        this.bulkAttachments = configNode.get("attachments");
        this.bulkCriticality = configNode.get("criticality");
        return configNode.get("differences");
    }

    @Nullable
    public Reader getJSONSchema() {
        return new InputStreamReader(this.getClass().getResourceAsStream("/META-INF/differences-schema.json"), StandardCharsets.UTF_8);
    }

    public static class DifferenceRecipe
    extends DifferenceMatchRecipe {
        protected final boolean ignore;
        protected final String justification;
        protected final Map<CompatibilityType, DifferenceSeverity> classification;
        protected final Map<String, String> newAttachments;
        protected final Criticality criticality;

        public DifferenceRecipe(ModelNode config, AnalysisContext ctx) {
            super(config, "classify", "ignore", "justification", "attachments", "criticality");
            this.ignore = config.get("ignore").asBoolean(false);
            this.justification = config.get("justification").asString(null);
            this.classification = DifferencesTransform.parseClassification(config.get("classify"));
            if (config.hasDefined("attachments")) {
                ModelNode attachments = config.get("attachments");
                this.newAttachments = new HashMap<String, String>();
                for (String key : attachments.keys()) {
                    this.newAttachments.put(key, attachments.get(key).asString(null));
                }
            } else {
                this.newAttachments = Collections.emptyMap();
            }
            if (config.hasDefined("criticality")) {
                String name = config.get("criticality").asString();
                this.criticality = ctx.getCriticalityByName(name);
                if (this.criticality == null) {
                    throw new IllegalArgumentException("Unknown criticality '" + name + "'.");
                }
            } else {
                this.criticality = null;
            }
        }

        @Override
        public Difference transformMatching(Difference difference, Element oldElement, Element newElement) {
            if (this.ignore) {
                return null;
            }
            if (this.justification == null && this.classification.isEmpty() && this.newAttachments.isEmpty() && this.criticality == null) {
                return difference;
            }
            Difference.Builder copy = Difference.copy((Difference)difference);
            if (this.justification != null) {
                copy.withJustification(this.justification);
            }
            if (this.criticality != null) {
                copy.withCriticality(this.criticality);
            }
            copy.addClassifications(this.classification);
            copy.addAttachments(this.newAttachments);
            return copy.build();
        }
    }
}

