/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy.plugins.client.httpclient;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.List;
import javax.ws.rs.ProduceMime;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyReader;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.resteasy.ClientInvoker;
import org.resteasy.Marshaller;
import org.resteasy.MessageBodyParameterMarshaller;
import org.resteasy.plugins.client.httpclient.BodyRequestEntity;
import org.resteasy.plugins.client.httpclient.HttpOutputMessage;
import org.resteasy.specimpl.MultivaluedMapImpl;
import org.resteasy.specimpl.UriBuilderImpl;
import org.resteasy.spi.ResteasyProviderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpClientInvoker
extends ClientInvoker {
    private HttpClient client;

    public HttpClientInvoker(HttpClient client, Class<?> declaring, Method method, ResteasyProviderFactory providerFactory) {
        super(declaring, method, providerFactory);
        this.client = client;
    }

    public abstract HttpMethodBase createBaseMethod(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object[] args) {
        if (this.builder == null) {
            throw new RuntimeException("You have not set a base URI for the client proxy");
        }
        HttpOutputMessage output = new HttpOutputMessage(null);
        UriBuilderImpl uri = (UriBuilderImpl)this.builder.clone();
        int i = 0;
        BodyRequestEntity body = null;
        for (Marshaller param : this.params) {
            if (param instanceof MessageBodyParameterMarshaller) {
                MessageBodyParameterMarshaller bodyMarshaller = (MessageBodyParameterMarshaller)param;
                body = new BodyRequestEntity(args[i], this.method.getGenericParameterTypes()[i], this.method.getParameterAnnotations()[i], bodyMarshaller, output.getOutputHeaders());
            } else {
                param.marshall(args[i], uri, output);
            }
            ++i;
        }
        String url = null;
        HttpMethodBase baseMethod = null;
        try {
            url = uri.build().toURL().toString();
            baseMethod = this.createBaseMethod(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unable to build URL from uri", e);
        }
        for (String key : output.getOutputHeaders().keySet()) {
            List value = (List)output.getOutputHeaders().get((Object)key);
            for (Object obj : value) {
                baseMethod.addRequestHeader(key, obj.toString());
            }
        }
        if (this.accepts != null) {
            baseMethod.setRequestHeader("Accept", this.accepts.toString());
        }
        if (body != null) {
            ((EntityEnclosingMethod)baseMethod).setRequestEntity((RequestEntity)body);
        }
        try {
            int status = this.client.executeMethod((HttpMethod)baseMethod);
            if (status != 200) {
                baseMethod.releaseConnection();
                throw new RuntimeException("Execution of Get " + url + " was unsuccessful with status code: " + status);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to execute GET request: " + url, e);
        }
        try {
            if (this.method.getReturnType() != null && !this.method.getReturnType().equals(Void.TYPE)) {
                Header contentType = baseMethod.getResponseHeader("Content-Type");
                if (contentType == null) {
                    throw new RuntimeException("Unable to determine content type of resource: " + url);
                }
                String mediaType = baseMethod.getResponseHeader("Content-Type").getValue();
                if (mediaType == null) {
                    ProduceMime produce = this.method.getAnnotation(ProduceMime.class);
                    if (produce == null) {
                        produce = this.declaring.getAnnotation(ProduceMime.class);
                    }
                    if (produce == null) {
                        throw new RuntimeException("Unable to determine content type of response for GET " + url);
                    }
                    mediaType = produce.value()[0];
                }
                MediaType media = MediaType.valueOf((String)mediaType);
                MessageBodyReader<?> reader = this.providerFactory.createMessageBodyReader(this.method.getReturnType(), this.method.getGenericReturnType(), this.method.getAnnotations(), media);
                if (reader == null) {
                    throw new RuntimeException("Unable to find a message body reader for GET " + url + " content-type: " + mediaType);
                }
                MultivaluedMapImpl responseHeaders = new MultivaluedMapImpl();
                for (Header header : baseMethod.getResponseHeaders()) {
                    responseHeaders.add(header.getName(), header.getValue());
                }
                try {
                    Object object = reader.readFrom(this.method.getReturnType(), this.method.getGenericReturnType(), this.method.getAnnotations(), media, responseHeaders, baseMethod.getResponseBodyAsStream());
                    return object;
                }
                catch (IOException iOException) {
                    throw new RuntimeException("Unable to unmarshall response from GET " + url + " content-type: " + mediaType, iOException);
                }
            }
            Object var8_15 = null;
            return var8_15;
        }
        finally {
            baseMethod.releaseConnection();
        }
    }
}

