/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyWriter;
import org.resteasy.Marshaller;
import org.resteasy.specimpl.UriBuilderImpl;
import org.resteasy.spi.ClientHttpOutput;
import org.resteasy.spi.ResteasyProviderFactory;

public class MessageBodyParameterMarshaller
implements Marshaller {
    private Class type;
    private ResteasyProviderFactory factory;
    private MediaType mediaType;
    private Type genericType;
    private Annotation[] annotations;

    public MessageBodyParameterMarshaller(MediaType mediaType, Class type, Type genericType, Annotation[] annotations, ResteasyProviderFactory factory) {
        this.type = type;
        this.factory = factory;
        this.mediaType = mediaType;
        this.genericType = genericType;
        this.annotations = annotations;
    }

    public void marshall(Object obj, UriBuilderImpl uri, ClientHttpOutput output) {
        try {
            MessageBodyWriter writer = this.getMessageBodyWriter();
            writer.writeTo(obj, this.type, this.genericType, this.annotations, this.mediaType, output.getOutputHeaders(), output.getOutputStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Failure marshalling body", e);
        }
    }

    public MessageBodyWriter getMessageBodyWriter() {
        MessageBodyWriter writer = this.factory.createMessageBodyWriter(this.type, this.genericType, this.annotations, this.mediaType);
        return writer;
    }

    public Class getType() {
        return this.type;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }
}

