/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;

public final class StatisticsSample {
    private static final String SEPARATOR = ";";
    private static final String EMPTY_VALUE = "";
    private static final String NUMBER_FORMAT = "0.00";
    private static final int BUFF_LENGTH = 64;
    private static final int FRACTION_DIGITS = 2;
    private long itsSum;
    private long itsCount;
    private long itsMinimum;
    private long itsMaximum;
    private final NumberFormat itsNumberFormat;

    public StatisticsSample() {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        this.itsNumberFormat = new DecimalFormat(NUMBER_FORMAT, dfs);
        this.itsNumberFormat.setMinimumIntegerDigits(1);
        this.itsNumberFormat.setMinimumFractionDigits(2);
        this.itsNumberFormat.setMaximumFractionDigits(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sample(long aValue) {
        StatisticsSample statisticsSample = this;
        synchronized (statisticsSample) {
            ++this.itsCount;
            this.itsSum += aValue;
            if (aValue < this.itsMinimum) {
                this.itsMinimum = aValue;
            }
            if (aValue > this.itsMaximum) {
                this.itsMaximum = aValue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAndReset() {
        StatisticsSample statisticsSample = this;
        synchronized (statisticsSample) {
            String r = new StringBuilder(64).append(this.itsCount).append(SEPARATOR).append(this.getMinimum()).append(SEPARATOR).append(this.getMaximum()).append(SEPARATOR).append(this.getAverage()).toString();
            this.itsSum = 0L;
            this.itsCount = 0L;
            this.itsMinimum = Long.MAX_VALUE;
            this.itsMaximum = Long.MIN_VALUE;
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        StatisticsSample statisticsSample = this;
        synchronized (statisticsSample) {
            this.itsSum = 0L;
            this.itsCount = 0L;
            this.itsMinimum = Long.MAX_VALUE;
            this.itsMaximum = Long.MIN_VALUE;
        }
    }

    private String getMinimum() {
        if (this.itsMinimum == Long.MAX_VALUE) {
            return EMPTY_VALUE;
        }
        return String.valueOf(this.itsMinimum);
    }

    private String getMaximum() {
        if (this.itsMaximum == Long.MIN_VALUE) {
            return EMPTY_VALUE;
        }
        return String.valueOf(this.itsMaximum);
    }

    private String getAverage() {
        if (this.itsCount == 0L) {
            return EMPTY_VALUE;
        }
        return this.itsNumberFormat.format((double)this.itsSum / (double)this.itsCount);
    }
}

