/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.util;

import com.cloudhopper.commons.util.StringUtil;
import com.cloudhopper.smpp.util.DeliveryReceiptException;
import java.util.TreeMap;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeliveryReceipt {
    private static final Logger logger = LoggerFactory.getLogger(DeliveryReceipt.class);
    private static final DateTimeFormatter dateFormatTemplate = DateTimeFormat.forPattern((String)"yyMMddHHmm");
    private static final DateTimeFormatter dateFormatTemplateWithSeconds = DateTimeFormat.forPattern((String)"yyMMddHHmmss");
    private static final DateTimeFormatter dateFormatTemplateWithFullYearAndSeconds = DateTimeFormat.forPattern((String)"yyyyMMddHHmmss");
    public static final int FIELD_ERR_MAX_LEN = 3;
    public static final String FIELD_ID = "id:";
    public static final String FIELD_SUB = "sub:";
    public static final String FIELD_DLVRD = "dlvrd:";
    public static final String FIELD_SUBMIT_DATE = "submit date:";
    public static final String FIELD_DONE_DATE = "done date:";
    public static final String FIELD_STAT = "stat:";
    public static final String FIELD_ERR = "err:";
    public static final String FIELD_TEXT = "text:";
    private String messageId;
    private int submitCount;
    private int deliveredCount;
    private DateTime submitDate;
    private DateTime doneDate;
    private byte state;
    private int errorCode;
    private String rawErrorCode;
    private String text;

    public DeliveryReceipt() {
        this.setErrorCode(0);
    }

    public DeliveryReceipt(String messageId, int submitCount, int deliveredCount, DateTime submitDate, DateTime doneDate, byte state, int errorCode, String text) {
        this.messageId = messageId;
        this.submitCount = submitCount;
        this.deliveredCount = deliveredCount;
        this.submitDate = submitDate;
        this.doneDate = doneDate;
        this.state = state;
        this.setErrorCode(errorCode);
        this.text = text;
    }

    public DeliveryReceipt(String messageId, int submitCount, int deliveredCount, DateTime submitDate, DateTime doneDate, byte state, String errorCode, String text) {
        this.messageId = messageId;
        this.submitCount = submitCount;
        this.deliveredCount = deliveredCount;
        this.submitDate = submitDate;
        this.doneDate = doneDate;
        this.state = state;
        this.setRawErrorCode(errorCode);
        this.text = text;
    }

    public int getDeliveredCount() {
        return this.deliveredCount;
    }

    public void setDeliveredCount(int deliveredCount) {
        this.deliveredCount = deliveredCount;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
        this.rawErrorCode = String.format("%03d", errorCode);
    }

    public String getRawErrorCode() {
        return this.rawErrorCode;
    }

    public void setRawErrorCode(String rawErrorCode) {
        this.rawErrorCode = rawErrorCode;
        try {
            this.errorCode = Integer.parseInt(rawErrorCode);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DateTime getDoneDate() {
        return this.doneDate;
    }

    public void setDoneDate(DateTime finalDate) {
        this.doneDate = finalDate;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public long getMessageIdAsLong() throws NumberFormatException {
        return Long.parseLong(this.messageId);
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setMessageId(long messageId) {
        this.messageId = String.format("%010d", messageId);
    }

    public byte getState() {
        return this.state;
    }

    public void setState(byte state) {
        this.state = state;
    }

    public int getSubmitCount() {
        return this.submitCount;
    }

    public void setSubmitCount(int submitCount) {
        this.submitCount = submitCount;
    }

    public DateTime getSubmitDate() {
        return this.submitDate;
    }

    public void setSubmitDate(DateTime submitDate) {
        this.submitDate = submitDate;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String toShortMessage() {
        StringBuilder buf = new StringBuilder(200);
        buf.append(FIELD_ID);
        buf.append(this.messageId);
        buf.append(" ");
        buf.append(FIELD_SUB);
        buf.append(String.format("%03d", this.submitCount));
        buf.append(" ");
        buf.append(FIELD_DLVRD);
        buf.append(String.format("%03d", this.deliveredCount));
        buf.append(" ");
        buf.append(FIELD_SUBMIT_DATE);
        if (this.submitDate == null) {
            buf.append("0000000000");
        } else {
            buf.append(dateFormatTemplate.print((ReadableInstant)this.submitDate));
        }
        buf.append(" ");
        buf.append(FIELD_DONE_DATE);
        if (this.doneDate == null) {
            buf.append("0000000000");
        } else {
            buf.append(dateFormatTemplate.print((ReadableInstant)this.doneDate));
        }
        buf.append(" ");
        buf.append(FIELD_STAT);
        buf.append(DeliveryReceipt.toStateText(this.state));
        buf.append(" ");
        buf.append(FIELD_ERR);
        buf.append(this.rawErrorCode);
        buf.append(" ");
        buf.append(FIELD_TEXT);
        if (this.text != null) {
            if (this.text.length() > 20) {
                buf.append(this.text.substring(0, 20));
            } else {
                buf.append(this.text);
            }
        }
        return buf.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("(id=");
        buf.append(this.messageId);
        buf.append(" sub=");
        buf.append(this.submitCount);
        buf.append(" dlvrd=");
        buf.append(this.deliveredCount);
        buf.append(" submitDate=");
        buf.append(this.submitDate);
        buf.append(" doneDate=");
        buf.append(this.doneDate);
        buf.append(" state=");
        buf.append(DeliveryReceipt.toStateText(this.state));
        buf.append("[");
        buf.append(this.state);
        buf.append("] err=");
        buf.append(this.rawErrorCode);
        buf.append(" text=[");
        buf.append(this.text);
        buf.append("])");
        return buf.toString();
    }

    private static boolean isValidErrorCode(int errorCode) {
        return DeliveryReceipt.isValidErrorCode(String.format("%03d", errorCode));
    }

    private static boolean isValidErrorCode(String errorCode) {
        return StringUtil.isEmpty((String)errorCode) || !StringUtil.isEmpty((String)errorCode) && errorCode.length() <= 3;
    }

    private static DateTime parseDateTimeHelper(String value, DateTimeZone zone) {
        if (value == null) {
            return null;
        }
        if (value.length() == 14) {
            return dateFormatTemplateWithFullYearAndSeconds.withZone(zone).parseDateTime(value);
        }
        if (value.length() == 12) {
            return dateFormatTemplateWithSeconds.withZone(zone).parseDateTime(value);
        }
        return dateFormatTemplate.withZone(zone).parseDateTime(value);
    }

    public static void findFieldAndAddToTreeMap(String normalizedText, String field, TreeMap<Integer, String> fieldsByStartPos) {
        int startPos = normalizedText.indexOf(field);
        if (startPos >= 0) {
            fieldsByStartPos.put(startPos, field);
        }
    }

    public static DeliveryReceipt parseShortMessage(String shortMessage, DateTimeZone zone) throws DeliveryReceiptException {
        return DeliveryReceipt.parseShortMessage(shortMessage, zone, true);
    }

    public static DeliveryReceipt parseShortMessage(String shortMessage, DateTimeZone zone, boolean checkMissingFields) throws DeliveryReceiptException {
        return DeliveryReceipt.parseShortMessage(shortMessage, zone, checkMissingFields, true);
    }

    /*
     * Unable to fully structure code
     */
    public static DeliveryReceipt parseShortMessage(String shortMessage, DateTimeZone zone, boolean checkMissingFields, boolean validateFields) throws DeliveryReceiptException {
        normalizedText = shortMessage.toLowerCase();
        dlr = new DeliveryReceipt(null, -1, -1, null, null, -1, -1, null);
        fieldsByStartPos = new TreeMap<Integer, String>();
        DeliveryReceipt.findFieldAndAddToTreeMap(normalizedText, "id:", fieldsByStartPos);
        DeliveryReceipt.findFieldAndAddToTreeMap(normalizedText, "sub:", fieldsByStartPos);
        DeliveryReceipt.findFieldAndAddToTreeMap(normalizedText, "dlvrd:", fieldsByStartPos);
        DeliveryReceipt.findFieldAndAddToTreeMap(normalizedText, "submit date:", fieldsByStartPos);
        DeliveryReceipt.findFieldAndAddToTreeMap(normalizedText, "done date:", fieldsByStartPos);
        DeliveryReceipt.findFieldAndAddToTreeMap(normalizedText, "stat:", fieldsByStartPos);
        DeliveryReceipt.findFieldAndAddToTreeMap(normalizedText, "err:", fieldsByStartPos);
        DeliveryReceipt.findFieldAndAddToTreeMap(normalizedText, "text:", fieldsByStartPos);
        curFieldEntry = fieldsByStartPos.firstEntry();
        while (curFieldEntry != null) {
            block23: {
                block29: {
                    block28: {
                        block27: {
                            block26: {
                                block25: {
                                    block24: {
                                        nextFieldEntry = fieldsByStartPos.higherEntry(curFieldEntry.getKey());
                                        fieldLabelStartPos = curFieldEntry.getKey();
                                        startPos = fieldLabelStartPos + curFieldEntry.getValue().length();
                                        endPos = nextFieldEntry != null ? nextFieldEntry.getKey().intValue() : normalizedText.length();
                                        fieldLabel = curFieldEntry.getValue();
                                        fieldValue = shortMessage.substring(startPos, endPos).trim();
                                        if (StringUtil.isEmpty((String)fieldValue)) break block23;
                                        if (!fieldLabel.equalsIgnoreCase("id:")) break block24;
                                        dlr.messageId = fieldValue;
                                        break block23;
                                    }
                                    if (!fieldLabel.equalsIgnoreCase("sub:")) break block25;
                                    try {
                                        dlr.submitCount = Integer.parseInt(fieldValue);
                                    }
                                    catch (NumberFormatException e) {
                                        if (!validateFields) ** GOTO lbl73
                                        throw new DeliveryReceiptException("Unable to convert [sub] field with value [" + fieldValue + "] into an integer");
                                    }
                                }
                                if (!fieldLabel.equalsIgnoreCase("dlvrd:")) break block26;
                                try {
                                    dlr.deliveredCount = Integer.parseInt(fieldValue);
                                }
                                catch (NumberFormatException e) {
                                    if (!validateFields) ** GOTO lbl73
                                    throw new DeliveryReceiptException("Unable to convert [dlvrd] field with value [" + fieldValue + "] into an integer");
                                }
                            }
                            if (!fieldLabel.equalsIgnoreCase("submit date:")) break block27;
                            try {
                                dlr.submitDate = DeliveryReceipt.parseDateTimeHelper(fieldValue, zone);
                            }
                            catch (IllegalArgumentException e) {
                                if (!validateFields) ** GOTO lbl73
                                throw new DeliveryReceiptException("Unable to convert [submit date] field with value [" + fieldValue + "] into a datetime object");
                            }
                        }
                        if (!fieldLabel.equalsIgnoreCase("done date:")) break block28;
                        try {
                            dlr.doneDate = DeliveryReceipt.parseDateTimeHelper(fieldValue, zone);
                        }
                        catch (IllegalArgumentException e) {
                            if (!validateFields) ** GOTO lbl73
                            throw new DeliveryReceiptException("Unable to convert [done date] field with value [" + fieldValue + "] into a datetime object");
                        }
                    }
                    if (!fieldLabel.equalsIgnoreCase("stat:")) break block29;
                    dlr.state = DeliveryReceipt.toState(fieldValue);
                    if (dlr.state < 0 && validateFields) {
                        throw new DeliveryReceiptException("Unable to convert [stat] field with value [" + fieldValue + "] into a valid state");
                    }
                    break block23;
                }
                if (!fieldLabel.equalsIgnoreCase("err:")) ** GOTO lbl68
                if (!validateFields || DeliveryReceipt.isValidErrorCode(fieldValue)) {
                    dlr.setRawErrorCode(fieldValue);
                } else {
                    throw new DeliveryReceiptException("The [err] field was not of a valid lengh of <= 3");
lbl68:
                    // 1 sources

                    if (fieldLabel.equalsIgnoreCase("text:")) {
                        dlr.text = fieldValue;
                    } else if (validateFields) {
                        throw new DeliveryReceiptException("Unsupported field [" + fieldValue + "] found");
                    }
                }
            }
            curFieldEntry = nextFieldEntry;
        }
        if (checkMissingFields) {
            if (StringUtil.isEmpty((String)dlr.messageId)) {
                throw new DeliveryReceiptException("Unable to find [id] field or empty value in delivery receipt message");
            }
            if (dlr.submitCount < 0) {
                throw new DeliveryReceiptException("Unable to find [sub] field or empty value in delivery receipt message");
            }
            if (dlr.deliveredCount < 0) {
                throw new DeliveryReceiptException("Unable to find [dlvrd] field or empty value in delivery receipt message");
            }
            if (dlr.submitDate == null) {
                throw new DeliveryReceiptException("Unable to find [submit date] field or empty value in delivery receipt message");
            }
            if (dlr.doneDate == null) {
                throw new DeliveryReceiptException("Unable to find [done date] field or empty value in delivery receipt message");
            }
            if (dlr.state < 0) {
                throw new DeliveryReceiptException("Unable to find [stat] field or empty value in delivery receipt message");
            }
            if (StringUtil.isEmpty((String)dlr.rawErrorCode) && dlr.errorCode < 0) {
                throw new DeliveryReceiptException("Unable to find [err] field or empty value in delivery receipt message");
            }
        }
        return dlr;
    }

    public static byte toState(String stateText) {
        if (stateText == null) {
            return -1;
        }
        if (stateText.equalsIgnoreCase("DELIVRD")) {
            return 2;
        }
        if (stateText.equalsIgnoreCase("EXPIRED")) {
            return 3;
        }
        if (stateText.equalsIgnoreCase("DELETED")) {
            return 4;
        }
        if (stateText.equalsIgnoreCase("UNDELIV")) {
            return 5;
        }
        if (stateText.equalsIgnoreCase("ACCEPTD")) {
            return 6;
        }
        if (stateText.equalsIgnoreCase("UNKNOWN")) {
            return 7;
        }
        if (stateText.equalsIgnoreCase("REJECTD")) {
            return 8;
        }
        if (stateText.equalsIgnoreCase("ENROUTE")) {
            return 1;
        }
        return -1;
    }

    public static String toStateText(byte state) {
        switch (state) {
            case 2: {
                return "DELIVRD";
            }
            case 3: {
                return "EXPIRED";
            }
            case 4: {
                return "DELETED";
            }
            case 5: {
                return "UNDELIV";
            }
            case 6: {
                return "ACCEPTD";
            }
            case 7: {
                return "UNKNOWN";
            }
            case 8: {
                return "REJECTD";
            }
            case 1: {
                return "ENROUTE";
            }
        }
        return "BADSTAT";
    }

    public static String toMessageIdAsHexString(long value) {
        return String.format("%x", value);
    }

    public static long toMessageIdAsLong(String value) throws NumberFormatException {
        return Long.parseLong(value, 16);
    }
}

