/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.transcoder;

import com.cloudhopper.commons.util.HexUtil;
import com.cloudhopper.smpp.pdu.AlertNotification;
import com.cloudhopper.smpp.pdu.BindReceiver;
import com.cloudhopper.smpp.pdu.BindReceiverResp;
import com.cloudhopper.smpp.pdu.BindTransceiver;
import com.cloudhopper.smpp.pdu.BindTransceiverResp;
import com.cloudhopper.smpp.pdu.BindTransmitter;
import com.cloudhopper.smpp.pdu.BindTransmitterResp;
import com.cloudhopper.smpp.pdu.CancelSm;
import com.cloudhopper.smpp.pdu.CancelSmResp;
import com.cloudhopper.smpp.pdu.DataSm;
import com.cloudhopper.smpp.pdu.DataSmResp;
import com.cloudhopper.smpp.pdu.DeliverSm;
import com.cloudhopper.smpp.pdu.DeliverSmResp;
import com.cloudhopper.smpp.pdu.EnquireLink;
import com.cloudhopper.smpp.pdu.EnquireLinkResp;
import com.cloudhopper.smpp.pdu.GenericNack;
import com.cloudhopper.smpp.pdu.PartialPdu;
import com.cloudhopper.smpp.pdu.PartialPduResp;
import com.cloudhopper.smpp.pdu.Pdu;
import com.cloudhopper.smpp.pdu.PduResponse;
import com.cloudhopper.smpp.pdu.QuerySm;
import com.cloudhopper.smpp.pdu.QuerySmResp;
import com.cloudhopper.smpp.pdu.ReplaceSm;
import com.cloudhopper.smpp.pdu.ReplaceSmResp;
import com.cloudhopper.smpp.pdu.SubmitMulti;
import com.cloudhopper.smpp.pdu.SubmitMultiResp;
import com.cloudhopper.smpp.pdu.SubmitSm;
import com.cloudhopper.smpp.pdu.SubmitSmResp;
import com.cloudhopper.smpp.pdu.Unbind;
import com.cloudhopper.smpp.pdu.UnbindResp;
import com.cloudhopper.smpp.transcoder.PduTranscoder;
import com.cloudhopper.smpp.transcoder.PduTranscoderContext;
import com.cloudhopper.smpp.type.NotEnoughDataInBufferException;
import com.cloudhopper.smpp.type.RecoverablePduException;
import com.cloudhopper.smpp.type.UnknownCommandIdException;
import com.cloudhopper.smpp.type.UnrecoverablePduException;
import com.cloudhopper.smpp.util.PduUtil;
import com.cloudhopper.smpp.util.SequenceNumber;
import org.jboss.netty.buffer.BigEndianHeapChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffer;

public class DefaultPduTranscoder
implements PduTranscoder {
    private final PduTranscoderContext context;

    public DefaultPduTranscoder(PduTranscoderContext context) {
        this.context = context;
    }

    public ChannelBuffer encode(Pdu pdu) throws UnrecoverablePduException, RecoverablePduException {
        PduResponse response;
        if (pdu instanceof PduResponse && (response = (PduResponse)pdu).getResultMessage() == null) {
            response.setResultMessage(this.context.lookupResultMessage(pdu.getCommandStatus()));
        }
        if (!pdu.hasCommandLengthCalculated()) {
            pdu.calculateAndSetCommandLength();
        }
        BigEndianHeapChannelBuffer buffer = new BigEndianHeapChannelBuffer(pdu.getCommandLength());
        buffer.writeInt(pdu.getCommandLength());
        buffer.writeInt(pdu.getCommandId());
        buffer.writeInt(pdu.getCommandStatus());
        buffer.writeInt(pdu.getSequenceNumber());
        pdu.writeBody((ChannelBuffer)buffer);
        pdu.writeOptionalParameters((ChannelBuffer)buffer, this.context);
        if (buffer.readableBytes() != pdu.getCommandLength()) {
            throw new NotEnoughDataInBufferException("During PDU encoding the expected commandLength did not match the actual encoded (a serious error with our own encoding process)", pdu.getCommandLength(), buffer.readableBytes());
        }
        return buffer;
    }

    public Pdu decode(ChannelBuffer buffer) throws UnrecoverablePduException, RecoverablePduException {
        if (buffer.readableBytes() < 4) {
            return null;
        }
        int commandLength = buffer.getInt(buffer.readerIndex());
        if (commandLength < 16) {
            throw new UnrecoverablePduException("Invalid PDU length [0x" + HexUtil.toHexString((int)commandLength) + "] parsed");
        }
        if (buffer.readableBytes() < commandLength) {
            return null;
        }
        ChannelBuffer buffer0 = buffer.readSlice(commandLength);
        return this.doDecode(commandLength, buffer0);
    }

    protected Pdu doDecode(int commandLength, ChannelBuffer buffer) throws UnrecoverablePduException, RecoverablePduException {
        buffer.skipBytes(4);
        int commandId = buffer.readInt();
        int commandStatus = buffer.readInt();
        int sequenceNumber = buffer.readInt();
        SequenceNumber.assertValid(sequenceNumber);
        Pdu pdu = null;
        pdu = PduUtil.isRequestCommandId(commandId) ? (commandId == 21 ? new EnquireLink() : (commandId == 5 ? new DeliverSm() : (commandId == 4 ? new SubmitSm() : (commandId == 259 ? new DataSm() : (commandId == 8 ? new CancelSm() : (commandId == 3 ? new QuerySm() : (commandId == 7 ? new ReplaceSm() : (commandId == 9 ? new BindTransceiver() : (commandId == 2 ? new BindTransmitter() : (commandId == 1 ? new BindReceiver() : (commandId == 6 ? new Unbind() : (commandId == 258 ? new AlertNotification() : (commandId == 33 ? new SubmitMulti() : new PartialPdu(commandId)))))))))))))) : (commandId == -2147483644 ? new SubmitSmResp() : (commandId == -2147483643 ? new DeliverSmResp() : (commandId == -2147483389 ? new DataSmResp() : (commandId == -2147483640 ? new CancelSmResp() : (commandId == -2147483645 ? new QuerySmResp() : (commandId == -2147483641 ? new ReplaceSmResp() : (commandId == -2147483627 ? new EnquireLinkResp() : (commandId == -2147483639 ? new BindTransceiverResp() : (commandId == -2147483647 ? new BindReceiverResp() : (commandId == -2147483646 ? new BindTransmitterResp() : (commandId == -2147483642 ? new UnbindResp() : (commandId == Integer.MIN_VALUE ? new GenericNack() : (commandId == -2147483615 ? new SubmitMultiResp() : new PartialPduResp(commandId))))))))))))));
        pdu.setCommandLength(commandLength);
        pdu.setCommandStatus(commandStatus);
        pdu.setSequenceNumber(sequenceNumber);
        if (pdu instanceof PartialPdu) {
            throw new UnknownCommandIdException(pdu, "Unsupported or unknown PDU request commandId [0x" + HexUtil.toHexString((int)commandId) + "]");
        }
        if (pdu instanceof PartialPduResp) {
            throw new UnknownCommandIdException(pdu, "Unsupported or unknown PDU response commandId [0x" + HexUtil.toHexString((int)commandId) + "]");
        }
        if (pdu instanceof PduResponse) {
            PduResponse response = (PduResponse)pdu;
            response.setResultMessage(this.context.lookupResultMessage(commandStatus));
        }
        try {
            ((Pdu)pdu).readBody(buffer);
            pdu.readOptionalParameters(buffer, this.context);
        }
        catch (RecoverablePduException e) {
            if (e.getPartialPdu() == null) {
                e.setPartialPdu(pdu);
            }
            throw e;
        }
        return pdu;
    }
}

