/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.simulator;

import com.cloudhopper.smpp.pdu.BaseBind;
import com.cloudhopper.smpp.pdu.BaseBindResp;
import com.cloudhopper.smpp.pdu.Pdu;
import com.cloudhopper.smpp.pdu.PduRequest;
import com.cloudhopper.smpp.simulator.SmppSimulatorPduProcessor;
import com.cloudhopper.smpp.simulator.SmppSimulatorSessionHandler;
import org.jboss.netty.channel.Channel;

public class SmppSimulatorBindProcessor
implements SmppSimulatorPduProcessor {
    private String systemId;
    private String password;

    public SmppSimulatorBindProcessor(String systemId, String password) {
        this.systemId = systemId;
        this.password = password;
    }

    public boolean process(SmppSimulatorSessionHandler session, Channel channel, Pdu pdu) throws Exception {
        if (!(pdu instanceof BaseBind)) {
            if (pdu instanceof PduRequest) {
                session.addPduToWriteOnNextPduReceived(((PduRequest)pdu).createGenericNack(4));
                return true;
            }
            channel.close();
            return true;
        }
        BaseBind bind = (BaseBind)pdu;
        BaseBindResp bindResp = (BaseBindResp)bind.createResponse();
        if (!bind.getSystemId().equals(this.systemId)) {
            bindResp.setCommandStatus(15);
        } else if (!bind.getPassword().equals(this.password)) {
            bindResp.setCommandStatus(14);
        }
        session.addPduToWriteOnNextPduReceived(bindResp);
        return true;
    }
}

