/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.pdu;

import com.cloudhopper.smpp.pdu.BaseSmResp;
import com.cloudhopper.smpp.type.Address;
import com.cloudhopper.smpp.type.RecoverablePduException;
import com.cloudhopper.smpp.type.SmppInvalidArgumentException;
import com.cloudhopper.smpp.type.UnrecoverablePduException;
import com.cloudhopper.smpp.type.UnsucessfulSME;
import com.cloudhopper.smpp.util.ChannelBufferUtil;
import com.cloudhopper.smpp.util.PduUtil;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubmitMultiResp
extends BaseSmResp {
    private int numberOfUnsucessfulDest;
    private List<UnsucessfulSME> unsucessfulSmes = new ArrayList<UnsucessfulSME>();

    public SubmitMultiResp() {
        super(-2147483615, "submit_multi_resp");
    }

    public void addUnsucessfulSME(UnsucessfulSME unsucessfulSME) throws SmppInvalidArgumentException {
        ++this.numberOfUnsucessfulDest;
        this.unsucessfulSmes.add(unsucessfulSME);
    }

    public int getNumberOfUnsucessfulDest() {
        return this.numberOfUnsucessfulDest;
    }

    public List<UnsucessfulSME> getUnsucessfulSmes() {
        return this.unsucessfulSmes;
    }

    @Override
    public void readBody(ChannelBuffer buffer) throws UnrecoverablePduException, RecoverablePduException {
        super.readBody(buffer);
        this.numberOfUnsucessfulDest = buffer.readByte() & 0xFF;
        for (int count = 0; count < this.numberOfUnsucessfulDest; ++count) {
            Address address = ChannelBufferUtil.readAddress(buffer);
            int errorStatusCode = buffer.readInt();
            this.unsucessfulSmes.add(new UnsucessfulSME(errorStatusCode, address));
        }
    }

    @Override
    public int calculateByteSizeOfBody() {
        int bodyLength = 0;
        bodyLength = super.calculateByteSizeOfBody();
        ++bodyLength;
        for (int count = 0; count < this.numberOfUnsucessfulDest; ++count) {
            UnsucessfulSME unsucessfulSME = this.unsucessfulSmes.get(count);
            bodyLength += PduUtil.calculateByteSizeOfAddress(unsucessfulSME.getAddress());
            bodyLength += 4;
        }
        return bodyLength;
    }

    @Override
    public void writeBody(ChannelBuffer buffer) throws UnrecoverablePduException, RecoverablePduException {
        super.writeBody(buffer);
        buffer.writeByte(this.numberOfUnsucessfulDest);
        for (int count = 0; count < this.numberOfUnsucessfulDest; ++count) {
            UnsucessfulSME unsucessfulSME = this.unsucessfulSmes.get(count);
            ChannelBufferUtil.writeAddress(buffer, unsucessfulSME.getAddress());
            buffer.writeInt(unsucessfulSME.getErrorStatusCode());
        }
    }
}

