/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.channel;

import com.cloudhopper.smpp.type.LoggingOptions;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.MessageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelPipelineCoverage(value="one")
public class SmppSessionLogger
implements ChannelUpstreamHandler,
ChannelDownstreamHandler {
    private final Logger logger;
    private final LoggingOptions options;

    public SmppSessionLogger(String name) {
        this(name, new LoggingOptions());
    }

    public SmppSessionLogger(String name, LoggingOptions options) {
        this.logger = LoggerFactory.getLogger((String)name);
        this.options = options;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public LoggingOptions getOptions() {
        return this.options;
    }

    protected void log(Direction direction, ChannelEvent evt) {
        MessageEvent me;
        if (evt instanceof MessageEvent && (me = (MessageEvent)evt).getMessage() instanceof ChannelBuffer && this.options.isLogBytesEnabled()) {
            ChannelBuffer buffer = (ChannelBuffer)me.getMessage();
            if (direction == Direction.UP) {
                this.logger.info("read bytes: [{}]", (Object)ChannelBuffers.hexDump((ChannelBuffer)buffer));
            } else if (direction == Direction.DOWN) {
                this.logger.info("write bytes: [{}]", (Object)ChannelBuffers.hexDump((ChannelBuffer)buffer));
            }
        }
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        this.log(Direction.UP, e);
        ctx.sendUpstream(e);
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        this.log(Direction.DOWN, e);
        ctx.sendDownstream(e);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        UP,
        DOWN;

    }
}

