/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util.windowing;

import com.cloudhopper.commons.util.UnwrappedWeakReference;
import com.cloudhopper.commons.util.windowing.DefaultWindowFuture;
import com.cloudhopper.commons.util.windowing.DuplicateKeyException;
import com.cloudhopper.commons.util.windowing.OfferTimeoutException;
import com.cloudhopper.commons.util.windowing.PendingOfferAbortedException;
import com.cloudhopper.commons.util.windowing.WindowFuture;
import com.cloudhopper.commons.util.windowing.WindowListener;
import com.cloudhopper.commons.util.windowing.WindowMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Window<K, R, P> {
    private static final Logger logger = LoggerFactory.getLogger(Window.class);
    private final int maxSize;
    private final ConcurrentHashMap<K, DefaultWindowFuture<K, R, P>> futures;
    private final ReentrantLock lock;
    private final Condition completedCondition;
    private AtomicInteger pendingOffers;
    private AtomicBoolean pendingOffersAborted;
    private final ScheduledExecutorService executor;
    private ScheduledFuture<?> monitorHandle;
    private final WindowMonitor monitor;
    private final long monitorInterval;
    private final CopyOnWriteArrayList<UnwrappedWeakReference<WindowListener<K, R, P>>> listeners;

    public Window(int size) {
        this(size, null, 0L, null, null);
    }

    public Window(int size, ScheduledExecutorService executor, long monitorInterval, WindowListener<K, R, P> listener) {
        this(size, executor, monitorInterval, listener, null);
    }

    public Window(int size, ScheduledExecutorService executor, long monitorInterval, WindowListener<K, R, P> listener, String monitorThreadName) {
        if (size <= 0) {
            throw new IllegalArgumentException("size must be > 0");
        }
        this.maxSize = size;
        this.futures = new ConcurrentHashMap(size * 2);
        this.lock = new ReentrantLock();
        this.completedCondition = this.lock.newCondition();
        this.pendingOffers = new AtomicInteger(0);
        this.pendingOffersAborted = new AtomicBoolean(false);
        this.executor = executor;
        this.monitorInterval = monitorInterval;
        this.listeners = new CopyOnWriteArrayList();
        if (listener != null) {
            this.listeners.add(new UnwrappedWeakReference<WindowListener<K, R, P>>(listener));
        }
        if (this.executor != null) {
            this.monitor = new WindowMonitor(this, monitorThreadName);
            this.monitorHandle = this.executor.scheduleWithFixedDelay(this.monitor, this.monitorInterval, this.monitorInterval, TimeUnit.MILLISECONDS);
        } else {
            this.monitor = null;
            this.monitorHandle = null;
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getSize() {
        return this.futures.size();
    }

    public int getFreeSize() {
        return this.maxSize - this.futures.size();
    }

    public boolean containsKey(K key) {
        return this.futures.containsKey(key);
    }

    public WindowFuture<K, R, P> get(K key) {
        return this.futures.get(key);
    }

    public void addListener(WindowListener<K, R, P> listener) {
        this.listeners.addIfAbsent(new UnwrappedWeakReference<WindowListener<K, R, P>>(listener));
    }

    public void removeListener(WindowListener<K, R, P> listener) {
        this.listeners.remove(new UnwrappedWeakReference<WindowListener<K, R, P>>(listener));
    }

    List<UnwrappedWeakReference<WindowListener<K, R, P>>> getListeners() {
        return this.listeners;
    }

    public synchronized void destroy() {
        try {
            this.abortPendingOffers();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cancelAll();
        this.listeners.clear();
        this.stopMonitor();
    }

    public synchronized boolean startMonitor() {
        if (this.executor != null) {
            if (this.monitorHandle == null) {
                this.monitorHandle = this.executor.scheduleWithFixedDelay(this.monitor, this.monitorInterval, this.monitorInterval, TimeUnit.MILLISECONDS);
            }
            return true;
        }
        return false;
    }

    public synchronized void stopMonitor() {
        if (this.monitorHandle != null) {
            this.monitorHandle.cancel(true);
            this.monitorHandle = null;
        }
    }

    public Map<K, WindowFuture<K, R, P>> createSortedSnapshot() {
        TreeMap<K, DefaultWindowFuture<K, R, P>> sortedRequests = new TreeMap<K, DefaultWindowFuture<K, R, P>>();
        sortedRequests.putAll(this.futures);
        return sortedRequests;
    }

    public WindowFuture offer(K key, R request, long offerTimeoutMillis) throws DuplicateKeyException, OfferTimeoutException, InterruptedException {
        return this.offer(key, request, offerTimeoutMillis, -1L, false);
    }

    public WindowFuture offer(K key, R request, long offerTimeoutMillis, long expireTimeoutMillis) throws DuplicateKeyException, OfferTimeoutException, InterruptedException {
        return this.offer(key, request, offerTimeoutMillis, expireTimeoutMillis, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowFuture offer(K key, R request, long offerTimeoutMillis, long expireTimeoutMillis, boolean callerWaitingHint) throws DuplicateKeyException, OfferTimeoutException, PendingOfferAbortedException, InterruptedException {
        if (offerTimeoutMillis < 0L) {
            throw new IllegalArgumentException("offerTimeoutMillis must be >= 0 [actual=" + offerTimeoutMillis + "]");
        }
        if (this.futures.containsKey(key)) {
            throw new DuplicateKeyException("The key [" + key + "] already exists in the window");
        }
        long offerTimestamp = System.currentTimeMillis();
        this.lock.lockInterruptibly();
        try {
            while (this.getFreeSize() <= 0) {
                long currentOfferTime = System.currentTimeMillis() - offerTimestamp;
                if (currentOfferTime >= offerTimeoutMillis) {
                    throw new OfferTimeoutException("Unable to accept offer within [" + offerTimeoutMillis + " ms] (window full)");
                }
                if (this.pendingOffersAborted.get()) {
                    throw new PendingOfferAbortedException("Pending offer aborted (by an explicit call to abortPendingOffers())");
                }
                long remainingOfferTime = offerTimeoutMillis - currentOfferTime;
                try {
                    this.beginPendingOffer();
                    this.completedCondition.await(remainingOfferTime, TimeUnit.MILLISECONDS);
                }
                finally {
                    boolean abortPendingOffer = this.endPendingOffer();
                    if (!abortPendingOffer) continue;
                    throw new PendingOfferAbortedException("Pending offer aborted (by an explicit call to abortPendingOffers())");
                }
            }
            long acceptTimestamp = System.currentTimeMillis();
            long expireTimestamp = expireTimeoutMillis > 0L ? acceptTimestamp + expireTimeoutMillis : -1L;
            int callerStateHint = callerWaitingHint ? 1 : 0;
            DefaultWindowFuture future = new DefaultWindowFuture(this, this.lock, this.completedCondition, key, request, callerStateHint, offerTimeoutMillis, this.futures.size() + 1, offerTimestamp, acceptTimestamp, expireTimestamp);
            this.futures.put(key, future);
            DefaultWindowFuture defaultWindowFuture = future;
            return defaultWindowFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getPendingOfferCount() {
        return this.pendingOffers.get();
    }

    private void beginPendingOffer() {
        this.pendingOffers.incrementAndGet();
    }

    private boolean endPendingOffer() {
        int newValue = this.pendingOffers.decrementAndGet();
        if (newValue == 0) {
            return this.pendingOffersAborted.compareAndSet(true, false);
        }
        return this.pendingOffersAborted.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean abortPendingOffers() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            if (this.pendingOffers.get() > 0) {
                this.pendingOffersAborted.set(true);
                this.completedCondition.signalAll();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowFuture<K, R, P> complete(K key, P response) throws InterruptedException {
        if (response == null) {
            throw new IllegalArgumentException("Null responses are illegal. Use cancel() instead.");
        }
        if (!this.futures.containsKey(key)) {
            return null;
        }
        this.lock.lockInterruptibly();
        try {
            DefaultWindowFuture<K, R, P> future = this.futures.remove(key);
            if (future == null) {
                WindowFuture<K, R, P> windowFuture = null;
                return windowFuture;
            }
            future.completeHelper(response, System.currentTimeMillis());
            this.completedCondition.signalAll();
            DefaultWindowFuture<K, R, P> defaultWindowFuture = future;
            return defaultWindowFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowFuture<K, R, P> fail(K key, Throwable t) throws InterruptedException {
        if (t == null) {
            throw new IllegalArgumentException("Null throwables are illegal. Use cancel() instead.");
        }
        if (!this.futures.containsKey(key)) {
            return null;
        }
        this.lock.lockInterruptibly();
        try {
            DefaultWindowFuture<K, R, P> future = this.futures.remove(key);
            if (future == null) {
                WindowFuture<K, R, P> windowFuture = null;
                return windowFuture;
            }
            future.failedHelper(t, System.currentTimeMillis());
            this.completedCondition.signalAll();
            DefaultWindowFuture<K, R, P> defaultWindowFuture = future;
            return defaultWindowFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WindowFuture<K, R, P>> failAll(Throwable t) throws InterruptedException {
        if (this.futures.size() <= 0) {
            return null;
        }
        ArrayList<WindowFuture<K, R, P>> failed = new ArrayList<WindowFuture<K, R, P>>();
        long now = System.currentTimeMillis();
        this.lock.lock();
        try {
            for (DefaultWindowFuture<K, R, P> future : this.futures.values()) {
                failed.add(future);
                future.failedHelper(t, now);
            }
            if (failed.size() > 0) {
                this.futures.clear();
                this.completedCondition.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
        return failed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowFuture<K, R, P> cancel(K key) throws InterruptedException {
        if (!this.futures.containsKey(key)) {
            return null;
        }
        this.lock.lockInterruptibly();
        try {
            DefaultWindowFuture<K, R, P> future = this.futures.remove(key);
            if (future == null) {
                WindowFuture<K, R, P> windowFuture = null;
                return windowFuture;
            }
            future.cancelHelper(System.currentTimeMillis());
            this.completedCondition.signalAll();
            DefaultWindowFuture<K, R, P> defaultWindowFuture = future;
            return defaultWindowFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WindowFuture<K, R, P>> cancelAll() {
        if (this.futures.size() <= 0) {
            return null;
        }
        ArrayList<WindowFuture<K, R, P>> cancelled = new ArrayList<WindowFuture<K, R, P>>();
        long now = System.currentTimeMillis();
        this.lock.lock();
        try {
            for (DefaultWindowFuture<K, R, P> future : this.futures.values()) {
                cancelled.add(future);
                future.cancelHelper(now);
            }
            if (cancelled.size() > 0) {
                this.futures.clear();
                this.completedCondition.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
        return cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WindowFuture<K, R, P>> cancelAllExpired() {
        if (this.futures.size() <= 0) {
            return null;
        }
        ArrayList<WindowFuture<K, R, P>> expired = new ArrayList<WindowFuture<K, R, P>>();
        long now = System.currentTimeMillis();
        this.lock.lock();
        try {
            for (DefaultWindowFuture<K, R, P> defaultWindowFuture : this.futures.values()) {
                if (!defaultWindowFuture.hasExpireTimestamp() || now < defaultWindowFuture.getExpireTimestamp()) continue;
                expired.add(defaultWindowFuture);
                defaultWindowFuture.cancelHelper(now);
            }
            if (expired.size() > 0) {
                for (WindowFuture windowFuture : expired) {
                    this.futures.remove(windowFuture.getKey());
                }
                this.completedCondition.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
        return expired;
    }

    void removeHelper(K key) {
        this.futures.remove(key);
    }
}

