/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util.time;

import com.cloudhopper.commons.util.time.DateTimePeriod;
import com.cloudhopper.commons.util.time.DateTimePeriodData;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimePeriodDataUtil {
    private DateTimePeriodDataUtil() {
    }

    public static <T extends DateTimePeriodData> void fill(Class<T> type, Map<DateTime, T> dataset, List<DateTimePeriod> periods) {
        for (DateTimePeriod period : periods) {
            if (dataset.containsKey(period.getStart())) continue;
            try {
                Constructor<T> ctor = type.getConstructor(DateTimePeriod.class);
                DateTimePeriodData data = (DateTimePeriodData)ctor.newInstance(period);
                dataset.put(period.getStart(), data);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create default dataset entry", e);
            }
        }
    }
}

