/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util.time;

import com.cloudhopper.commons.util.time.DateTimeDay;
import com.cloudhopper.commons.util.time.DateTimeDuration;
import com.cloudhopper.commons.util.time.DateTimeFiveMinutes;
import com.cloudhopper.commons.util.time.DateTimeHour;
import com.cloudhopper.commons.util.time.DateTimeMonth;
import com.cloudhopper.commons.util.time.DateTimeYear;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DateTimePeriod {
    private final DateTime start;
    private final DateTime end;
    private final DateTimeDuration duration;
    private final String key;
    private final String longName;
    private final String shortName;
    private final String indexName;

    protected DateTimePeriod(DateTime start, DateTime end, DateTimeDuration duration, String keyPattern, String longNamePattern, String shortNamePattern, String indexNamePattern) {
        this.start = start;
        this.end = end;
        this.duration = duration;
        this.key = DateTimeFormat.forPattern((String)keyPattern).print((ReadableInstant)start);
        this.longName = DateTimeFormat.forPattern((String)longNamePattern).print((ReadableInstant)start);
        this.shortName = DateTimeFormat.forPattern((String)shortNamePattern).print((ReadableInstant)start);
        this.indexName = DateTimeFormat.forPattern((String)indexNamePattern).print((ReadableInstant)start);
    }

    public DateTime getStart() {
        return this.start;
    }

    public DateTime getEnd() {
        return this.end;
    }

    public DateTimeDuration getDuration() {
        return this.duration;
    }

    public String getKey() {
        return this.key;
    }

    public String getLongName() {
        return this.longName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public abstract DateTimePeriod getNext();

    public abstract DateTimePeriod getPrevious();

    public abstract DateTimeDuration getDefaultSubDuration();

    public List<DateTimePeriod> toPeriods(DateTimeDuration duration) {
        if (duration == DateTimeDuration.YEAR) {
            return this.toYears();
        }
        if (duration == DateTimeDuration.MONTH) {
            return this.toMonths();
        }
        if (duration == DateTimeDuration.DAY) {
            return this.toDays();
        }
        if (duration == DateTimeDuration.HOUR) {
            return this.toHours();
        }
        if (duration == DateTimeDuration.FIVE_MINUTES) {
            return this.toFiveMinutes();
        }
        throw new UnsupportedOperationException("Duration " + (Object)((Object)duration) + " not supported yet");
    }

    public List<DateTimePeriod> toFiveMinutes() {
        ArrayList<DateTimePeriod> list = new ArrayList<DateTimePeriod>();
        DateTime currentStart = this.getStart();
        DateTime nextStart = currentStart.plusMinutes(5);
        while (nextStart.isBefore((ReadableInstant)this.getEnd()) || nextStart.isEqual((ReadableInstant)this.getEnd())) {
            list.add(new DateTimeFiveMinutes(currentStart, nextStart));
            currentStart = nextStart;
            nextStart = currentStart.plusMinutes(5);
        }
        return list;
    }

    public List<DateTimePeriod> toHours() {
        ArrayList<DateTimePeriod> list = new ArrayList<DateTimePeriod>();
        DateTime currentStart = this.getStart();
        DateTime nextStart = currentStart.plusHours(1);
        while (nextStart.isBefore((ReadableInstant)this.getEnd()) || nextStart.isEqual((ReadableInstant)this.getEnd())) {
            list.add(new DateTimeHour(currentStart, nextStart));
            currentStart = nextStart;
            nextStart = currentStart.plusHours(1);
        }
        return list;
    }

    public List<DateTimePeriod> toDays() {
        ArrayList<DateTimePeriod> list = new ArrayList<DateTimePeriod>();
        DateTime currentStart = this.getStart();
        DateTime nextStart = currentStart.plusDays(1);
        while (nextStart.isBefore((ReadableInstant)this.getEnd()) || nextStart.isEqual((ReadableInstant)this.getEnd())) {
            list.add(new DateTimeDay(currentStart, nextStart));
            currentStart = nextStart;
            nextStart = currentStart.plusDays(1);
        }
        return list;
    }

    public List<DateTimePeriod> toMonths() {
        ArrayList<DateTimePeriod> list = new ArrayList<DateTimePeriod>();
        DateTime currentStart = this.getStart();
        DateTime nextStart = currentStart.plusMonths(1);
        while (nextStart.isBefore((ReadableInstant)this.getEnd()) || nextStart.isEqual((ReadableInstant)this.getEnd())) {
            list.add(new DateTimeMonth(currentStart, nextStart));
            currentStart = nextStart;
            nextStart = currentStart.plusMonths(1);
        }
        return list;
    }

    public List<DateTimePeriod> toYears() {
        ArrayList<DateTimePeriod> list = new ArrayList<DateTimePeriod>();
        DateTime currentStart = this.getStart();
        DateTime nextStart = currentStart.plusYears(1);
        while (nextStart.isBefore((ReadableInstant)this.getEnd()) || nextStart.isEqual((ReadableInstant)this.getEnd())) {
            list.add(new DateTimeYear(currentStart, nextStart));
            currentStart = nextStart;
            nextStart = currentStart.plusYears(1);
        }
        return list;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DateTimePeriod)) {
            throw new ClassCastException("Can only compare with other DateTimePeriod instances");
        }
        DateTimePeriod otherPeriod = (DateTimePeriod)object;
        if (this.start == null && otherPeriod.start != null) {
            return false;
        }
        if (this.end == null && otherPeriod.end != null) {
            return false;
        }
        if (this.start.equals((Object)otherPeriod.start) && this.end.equals((Object)otherPeriod.end)) {
            return true;
        }
        return true;
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + (this.start != null ? this.start.hashCode() : 0);
        hash = 59 * hash + (this.end != null ? this.end.hashCode() : 0);
        return hash;
    }

    public static DateTimePeriod create(DateTimeDuration duration, DateTime start) {
        if (duration == DateTimeDuration.YEAR) {
            return DateTimePeriod.createYear(start);
        }
        if (duration == DateTimeDuration.MONTH) {
            return DateTimePeriod.createMonth(start);
        }
        if (duration == DateTimeDuration.DAY) {
            return DateTimePeriod.createDay(start);
        }
        if (duration == DateTimeDuration.HOUR) {
            return DateTimePeriod.createHour(start);
        }
        if (duration == DateTimeDuration.FIVE_MINUTES) {
            return DateTimePeriod.createFiveMinutes(start);
        }
        throw new UnsupportedOperationException("Duration " + (Object)((Object)duration) + " not yet supported");
    }

    public static DateTimePeriod createYear(int year, DateTimeZone zone) {
        DateTime start = new DateTime(year, 1, 1, 0, 0, 0, 0, zone);
        return DateTimePeriod.createYear(start);
    }

    public static DateTimePeriod createYear(DateTime start) {
        DateTime end = start.plusYears(1);
        return new DateTimeYear(start, end);
    }

    public static DateTimePeriod createMonth(int year, int month, DateTimeZone zone) {
        DateTime start = new DateTime(year, month, 1, 0, 0, 0, 0, zone);
        return DateTimePeriod.createMonth(start);
    }

    public static DateTimePeriod createMonth(DateTime start) {
        DateTime end = start.plusMonths(1);
        return new DateTimeMonth(start, end);
    }

    public static DateTimePeriod createDay(int year, int month, int day, DateTimeZone zone) {
        DateTime start = new DateTime(year, month, day, 0, 0, 0, 0, zone);
        return DateTimePeriod.createDay(start);
    }

    public static DateTimePeriod createDay(DateTime start) {
        DateTime end = start.plusDays(1);
        return new DateTimeDay(start, end);
    }

    public static DateTimePeriod createHour(int year, int month, int day, int hour, DateTimeZone zone) {
        DateTime start = new DateTime(year, month, day, hour, 0, 0, 0, zone);
        return DateTimePeriod.createHour(start);
    }

    public static DateTimePeriod createHour(DateTime start) {
        DateTime end = start.plusHours(1);
        return new DateTimeHour(start, end);
    }

    public static DateTimePeriod createFiveMinutes(int year, int month, int day, int hour, int minute, DateTimeZone zone) {
        DateTime start = new DateTime(year, month, day, hour, minute, 0, 0, zone);
        return DateTimePeriod.createFiveMinutes(start);
    }

    public static DateTimePeriod createFiveMinutes(DateTime start) {
        DateTime end = start.plusMinutes(5);
        return new DateTimeFiveMinutes(start, end);
    }

    public static List<DateTimePeriod> createLastYearMonths(DateTimeZone zone) {
        ArrayList<DateTimePeriod> periods = new ArrayList<DateTimePeriod>();
        DateTime now = new DateTime(zone);
        for (int i = 0; i < 12; ++i) {
            DateTimePeriod period = DateTimePeriod.createMonth(now.getYear(), now.getMonthOfYear(), zone);
            periods.add(period);
            now = now.minusMonths(1);
        }
        return periods;
    }
}

